/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
RegExpLanguageHost,
PsiMetaOwner,
PsiMetaData,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlAttributeValueImpl.class);

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue((XmlAttributeValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public String getValue() {
        ASTNode endQuote;
        String text = this.getText();
        ASTNode startQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        if (startQuote != null) {
            text = StringUtil.trimStart((String)text, (String)startQuote.getText());
        }
        if ((endQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) != null) {
            text = StringUtil.trimEnd((String)text, (String)endQuote.getText());
        }
        return text;
    }

    public TextRange getValueTextRange() {
        TextRange range = this.getTextRange();
        String value = this.getValue();
        if (value.isEmpty()) {
            return range;
        }
        int start = range.getStartOffset() + this.getText().indexOf(value);
        int end = start + value.length();
        return new TextRange(start, end);
    }

    @NotNull
    public @NotNull Iterable<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        PsiReference[] references = this.getReferences();
        return references.length == 0 ? Collections.emptyList() : Arrays.asList(references);
    }

    public PsiReference @NotNull [] getReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)hints);
    }

    public boolean shouldAskParentForReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    public PsiReference @NotNull [] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public boolean isValidHost() {
        return this.getParent() instanceof XmlAttribute;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        try {
            String quoteChar = this.getTextLength() > 0 ? this.getText().substring(0, 1) : "";
            String contents = StringUtil.containsAnyChar((String)quoteChar, (String)"'\"") ? StringUtil.trimEnd((String)StringUtil.trimStart((String)text, (String)quoteChar), (String)quoteChar) : text;
            XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(StringUtil.defaultIfEmpty(this.getParent() instanceof XmlAttribute ? ((XmlAttribute)this.getParent()).getName() : null, (String)"q"), contents, (PsiElement)this);
            XmlAttributeValue newValue = newAttribute.getValueElement();
            CheckUtil.checkWritable((PsiElement)this);
            this.replaceAllChildrenToChildrenOf(newValue.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        return new XmlAttributeLiteralEscaper(this);
    }

    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getValue();
    }

    public String getName() {
        return this.getValue();
    }

    public void init(PsiElement element) {
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentationWithSeparator(){

            public String getPresentableText() {
                return XmlAttributeValueImpl.this.getText();
            }

            public String getLocationString() {
                return SymbolPresentationUtil.getFilePathPresentation((PsiFile)XmlAttributeValueImpl.this.getContainingFile());
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public boolean characterNeedsEscaping(char c) {
        return c == ']' || c == '}';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return true;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return true;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category.startsWith("Is")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (String[] name : DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties()) {
            if (!name[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties();
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return DefaultRegExpPropertiesProvider.getInstance().getPropertyDescription(name);
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return DefaultRegExpPropertiesProvider.getInstance().getKnownCharacterClasses();
    }
}

