/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReference
implements PsiPolyVariantReference {
    private final NullableLazyValue<XmlAttributeDescriptor> myDescriptor = new NullableLazyValue<XmlAttributeDescriptor>(){

        protected XmlAttributeDescriptor compute() {
            return XmlAttributeReference.this.myAttribute.getDescriptor();
        }
    };
    private final XmlAttribute myAttribute;

    public XmlAttributeReference(@NotNull XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public XmlAttributeReference(@NotNull XmlAttributeImpl attribute) {
        this.myAttribute = attribute;
    }

    @NotNull
    public XmlAttribute getElement() {
        return this.myAttribute;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int parentOffset = this.myAttribute.getNameElement().getStartOffsetInParent();
        int nsLen = this.myAttribute.getNamespacePrefix().length();
        String realName = XmlAttributeImpl.getRealName(this.myAttribute);
        return new TextRange(parentOffset + (nsLen += nsLen > 0 && !realName.isEmpty() ? 1 : -nsLen), parentOffset + this.myAttribute.getNameElement().getTextLength());
    }

    public PsiElement resolve() {
        XmlAttributeDescriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDeclaration() : null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myAttribute.getName();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        XmlAttributeDescriptor descriptor = this.getDescriptor();
        return descriptor != null ? PsiElementResolveResult.createResults((Collection)descriptor.getDeclarations()) : ResolveResult.EMPTY_ARRAY;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        XmlAttributeDescriptorEx xmlAttributeDescriptorEx;
        String s;
        String newName = newElementName;
        if (this.getDescriptor() instanceof XmlAttributeDescriptorEx && (s = (xmlAttributeDescriptorEx = (XmlAttributeDescriptorEx)this.getDescriptor()).handleTargetRename(newElementName)) != null) {
            String prefix = this.myAttribute.getNamespacePrefix();
            newName = StringUtil.isEmpty((String)prefix) ? s : prefix + ":" + s;
        }
        return this.myAttribute.setName(newName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMetaOwner owner;
        if (element instanceof PsiMetaOwner && (owner = (PsiMetaOwner)element).getMetaData() instanceof XmlElementDescriptor) {
            this.myAttribute.setName(owner.getMetaData().getName());
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiManager manager = this.getElement().getManager();
        return ContainerUtil.exists((Object[])this.multiResolve(false), result -> result.isValidResult() && manager.areElementsEquivalent(element, result.getElement()));
    }

    public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.getDescriptor() == null;
    }

    @Nullable
    protected XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)this.myDescriptor.getValue();
    }
}

