/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeLiteralEscaper
extends LiteralTextEscaper<XmlAttributeValueImpl> {
    private final XmlAttribute myXmlAttribute;

    public XmlAttributeLiteralEscaper(@NotNull XmlAttributeValueImpl host) {
        super((PsiLanguageInjectionHost)host);
        PsiElement parent = host.getParent();
        this.myXmlAttribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : XmlElementFactory.getInstance((Project)host.getProject()).createAttribute("a", host.getValue(), parent);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int startInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset() - valueTextRange.getStartOffset());
        int endInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getEndOffset() - valueTextRange.getStartOffset());
        String displayValue = this.myXmlAttribute.getDisplayValue();
        if ((startInDecoded = Math.max(0, Math.min(startInDecoded, displayValue.length()))) > (endInDecoded = Math.max(0, Math.min(endInDecoded, displayValue.length())))) {
            endInDecoded = startInDecoded;
        }
        outChars.append(displayValue, startInDecoded, endInDecoded);
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int displayStart = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset() - valueTextRange.getStartOffset());
        int dp = this.myXmlAttribute.displayToPhysical(offsetInDecoded + displayStart);
        if (dp == -1) {
            return -1;
        }
        return dp + valueTextRange.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        return this.myXmlAttribute.getValueTextRange();
    }
}

