/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNSDescriptorImpl
implements XmlNSDescriptor,
DumbAware,
XmlNSTypeDescriptorProvider {
    private final XmlNSDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;
    private static final SimpleFieldCache<Map<String, HtmlElementDescriptorImpl>, HtmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<Map<String, HtmlElementDescriptorImpl>, HtmlNSDescriptorImpl>(){

        protected Map<String, HtmlElementDescriptorImpl> compute(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.doBuildCachedMap();
        }

        protected Map<String, HtmlElementDescriptorImpl> getValue(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.myCachedDecls;
        }

        protected void putValue(Map<String, HtmlElementDescriptorImpl> map, HtmlNSDescriptorImpl htmlNSDescriptor) {
            htmlNSDescriptor.myCachedDecls = map;
        }
    };
    private volatile Map<String, HtmlElementDescriptorImpl> myCachedDecls;

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate) {
        this(_delegate, _delegate instanceof RelaxedHtmlNSDescriptor, false);
    }

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    @Nullable
    public static XmlAttributeDescriptor getCommonAttributeDescriptor(@NotNull String attributeName, @Nullable XmlTag context) {
        XmlElementDescriptor descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context);
        if (descriptor != null) {
            return descriptor.getAttributeDescriptor(attributeName, context);
        }
        return null;
    }

    public static XmlAttributeDescriptor @NotNull [] getCommonAttributeDescriptors(XmlTag context) {
        XmlElementDescriptor descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context);
        if (descriptor != null) {
            return descriptor.getAttributesDescriptors(context);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public static XmlElementDescriptor guessTagForCommonAttributes(@Nullable XmlTag context) {
        if (context == null) {
            return null;
        }
        XmlNSDescriptor nsDescriptor = context.getNSDescriptor(context.getNamespace(), false);
        if (nsDescriptor instanceof HtmlNSDescriptorImpl) {
            XmlElementDescriptor descriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("div");
            descriptor = descriptor == null ? ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("span") : descriptor;
            return descriptor;
        }
        return null;
    }

    private Map<String, HtmlElementDescriptorImpl> buildDeclarationMap() {
        return (Map)myCachedDeclsCache.get((Object)this);
    }

    private HashMap<String, HtmlElementDescriptorImpl> doBuildCachedMap() {
        XmlElementDescriptor[] elements;
        HashMap<String, HtmlElementDescriptorImpl> decls = new HashMap<String, HtmlElementDescriptorImpl>();
        for (XmlElementDescriptor element : elements = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(null)) {
            decls.put(element.getName(), new HtmlElementDescriptorImpl(element, this.myRelaxed, this.myCaseSensitive));
        }
        return decls;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor xmlElementDescriptor = this.getElementDescriptorByName(tag.getLocalName());
        if (xmlElementDescriptor == null && this.myRelaxed) {
            xmlElementDescriptor = this.myDelegate.getElementDescriptor(tag);
        }
        return xmlElementDescriptor;
    }

    private XmlElementDescriptor getElementDescriptorByName(String name) {
        if (!this.myCaseSensitive) {
            name = StringUtil.toLowerCase((String)name);
        }
        return this.buildDeclarationMap().get(name);
    }

    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document) {
        if (this.myDelegate == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        if (document != null) {
            return this.myDelegate.getRootElementsDescriptors(document);
        }
        return (XmlElementDescriptor[])this.buildDeclarationMap().values().stream().map(HtmlElementDescriptorImpl::getDelegate).toArray(XmlElementDescriptor[]::new);
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDelegate == null ? null : this.myDelegate.getDescriptorFile();
    }

    public PsiElement getDeclaration() {
        return this.myDelegate == null ? null : this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate == null ? "" : this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate == null ? "" : this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    public Object @NotNull [] getDependencies() {
        return this.myDelegate == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : this.myDelegate.getDependencies();
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(name, context) : null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)this.myDelegate).getTypeDescriptor(descriptorTag) : null;
    }
}

