/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagBlock
extends AbstractXmlBlock {
    private final Indent myIndent;

    public XmlTagBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
        super(node, wrap, alignment, policy, false);
        this.myIndent = indent;
    }

    public XmlTagBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean preserveSpace) {
        super(node, wrap, alignment, policy, preserveSpace);
        this.myIndent = indent;
    }

    protected List<Block> buildChildren() {
        ASTNode child = this.myNode.getFirstChildNode();
        Wrap attrWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Wrap textWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getTextWrap(this.getTag())), (boolean)true);
        Wrap tagBeginWrap = this.createTagBeginWrapping(this.getTag());
        Alignment attrAlignment = Alignment.createAlignment();
        Alignment textAlignment = Alignment.createAlignment();
        ArrayList<Block> result = new ArrayList<Block>(3);
        ArrayList<Object> localResult = new ArrayList<Block>(1);
        boolean insideTag = true;
        while (child != null) {
            if (!XmlTagBlock.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Wrap wrap = this.chooseWrap(child, tagBeginWrap, attrWrap, textWrap);
                Alignment alignment = this.chooseAlignment(child, attrAlignment, textAlignment);
                if (child.getElementType() == XmlTokenType.XML_TAG_END) {
                    child = this.processChild(localResult, child, wrap, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                    insideTag = true;
                } else if (child.getElementType() == XmlTokenType.XML_START_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result.add(this.createTagContentNode(localResult));
                    }
                    localResult = new ArrayList(1);
                    child = this.processChild(localResult, child, wrap, alignment, null);
                } else if (child.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result.add(this.createTagContentNode(localResult));
                        localResult = new ArrayList(1);
                    }
                    child = this.processChild(localResult, child, wrap, alignment, null);
                } else if (child.getElementType() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    child = this.processChild(localResult, child, wrap, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                } else if (this.isTagListStart(child.getElementType())) {
                    child = this.processChild(localResult, child, wrap, alignment, null);
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                    insideTag = true;
                } else if (this.isTagListEnd(child.getElementType())) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result.add(this.createTagContentNode(localResult));
                        localResult = new ArrayList(1);
                    }
                    child = this.processChild(localResult, child, wrap, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                } else if (this.isJspxJavaContainingNode(child)) {
                    this.createJspTextNode(localResult, child, this.getChildIndent());
                } else {
                    Object indent = this.isJspResult(localResult) ? this.getChildrenIndent() : (!insideTag ? null : this.getChildrenIndent());
                    child = this.processChild((List<Block>)localResult, child, wrap, alignment, (Indent)indent);
                }
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
        if (!localResult.isEmpty()) {
            result.add(this.createTagContentNode(localResult));
        }
        return result;
    }

    protected boolean isTagListEnd(IElementType elementType) {
        return false;
    }

    protected boolean isTagListStart(IElementType elementType) {
        return false;
    }

    protected boolean isJspResult(ArrayList<Block> localResult) {
        return false;
    }

    @Override
    @Nullable
    protected ASTNode processChild(List<Block> result, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        IElementType type = child.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            SmartList injections = new SmartList();
            if (this.buildInjectedPsiBlocks((List<Block>)injections, child, wrap, alignment, indent)) {
                SmartList regular = new SmartList();
                this.createXmlTextBlocks((List<Block>)regular, child, wrap, alignment);
                this.combineRegularBlocksWithInjected(child, result, (List<Block>)injections, (List<Block>)regular);
                return child;
            }
            return this.createXmlTextBlocks(result, child, wrap, alignment);
        }
        if (type == XmlElementType.XML_COMMENT) {
            if (this.buildInjectedPsiBlocks(result, child, wrap, alignment, indent)) {
                return child;
            }
            return super.processChild(result, child, wrap, alignment, indent);
        }
        return super.processChild(result, child, wrap, alignment, indent);
    }

    private void combineRegularBlocksWithInjected(@NotNull ASTNode injectionHost, @NotNull List<Block> result, @NotNull List<Block> withInjections, @NotNull List<Block> regularBlocks) {
        int i = 0;
        int j = 0;
        int injectionHostOffset = injectionHost.getStartOffset();
        ArrayList<TextRange> injectedRanges = new ArrayList<TextRange>(withInjections.size());
        Int2ObjectOpenHashMap injectedBlocksMap = new Int2ObjectOpenHashMap();
        boolean lastInjected = true;
        int lastOffset = 0;
        for (Block block : withInjections) {
            TextRange range = block.getTextRange();
            if (block instanceof AnotherLanguageBlockWrapper) {
                injectedRanges.add(range);
                injectedBlocksMap.put(range.getStartOffset(), (Object)block);
                lastInjected = true;
                continue;
            }
            if (!lastInjected) {
                int offset = range.getStartOffset();
                injectedRanges.add(new TextRange(lastOffset, offset));
            }
            lastOffset = range.getEndOffset();
            lastInjected = false;
        }
        int injectedRangesCount = injectedRanges.size();
        while (i < regularBlocks.size()) {
            Block reg = regularBlocks.get(i);
            if (j < injectedRangesCount) {
                TextRange nextRange;
                TextRange injRange = (TextRange)injectedRanges.get(j);
                TextRange regRange = reg.getTextRange();
                if (regRange.getEndOffset() <= injRange.getStartOffset()) {
                    result.add(reg);
                    ++i;
                    continue;
                }
                if (injRange.getStartOffset() <= regRange.getStartOffset() && regRange.getEndOffset() <= injRange.getEndOffset()) {
                    ++i;
                    continue;
                }
                if (regRange.getStartOffset() < injRange.getStartOffset()) {
                    ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(injRange.getStartOffset() - 1 - injectionHostOffset), (Object)injectionHost);
                    result.add((Block)this.createSimpleChild(node, reg.getIndent(), reg.getWrap(), reg.getAlignment(), new TextRange(regRange.getStartOffset(), injRange.getStartOffset())));
                    if (regRange.getEndOffset() <= injRange.getEndOffset()) {
                        ++i;
                        continue;
                    }
                }
                ContainerUtil.addIfNotNull(result, (Object)injectedBlocksMap.get(injRange.getStartOffset()));
                ++j;
                if (regRange.getStartOffset() >= injRange.getEndOffset()) continue;
                int lastInjection = injRange.getEndOffset();
                while (j < injectedRangesCount && (nextRange = (TextRange)injectedRanges.get(j)).getStartOffset() < regRange.getEndOffset()) {
                    if (lastInjection < nextRange.getStartOffset()) {
                        ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(lastInjection - injectionHostOffset), (Object)injectionHost);
                        result.add((Block)this.createSimpleChild(node, reg.getIndent(), null, reg.getAlignment(), new TextRange(lastInjection, nextRange.getStartOffset())));
                    }
                    if ((lastInjection = nextRange.getEndOffset()) > regRange.getEndOffset()) break;
                    ContainerUtil.addIfNotNull(result, (Object)injectedBlocksMap.get(nextRange.getStartOffset()));
                    ++j;
                }
                if (lastInjection < regRange.getEndOffset()) {
                    ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(lastInjection - injectionHostOffset), (Object)injectionHost);
                    result.add((Block)this.createSimpleChild(node, reg.getIndent(), null, reg.getAlignment(), new TextRange(lastInjection, regRange.getEndOffset())));
                }
                ++i;
                continue;
            }
            result.add(reg);
            ++i;
        }
        while (j < injectedRangesCount) {
            ContainerUtil.addIfNotNull(result, (Object)injectedBlocksMap.get(((TextRange)injectedRanges.get(j++)).getStartOffset()));
        }
    }

    protected Indent getChildrenIndent() {
        return this.myXmlFormattingPolicy.indentChildrenOf(this.getTag()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    private ASTNode createXmlTextBlocks(List<Block> list, ASTNode textNode, Wrap wrap, Alignment alignment) {
        ASTNode child = textNode.getFirstChildNode();
        return this.createXmlTextBlocks(list, textNode, child, wrap, alignment);
    }

    private ASTNode createXmlTextBlocks(List<Block> list, ASTNode textNode, ASTNode child, Wrap wrap, Alignment alignment) {
        while (child != null) {
            if (!AbstractXmlBlock.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.getChildrenIndent();
                if ((child = this.processChild(list, child, wrap, alignment, indent)) == null) {
                    return child;
                }
                if (child.getTreeParent() != textNode) {
                    if (child.getTreeParent() != this.myNode) {
                        return this.createXmlTextBlocks(list, child.getTreeParent(), child.getTreeNext(), wrap, alignment);
                    }
                    return child;
                }
            }
            child = child.getTreeNext();
        }
        return textNode;
    }

    private Block createTagContentNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, this.getChildrenIndent());
    }

    protected Block createSyntheticBlock(ArrayList<Block> localResult, Indent childrenIndent) {
        return new SyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
    }

    private Block createTagDescriptionNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, null);
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (this.isPreserveSpace()) {
            return Spacing.getReadOnlySpacing();
        }
        if (child1 instanceof AbstractSyntheticBlock && child2 instanceof AbstractSyntheticBlock) {
            return this.getSpacing((AbstractSyntheticBlock)child1, (AbstractSyntheticBlock)child2);
        }
        return null;
    }

    protected Spacing getSpacing(AbstractSyntheticBlock syntheticBlock1, AbstractSyntheticBlock syntheticBlock2) {
        boolean saveSpacesBetweenTagAndText;
        XmlTag startTag;
        if (syntheticBlock2.startsWithCDATA() || syntheticBlock1.endsWithCDATA()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock1.containsCDATA() && syntheticBlock2.isTagDescription() || syntheticBlock1.isTagDescription() && syntheticBlock2.containsCDATA()) {
            int lineFeeds = 0;
            switch (this.myXmlFormattingPolicy.getWhiteSpaceAroundCDATAOption()) {
                case 1: {
                    break;
                }
                case 2: {
                    lineFeeds = 1;
                    break;
                }
                case 0: {
                    return Spacing.getReadOnlySpacing();
                }
                default: {
                    assert (false) : "Unexpected whitespace around CDATA code style option.";
                    break;
                }
            }
            return Spacing.createSpacing((int)0, (int)0, (int)lineFeeds, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.isJspTextBlock() || syntheticBlock1.isJspTextBlock()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.isJspxTextBlock() || syntheticBlock1.isJspxTextBlock()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag())) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock2.startsWithTag() && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(startTag = syntheticBlock2.getStartTag()) && startTag.textContains('\n')) {
            return this.getChildrenIndent() != Indent.getNoneIndent() ? Spacing.getReadOnlySpacing() : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && syntheticBlock1.getTextRange().getEndOffset() < syntheticBlock2.getTextRange().getStartOffset();
        if (syntheticBlock1.endsWithTextElement() && syntheticBlock2.startsWithTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithText()) {
            if (syntheticBlock1.insertLineFeedAfter()) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.getTag().getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.startsWithText()) {
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.startsWithTag()) {
            return Spacing.createSpacing((int)0, (int)0, (int)(this.myXmlFormattingPolicy.insertLineBreakAfterTagBegin(this.getTag()) ? 2 : 0), (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.insertLineFeedAfter()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithTag() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)(this.myXmlFormattingPolicy.insertLineBreakAfterTagBegin(this.getTag()) ? 2 : 0), (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(true, true);
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.insertLineBreakBeforeTag(this.getTag());
    }

    @Override
    public int getBlankLinesBeforeTag() {
        return this.myXmlFormattingPolicy.getBlankLinesBeforeTag(this.getTag());
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.removeLineBreakBeforeTag(this.getTag());
    }

    @Override
    public boolean isTextElement() {
        return this.myXmlFormattingPolicy.isTextElement(this.getTag());
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.isAfterAttribute(newChildIndex)) {
            List subBlocks = this.getSubBlocks();
            Block subBlock = (Block)subBlocks.get(newChildIndex - 1);
            int prevSubBlockChildrenCount = subBlock.getSubBlocks().size();
            return subBlock.getChildAttributes(prevSubBlockChildrenCount);
        }
        if (this.myXmlFormattingPolicy.indentChildrenOf(this.getTag())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    private boolean isAfterAttribute(int newChildIndex) {
        int index = newChildIndex - 1;
        List subBlocks = this.getSubBlocks();
        Block prevBlock = index < subBlocks.size() ? (Block)subBlocks.get(index) : null;
        return prevBlock instanceof SyntheticBlock && ((SyntheticBlock)prevBlock).endsWithAttribute();
    }
}

