/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyAdapter;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class XmlWhiteSpaceFormattingStrategy
extends WhiteSpaceFormattingStrategyAdapter {
    private static void addWhitespaceToTagBody(ASTNode treePrev, LeafElement whiteSpaceElement) {
        boolean before;
        XmlText xmlText;
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)treePrev);
        ASTNode treeParent = treePrev.getTreeParent();
        if (treePrev.getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getPsi();
            before = true;
        } else if (treePrev.getTreePrev().getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getTreePrev().getPsi();
            before = false;
        } else {
            xmlText = (XmlText)Factory.createCompositeElement((IElementType)XmlElementType.XML_TEXT, (CharTable)charTable, (PsiManager)treeParent.getPsi().getManager());
            CodeEditUtil.setNodeGenerated((ASTNode)xmlText.getNode(), (boolean)true);
            treeParent.addChild(xmlText.getNode(), treePrev);
            before = true;
        }
        ASTNode node = xmlText.getNode();
        assert (node != null);
        TreeElement anchorInText = (TreeElement)(before ? node.getFirstChildNode() : node.getLastChildNode());
        if (anchorInText == null) {
            node.addChild((ASTNode)whiteSpaceElement);
        } else if (anchorInText.getElementType() != XmlTokenType.XML_WHITE_SPACE) {
            node.addChild((ASTNode)whiteSpaceElement, (ASTNode)(before ? anchorInText : null));
        } else {
            String text = before ? whiteSpaceElement.getText() + anchorInText.getText() : anchorInText.getText() + whiteSpaceElement.getText();
            node.replaceChild((ASTNode)anchorInText, (ASTNode)ASTFactory.whitespace((CharSequence)text));
        }
    }

    protected boolean isInsideTagBody(@NotNull ASTNode place) {
        ASTNode treeParent = place.getTreeParent();
        if (!(treeParent.getElementType() instanceof IXmlTagElementType)) {
            return false;
        }
        while (place != null) {
            if (place.getElementType() == XmlTokenType.XML_TAG_END) {
                return true;
            }
            place = place.getTreePrev();
        }
        return false;
    }

    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (this.isInsideTagBody(treePrev)) {
            XmlWhiteSpaceFormattingStrategy.addWhitespaceToTagBody(treePrev, whiteSpaceElement);
            return true;
        }
        return false;
    }

    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        return node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS && node.getText().trim().length() == 0;
    }
}

