/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.SorterUtil;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.html.structureView.Html5SectionsNodeProvider;
import com.intellij.lang.html.structureView.HtmlFileTreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.PlaceHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlStructureViewTreeModel
extends XmlStructureViewTreeModel
implements PlaceHolder<String> {
    private final Collection<NodeProvider> myNodeProviders = Collections.singletonList(new Html5SectionsNodeProvider());
    private String myStructureViewPlace;
    private static final Sorter HTML_ALPHA_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = SorterUtil.getStringPresentation((Object)o1);
                    String s2 = SorterUtil.getStringPresentation((Object)o2);
                    if (this.isTagPresentation(s1, "head") && this.isTagPresentation(s2, "body")) {
                        return -1;
                    }
                    if (this.isTagPresentation(s1, "body") && this.isTagPresentation(s2, "head")) {
                        return 1;
                    }
                    return s1.compareToIgnoreCase(s2);
                }

                private boolean isTagPresentation(String presentation, String tagName) {
                    String lowerCased = StringUtil.toLowerCase((String)presentation);
                    return lowerCased.startsWith(tagName) && (lowerCased.length() == tagName.length() || !Character.isLetter(lowerCased.charAt(tagName.length())));
                }
            };
        }

        public boolean isVisible() {
            return true;
        }

        public String toString() {
            return this.getName();
        }

        @NotNull
        public ActionPresentation getPresentation() {
            return new ActionPresentationData(PlatformEditorBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), PlatformEditorBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        @NotNull
        public String getName() {
            return "ALPHA_COMPARATOR";
        }
    };
    private static final Sorter[] ourSorters = new Sorter[]{HTML_ALPHA_SORTER};

    HtmlStructureViewTreeModel(XmlFile file, @Nullable Editor editor) {
        super(file, editor);
    }

    public void setPlace(@NotNull String place) {
        this.myStructureViewPlace = place;
    }

    public String getPlace() {
        return this.myStructureViewPlace;
    }

    @Override
    public Sorter @NotNull [] getSorters() {
        if (TreeStructureUtil.isInStructureViewPopup((PlaceHolder)this)) {
            return Sorter.EMPTY_ARRAY;
        }
        return ourSorters;
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        return this.myNodeProviders;
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        return new HtmlFileTreeElement(TreeStructureUtil.isInStructureViewPopup((PlaceHolder)this), this.getPsiFile());
    }
}

