/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Html5CustomAttributesIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> INDEX_ID = ID.create((String)"html5.custom.attributes.index");
    private final DataIndexer<String, Void, FileContent> myIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            CharSequence input = inputData.getContentAsText();
            Language language = ((LanguageFileType)inputData.getFileType()).getLanguage();
            if (language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE) {
                HtmlHighlightingLexer lexer = language == HTMLLanguage.INSTANCE ? new HtmlHighlightingLexer(FileTypeManager.getInstance().getStdFileType("CSS")) : new XHtmlHighlightingLexer();
                lexer.start(input);
                HashMap<String, Void> result = new HashMap<String, Void>();
                IElementType tokenType = lexer.getTokenType();
                while (tokenType != null) {
                    if (tokenType == XmlTokenType.XML_NAME) {
                        String xmlName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
                        if (HtmlUtil.isCustomHtml5Attribute(xmlName)) {
                            result.put(xmlName, null);
                        }
                    } else if (tokenType == XmlTokenType.XML_DOCTYPE_PUBLIC || tokenType == XmlTokenType.XML_DOCTYPE_SYSTEM) break;
                    lexer.advance();
                    tokenType = lexer.getTokenType();
                }
                return result;
            }
            return Collections.emptyMap();
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.HTML, StdFileTypes.XHTML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return file.isInLocalFileSystem();
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }
}

