/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", Collections.emptyMap());
    @NotNull
    private final String myKey;
    private TemplateImpl myTemplate;
    @NotNull
    private final Map<String, String> myAttributes;
    private final boolean myForceSingleTag;
    private PsiFile myFile;

    public TemplateToken(@NotNull String key) {
        this(key, Collections.emptyMap());
    }

    public TemplateToken(@NotNull String key, @NotNull Map<String, String> attribute2value) {
        this(key, attribute2value, false);
    }

    public TemplateToken(@NotNull String key, @NotNull Map<String, String> attribute2value, boolean forceSingleTag) {
        this.myKey = key;
        this.myAttributes = attribute2value;
        this.myForceSingleTag = forceSingleTag;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return this.myAttributes;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public String getTemplateText() {
        return this.myFile.getText();
    }

    private void setFile(PsiFile file) {
        this.myFile = file;
    }

    public boolean isForceSingleTag() {
        return this.myForceSingleTag;
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)this.myFile, XmlTag.class);
    }

    public void setTemplateText(@NotNull String templateText, @NotNull CustomTemplateCallback callback) {
        PsiFile file = PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)templateText, true, true);
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        this.setFile(file);
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    public void setTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        this.myTemplate = template;
        this.setTemplateText(TemplateToken.createTemplateText(template, callback, this.getAttributes()), callback);
    }

    private static boolean containsAttrsVar(@NotNull TemplateImpl template) {
        for (int i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String createTemplateText(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback, @NotNull Map<String, String> attributes) {
        PsiFile dummyFile;
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)(dummyFile = PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)templateString, false, true)), XmlTag.class)) != null && !attributes.isEmpty()) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        return dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString;
    }

    private static void addMissingAttributes(@NotNull XmlTag tag, @NotNull Map<String, String> attributes) {
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            XmlTag htmlTag;
            XmlAttribute newAttribute;
            if ("%default".equals(attribute.getKey()) || tag.getAttribute(attribute.getKey()) != null || (newAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])(htmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createHTMLTagFromText("<dummy " + attribute.getKey() + "=\"\"/>")).getAttributes())) == null) continue;
            tag.add((PsiElement)newAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public String toString() {
        return "TEMPLATE";
    }
}

