/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NotNull;

final class HtmlClosingTagErrorFilter
extends HighlightErrorFilter {
    HtmlClosingTagErrorFilter() {
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile.getViewProvider().getBaseLanguage() != HTMLLanguage.INSTANCE && HTMLLanguage.INSTANCE != element.getLanguage()) {
            return true;
        }
        return !HtmlClosingTagErrorFilter.skip(element);
    }

    public static boolean skip(@NotNull PsiErrorElement element) {
        PsiElement[] children = element.getChildren();
        return children.length > 0 && children[0] instanceof XmlToken && XmlTokenType.XML_END_TAG_START == ((XmlToken)children[0]).getTokenType() && XmlPsiBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]).equals(element.getErrorDescription());
    }
}

