/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance(XmlElementSignatureProvider.class);

    public String getSignature(@NotNull PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            PsiElement parent = tag.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("tag").append("#");
            String name = tag.getName();
            buffer.append(name.length() == 0 ? "<unnamed>" : XmlElementSignatureProvider.escape((String)name));
            buffer.append("#");
            int childIndex = XmlElementSignatureProvider.getChildIndex((PsiNamedElement)tag, (PsiElement)parent, (String)name, XmlTag.class);
            if (childIndex < 0) {
                return null;
            }
            buffer.append(childIndex);
            if (!(parent instanceof PsiFile)) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        return null;
    }

    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (type.equals("tag")) {
            String name = tokenizer.nextToken();
            if (parent instanceof XmlFile && (parent = ((XmlFile)parent).getDocument()) == null) {
                return null;
            }
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                String unescapedName = XmlElementSignatureProvider.unescape((String)name);
                PsiNamedElement result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)parent, (String)unescapedName, (int)index, XmlTag.class);
                if (result == null && file.getFileType() == StdFileTypes.JSP) {
                    if (parent instanceof XmlDocument) {
                        result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)HtmlUtil.getRealXmlDocument((XmlDocument)parent), (String)unescapedName, (int)index, XmlTag.class);
                    } else if (name.equals("<unnamed>") && parent != null) {
                        result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)parent, (String)"", (int)index, XmlTag.class);
                    }
                }
                return result;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

