/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlDefaultAttributeValueInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                PsiElement parent = value.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                if (parent.getParent() instanceof HtmlTag || HtmlUtil.isHtmlFile(parent.getParent())) {
                    return;
                }
                XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
                if (descriptor == null || descriptor.isRequired()) {
                    return;
                }
                String defaultValue = descriptor.getDefaultValue();
                if (defaultValue != null && defaultValue.equals(value.getValue()) && !value.getTextRange().isEmpty()) {
                    holder.registerProblem((PsiElement)value, XmlAnalysisBundle.message((String)"redundant.default.attribute.value.assignment", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveAttributeIntentionFix(((XmlAttribute)parent).getLocalName())});
                }
            }
        };
    }
}

