/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.XmlCodeStyleMainPanel;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.xml.XmlBundle;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, XmlLanguageCodeStyleSettingsProvider.getConfigurableDisplayNameText()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new XmlCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.globalcodestyle.xml";
            }
        };
    }

    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new XmlCodeStyleSettings(settings);
    }

    @NotNull
    public Language getLanguage() {
        return XMLLanguage.INSTANCE;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.xml.template");
        }
        return "";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        XmlLanguageCodeStyleSettingsProvider.customizeXml(consumer, settingsType);
    }

    static void customizeXml(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING"});
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_AT_FIRST_COLUMN.name(), CodeStyleSettingsCustomizable.CommenterOption.BLOCK_COMMENT_AT_FIRST_COLUMN.name()});
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        commonSettings.setForceArrangeMenuAvailable(true);
        if (PlatformUtils.isRubyMine()) {
            indentOptions.INDENT_SIZE = 2;
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject instanceof XmlCodeStyleSettings && "XML_WHITE_SPACE_AROUND_CDATA".equals(field.getName())) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"preserve", "none", "new_lines"});
        }
        return super.getAccessor(codeStyleObject, field);
    }

    public static String getConfigurableDisplayNameText() {
        return XmlBundle.message((String)"title.xml", (Object[])new Object[0]);
    }
}

