/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.fixtures.OCClangdTestUtil;
import com.jetbrains.cidr.lang.fixtures.OCFoundationCodeInsightTestCase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClangdCodeInsightTestCase
extends OCFoundationCodeInsightTestCase {
    private static final @NotNull Key<Function<@Nullable ClangdCompilationCommand, @Nullable ClangdCompilationCommand>> CC_ADJUSTER = Key.create((String)"OCClangdCodeInsightTestCase.CC_ADJUSTER");
    @NotNull
    private final List<Consumer<Project>> myOnStartActions = new ArrayList<Consumer<Project>>(2);

    public OCClangdCodeInsightTestCase() {
    }

    public OCClangdCodeInsightTestCase(@NotNull String relativeProjectPath) {
        super(relativeProjectPath);
    }

    public OCClangdCodeInsightTestCase(@NotNull String testFilesPath, @NotNull String testFilesExtension) {
        super(testFilesPath, testFilesExtension);
    }

    @Override
    protected boolean isLegacyTest() {
        return false;
    }

    @Override
    protected void startClangdIfNeeded(@NotNull Project project2) {
        project2.putUserData(ClangDaemonContext.IDE_FACADE_KEY, (Object)new CustomClangIdeFacade("main"));
        OCClangdTestUtil.setUp(project2, this.getTestRootDisposable(), () -> this.addSuppressedException(new RuntimeException("Server has crashed!")));
        for (Consumer<Project> action : this.myOnStartActions) {
            action.consume((Object)project2);
        }
    }

    protected void enableClangWarnings() {
        this.putNowOrLater(CidrCodeInsightFixture.ENABLE_CLANG_WARNINGS, true);
    }

    protected void disableClangErrors() {
        this.putNowOrLater(CidrCodeInsightFixture.DISABLE_CLANG_ERRORS, true);
    }

    private void putNowOrLater(@NotNull Key<Object> key, @Nullable Object value) {
        if (((OCMockProjectFixture)this.myProjectFixture).isProjectOpened()) {
            this.getProject().putUserData(key, value);
        } else {
            this.myOnStartActions.add((Consumer<Project>)((Consumer)project2 -> project2.putUserData(key, value)));
        }
    }

    protected void withClangWarnings(@NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        this.withUserData(runnable, CidrCodeInsightFixture.ENABLE_CLANG_WARNINGS, true);
    }

    protected void withoutClangErrors(@NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        this.withUserData(runnable, CidrCodeInsightFixture.DISABLE_CLANG_ERRORS, true);
    }

    protected void withCpp17(@NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        this.withCompileCommandsAdjuster(runnable, cc -> {
            ClionCompileCommandParams origParams = cc.ccParams;
            ArrayList<String> newCommandLine = new ArrayList<String>(origParams.getCommandLine());
            newCommandLine.add("-std=c++17");
            return new ClangdCompilationCommand(new ClionCompileCommandParams(origParams.getUri(), origParams.getEntryUri(), origParams.getDirectory(), newCommandLine, origParams.getOutput()), cc.ppDefines, cc.trustworthiness);
        });
    }

    protected void withCpp20(@NotNull ThrowableRunnable<? extends Exception> runnable) throws Exception {
        this.withCompileCommandsAdjuster(runnable, cc -> {
            ClionCompileCommandParams origParams = cc.ccParams;
            ArrayList<String> newCommandLine = new ArrayList<String>(origParams.getCommandLine());
            newCommandLine.add("-std=c++20");
            return new ClangdCompilationCommand(new ClionCompileCommandParams(origParams.getUri(), origParams.getEntryUri(), origParams.getDirectory(), newCommandLine, origParams.getOutput()), cc.ppDefines, cc.trustworthiness);
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void withCompileCommandsAdjuster(@NotNull ThrowableRunnable<? extends Exception> runnable, @NotNull Function<ClangdCompilationCommand, ClangdCompilationCommand> mapping) throws Exception {
        @Nullable @Nullable Function adjuster = (Function)this.getProject().getUserData(CC_ADJUSTER);
        if (adjuster != null) {
            mapping = mapping.compose(adjuster);
        }
        this.withUserData(runnable, CC_ADJUSTER, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void withUserData(@NotNull ThrowableRunnable<? extends Exception> runnable, @NotNull Key<T> key, @Nullable T value) throws Exception {
        Object previous = this.getProject().getUserData(key);
        try {
            this.getProject().putUserData(key, value);
            runnable.run();
        }
        finally {
            this.getProject().putUserData(key, previous);
        }
    }

    private static class CustomClangIdeFacade
    extends ClangIdeFacadeImpl {
        private CustomClangIdeFacade(@NotNull String descriptor) {
            super(descriptor);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable
        public ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project2, @NotNull VirtualFile file2, @NotNull String pathToMacrosFile) {
            ClangdCompilationCommand defaultCommand = super.getCompilationCommand(converter, project2, file2, pathToMacrosFile);
            @Nullable @Nullable Function mapping = (Function)project2.getUserData(CC_ADJUSTER);
            return mapping != null ? (ClangdCompilationCommand)mapping.apply(defaultCommand) : defaultCommand;
        }
    }
}

