/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.utils.parameterInfo.MockCreateParameterInfoContext;
import com.intellij.testFramework.utils.parameterInfo.MockParameterInfoUIContext;
import com.intellij.testFramework.utils.parameterInfo.MockUpdateParameterInfoContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInlineAsserts;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCParameterInfoHandlerTest<ParameterOwner extends PsiElement, ParameterType>
extends OCCodeInsightTestCase {
    public OCParameterInfoHandlerTest(String relativeTestDataPath) {
        super("parameter_info/" + relativeTestDataPath, "mm");
    }

    public static Hint hint(String hintText, boolean enabled) {
        int start = hintText.indexOf("<selection>");
        int end = hintText.indexOf("</selection>");
        if (start != -1 && end != -1) {
            hintText = hintText.replaceFirst("<selection>", "");
            hintText = hintText.replaceFirst("</selection>", "");
            return new Hint(hintText, enabled, start, end - "<selection>".length());
        }
        return new Hint(hintText, enabled, null, null);
    }

    public static Hint formattedHint(String hintText, boolean enabled) {
        int highlightEnd;
        String startTag = "<sel>";
        String endTag = "</sel>";
        int selStart = hintText.indexOf(startTag);
        int selEnd = hintText.indexOf(endTag);
        StringBuilder tb = new StringBuilder();
        if (selStart >= 0 && selEnd >= 0) {
            tb.append(hintText, 0, selStart);
            String current = hintText.substring(selStart + startTag.length(), selEnd);
            tb.append(current);
            tb.append(hintText.substring(selEnd + endTag.length()));
            highlightEnd = selStart + current.length();
        } else {
            tb.append(hintText);
            highlightEnd = -1;
        }
        return new Hint(tb.toString(), enabled, selStart, highlightEnd);
    }

    protected void assertInfo() throws Exception {
        final OCFile file2 = this.configureByFile();
        OCInlineAsserts.doAll(file2.getText(), new OCInlineAsserts.Assert(){

            @Override
            public void doAssert(@NotNull String text, @NotNull TextRange assertionRange, @NotNull String assertionText) {
                Hint[] hints;
                Editor editor = OCParameterInfoHandlerTest.this.getEditor();
                editor.getCaretModel().moveToOffset(assertionRange.getEndOffset());
                String hintsText = assertionText.trim();
                if (hintsText.isEmpty()) {
                    hints = null;
                } else if ("<empty>".equals(hintsText)) {
                    hints = new Hint[]{};
                } else {
                    Object[] hs = hintsText.trim().split("\\n");
                    hints = (Hint[])ContainerUtil.mapNotNull((Object[])hs, s -> {
                        char fc;
                        String h = s.trim();
                        boolean enabled = true;
                        if (!(h.isEmpty() || (fc = h.charAt(0)) != '+' && fc != '-')) {
                            h = h.substring(1).trim();
                            enabled = fc == '+';
                        }
                        return h.isEmpty() ? null : OCParameterInfoHandlerTest.formattedHint(h, enabled);
                    }, (Object[])new Hint[0]);
                }
                OCParameterInfoHandlerTest.assertInfo((PsiFile)file2, editor, null, OCParameterInfoHandlerTest.this.createHandler(), hints);
            }
        });
    }

    protected Object[] assertInfo(String definitions, String funBody, int currentParameterIndex, String hintText) {
        return this.assertInfo(definitions, funBody, currentParameterIndex, OCParameterInfoHandlerTest.hint(hintText, true));
    }

    protected Object[] assertInfo(String definitions, String funBody, int currentParameterIndex, Hint ... hints) {
        String text = definitions + " void __test_function() {  " + funBody + " }";
        return this.assertInfo(text, currentParameterIndex, hints);
    }

    protected Object[] assertInfo(String text, int currentParameterIndex, Hint ... hints) {
        OCPsiFile file2 = (OCPsiFile)this.myCodeInsightFixture.configureByText(text, "test.mm");
        return OCParameterInfoHandlerTest.assertInfo((PsiFile)file2, this.getEditor(), currentParameterIndex, this.createHandler(), hints);
    }

    protected abstract ParameterInfoHandler<ParameterOwner, ParameterType> createHandler();

    public static <ParameterOwner extends PsiElement, ParameterType> Object[] assertInfo(PsiFile file2, Editor editor, @Nullable Integer currentParameterIndex, ParameterInfoHandler<ParameterOwner, ParameterType> handler, Hint @Nullable [] hints) {
        MockCreateParameterInfoContext cCtx = new MockCreateParameterInfoContext(editor, file2);
        cCtx.setItemsToShow(new Object[]{"items from the previous handler"});
        PsiElement paramOwner = (PsiElement)handler.findElementForParameterInfo((CreateParameterInfoContext)cCtx);
        if (hints == null) {
            OCParameterInfoHandlerTest.assertNull((Object)paramOwner);
            return null;
        }
        OCParameterInfoHandlerTest.assertNotNull((Object)paramOwner);
        Object[] items = cCtx.getItemsToShow();
        OCParameterInfoHandlerTest.assertNotNull((Object)items);
        OCParameterInfoHandlerTest.assertEquals((int)hints.length, (int)items.length);
        MockUpdateParameterInfoContext updCtx = new MockUpdateParameterInfoContext(editor, file2, items);
        updCtx.setParameterOwner(paramOwner);
        paramOwner = (PsiElement)handler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)updCtx);
        OCParameterInfoHandlerTest.assertNotNull((Object)paramOwner);
        handler.updateParameterInfo((Object)paramOwner, (UpdateParameterInfoContext)updCtx);
        if (currentParameterIndex != null) {
            OCParameterInfoHandlerTest.assertEquals((int)currentParameterIndex, (int)updCtx.getCurrentParameter());
        }
        for (int i = 0; i < hints.length; ++i) {
            Integer highlightEnd;
            Hint hint = hints[i];
            boolean enabled = updCtx.isUIComponentEnabled(i);
            OCParameterInfoHandlerTest.assertEquals((String)("hint: " + hint.toString()), (boolean)hint.enabled, (boolean)enabled);
            MockParameterInfoUIContext uiCtx = new MockParameterInfoUIContext(paramOwner);
            uiCtx.setCurrentParameterIndex(updCtx.getCurrentParameter());
            uiCtx.setUIComponentEnabled(enabled);
            handler.updateUI(items[i], (ParameterInfoUIContext)uiCtx);
            OCParameterInfoHandlerTest.assertEquals((String)hint.text, (String)uiCtx.getText());
            Integer highlightStart = hint.highlightStart;
            OCParameterInfoHandlerTest.assertTrue((String)"current param should be checked with either currentParamIndex or hint highlighting", (highlightStart != null || currentParameterIndex != null ? 1 : 0) != 0);
            if (highlightStart != null) {
                OCParameterInfoHandlerTest.assertEquals((String)"highlight start", (int)highlightStart, (int)uiCtx.getHighlightStart());
            }
            if ((highlightEnd = hint.highlightEnd) == null) continue;
            OCParameterInfoHandlerTest.assertEquals((String)"highlight end", (int)highlightEnd, (int)uiCtx.getHighlightEnd());
        }
        return items;
    }

    protected void assertElementForUpdating() throws Exception {
        this.configureByFile();
        ParameterInfoHandler<ParameterOwner, ParameterType> handler = this.createHandler();
        final Ref ownerStartOffset = new Ref();
        Editor editor = this.getEditor();
        PsiFile file2 = this.getFile();
        MockCreateParameterInfoContext cCtx = new MockCreateParameterInfoContext(editor, file2){

            public void showHint(PsiElement element, int offset, ParameterInfoHandler handler) {
                super.showHint(element, offset, handler);
                ownerStartOffset.set((Object)offset);
            }
        };
        PsiElement owner = (PsiElement)handler.findElementForParameterInfo((CreateParameterInfoContext)cCtx);
        OCParameterInfoHandlerTest.assertNotNull((Object)owner);
        handler.showParameterInfo((Object)owner, (CreateParameterInfoContext)cCtx);
        MockUpdateParameterInfoContext updCtx = new MockUpdateParameterInfoContext(editor, file2){

            public int getParameterListStart() {
                return (Integer)ownerStartOffset.get();
            }
        };
        updCtx.setParameterOwner(owner);
        SelectionModel selectionModel = editor.getSelectionModel();
        OCParameterInfoHandlerTest.assertTrue((boolean)selectionModel.hasSelection());
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        this.assertElementForUpdating(handler, updCtx, startOffset - 1, null);
        for (int offset = startOffset; offset < endOffset; ++offset) {
            this.assertElementForUpdating(handler, updCtx, offset, owner);
        }
        this.assertElementForUpdating(handler, updCtx, endOffset, null);
    }

    private void assertElementForUpdating(@NotNull ParameterInfoHandler<ParameterOwner, ParameterType> handler, @NotNull MockUpdateParameterInfoContext updCtx, int offset, @Nullable ParameterOwner expected) {
        updCtx.getEditor().getCaretModel().moveToOffset(offset);
        OCParameterInfoHandlerTest.assertEquals((int)offset, (int)updCtx.getOffset());
        PsiElement o = (PsiElement)handler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)updCtx);
        OCParameterInfoHandlerTest.assertEquals(expected, (Object)o);
    }

    private OCFile configureByFile() throws Exception {
        String testName = this.getTestName(false);
        String nameSuffix = ".mm";
        int extensionIdx = testName.indexOf(95);
        if (extensionIdx > 0) {
            nameSuffix = "." + testName.substring(extensionIdx + 1);
            testName = testName.substring(0, extensionIdx);
        }
        return this.myCodeInsightFixture.configureByFile(testName, nameSuffix);
    }

    public static class Hint {
        final String text;
        final boolean enabled;
        final Integer highlightStart;
        final Integer highlightEnd;

        public Hint(String text, boolean enabled, Integer highlightStart, Integer highlightEnd) {
            this.text = text;
            this.enabled = enabled;
            this.highlightStart = highlightStart;
            this.highlightEnd = highlightEnd;
        }
    }
}

