/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.testFramework.MapDataContext;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.jetbrains.cidr.lang.ui.OCResolveContextPanel;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ConfigPanelAssert {
    private final OCResolveContextPanel myPanel;

    public ConfigPanelAssert(Project project2) {
        this.myPanel = (OCResolveContextPanel)WindowManager.getInstance().getStatusBar(project2).getWidget("ActiveOCBuildConfiguration");
        TestCase.assertNotNull((String)"resolve panel not found", (Object)this.myPanel);
    }

    public void assertPresentation(OCResolveContextPanel panel, boolean visible, String text) {
        TestCase.assertEquals((boolean)visible, (boolean)panel.getComponent().isVisible());
        TestCase.assertEquals((String)text, (String)ConfigPanelAssert.getText(panel));
    }

    public void assertConfigurations(List<OCResolveConfiguration> expectedConfigs, OCResolveConfiguration selectedConfig) {
        if (expectedConfigs.isEmpty()) {
            TestCase.assertNull((Object)selectedConfig);
        }
        String panelText = ConfigPanelAssert.getText(this.myPanel);
        Assert.assertThat((Object)panelText, (Matcher)CoreMatchers.endsWith((String)(": " + selectedConfig.getDisplayName())));
        ListPopupStep list = this.getPanelPopup().getListStep();
        ArrayList<OCResolveConfiguration> actualConfigs = new ArrayList<OCResolveConfiguration>();
        List actionList = list.getValues();
        boolean hasAutoSelect = false;
        for (int i = 0; i < actionList.size(); ++i) {
            AnAction action = ((PopupFactoryImpl.ActionItem)actionList.get(i)).getAction();
            if (action instanceof OCResolveContextPanel.AutoSelectItem) {
                Assert.assertEquals((long)0L, (long)i);
                hasAutoSelect = true;
                continue;
            }
            OCResolveConfiguration config = ((OCResolveContextPanel.ConfigurationItem)action).getConfig();
            actualConfigs.add(config);
        }
        Assert.assertEquals((Object)(actualConfigs.size() > 1 ? 1 : 0), (Object)hasAutoSelect);
        UsefulTestCase.assertOrderedEquals(actualConfigs, expectedConfigs);
        if (!expectedConfigs.isEmpty()) {
            int selectedConfigIndex = actualConfigs.indexOf(selectedConfig);
            TestCase.assertTrue((String)("config not found " + selectedConfig + " among " + expectedConfigs), (selectedConfigIndex >= 0 ? 1 : 0) != 0);
            TestCase.assertEquals((int)(selectedConfigIndex + (hasAutoSelect ? 1 : 0)), (int)list.getDefaultOptionIndex());
        }
    }

    public static String getText(OCResolveContextPanel panel) {
        return ((TextPanel)panel.getComponent()).getText();
    }

    public ListPopup getPanelPopup() {
        MapDataContext context = new MapDataContext();
        context.put(PlatformDataKeys.CONTEXT_COMPONENT, (Object)this.myPanel.getComponent());
        return this.myPanel.createPopup((DataContext)context);
    }

    public OCResolveContextPanel getPanel() {
        return this.myPanel;
    }

    public void scheduleUpdate(boolean immediately) {
        this.myPanel.updateInTests(immediately);
    }

    public void flushUpdate() {
        this.myPanel.flushUpdateInTests();
    }

    public void scheduleUpdate() {
        this.scheduleUpdate(true);
    }
}

