/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.UsefulTestCase;
import gnu.trove.THashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CidrProjectMarkup {
    private static final List<String> SUPPORTED_EXTENSIONS = Arrays.asList("c", "cpp", "m", "mm", "h", "strings", "storyboard", "swift", "asm", "s", "S");
    private final boolean myProcessAllFiles;
    public final Map<String, Integer> OFFSETS = new THashMap();

    public CidrProjectMarkup(@NotNull VirtualFile testProjectRoot, boolean processAllFiles) {
        this.myProcessAllFiles = processAllFiles;
        VfsUtilCore.processFilesRecursively((VirtualFile)testProjectRoot, file2 -> {
            try {
                this.processFile((VirtualFile)file2);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.assertAllFieldsSetup();
    }

    private void processFile(VirtualFile file2) throws Exception {
        String name;
        if (file2.isDirectory() || file2.getFileType().isBinary() || !SUPPORTED_EXTENSIONS.contains(file2.getExtension())) {
            return;
        }
        CharSequence text = LoadTextUtil.loadText((VirtualFile)file2);
        String[] lines = LineTokenizer.tokenize((CharSequence)text, (boolean)true);
        if (lines.length == 0) {
            return;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        boolean toProcess = false;
        for (Field eachField : fields) {
            eachField.setAccessible(true);
            name = eachField.getName();
            if (!name.startsWith("FILE_") || eachField.get(this) != null || !lines[0].contains(name)) continue;
            eachField.set(this, file2);
            toProcess = true;
            break;
        }
        if (!toProcess && !this.myProcessAllFiles) {
            return;
        }
        block1: for (Field eachField : fields) {
            eachField.setAccessible(true);
            name = eachField.getName();
            if (!name.startsWith("LINE_") || eachField.getInt(this) != 0) continue;
            Pattern pattern = Pattern.compile("\\b" + name + "\\b");
            int length = lines.length;
            for (int i = 0; i < length; ++i) {
                String eachLine = lines[i];
                if (!pattern.matcher(eachLine).find()) continue;
                eachField.setInt(this, i);
                continue block1;
            }
        }
        Matcher m = Pattern.compile("(<!--|/\\*)offset:(\\w*)(\\+(\\d*))?(-->|\\*/)").matcher(text);
        while (m.find()) {
            String label = m.group(2);
            int offset = m.end();
            String shiftStr = m.group(4);
            if (shiftStr != null) {
                offset += Integer.parseInt(shiftStr);
            }
            this.OFFSETS.put(label, offset);
        }
    }

    private void assertAllFieldsSetup() {
        ArrayList<String> notSet = new ArrayList<String>();
        for (Field each : this.getClass().getDeclaredFields()) {
            each.setAccessible(true);
            String name = each.getName();
            try {
                if (name.startsWith("FILE_") && each.get(this) == null) {
                    notSet.add(name);
                }
                if (!name.startsWith("LINE_") || each.getInt(this) != 0) continue;
                notSet.add(name);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        UsefulTestCase.assertEmpty(notSet);
    }

    public void deleteOffsetComment(@NotNull PsiFile file2, String ... keys) {
        int diff = 0;
        for (String key : keys) {
            int keySourceOffset = this.OFFSETS.get(key) - diff;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = documentManager.getDocument(file2);
            int newOffset = keySourceOffset - key.length() - "/*offset:*/".length();
            WriteCommandAction.runWriteCommandAction((Project)file2.getProject(), () -> {
                document.replaceString(newOffset, keySourceOffset, (CharSequence)"");
                documentManager.commitDocument(document);
            });
            this.OFFSETS.put(key, newOffset);
            diff += keySourceOffset - newOffset;
        }
    }
}

