/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.model.DomModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DomModelImpl<T extends DomElement>
implements DomModel<T> {
    protected final DomFileElement<T> myMergedModel;
    protected final Set<XmlFile> myConfigFiles;
    private Class<T> myClass;
    private Project myProject;

    @Deprecated
    public DomModelImpl(T mergedModel, @NotNull Set<XmlFile> configFiles) {
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(DomFileElement<T> mergedModel, @NotNull Set<XmlFile> configFiles) {
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(@NotNull Set<XmlFile> configFiles, Class<T> clazz, Project project2) {
        this.myProject = project2;
        this.myMergedModel = null;
        this.myConfigFiles = configFiles;
        this.myClass = clazz;
    }

    @Override
    @NotNull
    public T getMergedModel() {
        if (this.myMergedModel == null) {
            DomManager domManager = DomManager.getDomManager(this.myProject);
            return (T)((DomElement)domManager.createModelMerger().mergeModels(this.myClass, ContainerUtil.mapNotNull(this.myConfigFiles, (Function)((NullableFunction)xmlFile -> {
                DomFileElement<T> fileElement = domManager.getFileElement((XmlFile)xmlFile, this.myClass);
                return fileElement == null ? null : (DomElement)fileElement.getRootElement();
            }))));
        }
        return this.myMergedModel.getRootElement();
    }

    @Override
    @NotNull
    public Set<XmlFile> getConfigFiles() {
        return this.myConfigFiles;
    }

    @Override
    @NotNull
    public List<DomFileElement<T>> getRoots() {
        if (this.myMergedModel == null) {
            return ContainerUtil.mapNotNull(this.myConfigFiles, (Function)((NullableFunction)xmlFile -> DomManager.getDomManager(xmlFile.getProject()).getFileElement((XmlFile)xmlFile, this.myClass)));
        }
        return this.myMergedModel instanceof MergedObject ? ((MergedObject)((Object)this.myMergedModel)).getImplementations() : Collections.singletonList(this.myMergedModel);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }
}

