/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.NameValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementPresentationManager {
    private static final ConcurrentMap<Class, Optional<Method>> ourNameValueMethods = ConcurrentFactoryMap.create(key -> ReflectionUtil.getClassPublicMethods((Class)key).stream().filter(method -> JavaMethod.getMethod(key, method).getAnnotation(NameValue.class) != null).findFirst(), ContainerUtil::createConcurrentWeakKeySoftValueMap);
    private static final Function<Object, String> DEFAULT_NAMER = element -> ElementPresentationManager.getElementName(element);
    private static final List<Function<Object, String>> ourNameProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Object, String>> ourDocumentationProviders = new ArrayList<Function<Object, String>>();
    public static final NullableFunction<Object, String> NAMER = o -> ElementPresentationManager.getElementName(o);

    public static ElementPresentationManager getInstance() {
        return (ElementPresentationManager)ServiceManager.getService(ElementPresentationManager.class);
    }

    public <T> Object @NotNull [] createVariants(Collection<T> elements) {
        return this.createVariants(elements, DEFAULT_NAMER);
    }

    public <T> Object @NotNull [] createVariants(Collection<T> elements, int iconFlags) {
        return this.createVariants(elements, DEFAULT_NAMER, iconFlags);
    }

    public <T> Object @NotNull [] createVariants(Collection<? extends T> elements, Function<? super T, String> namer) {
        return this.createVariants(elements, namer, 0);
    }

    @Deprecated
    public abstract Object createVariant(Object var1, String var2, PsiElement var3);

    public abstract <T> Object @NotNull [] createVariants(Collection<? extends T> var1, Function<? super T, String> var2, int var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static void registerNameProvider(Function<Object, String> function) {
        ourNameProviders.add(function);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static void registerDocumentationProvider(Function<Object, String> function) {
        ourDocumentationProviders.add(function);
    }

    public static <T> NullableFunction<T, String> NAMER() {
        return o -> ElementPresentationManager.getElementName(o);
    }

    public static <T> NullableFunction<T, String> namer() {
        return NAMER;
    }

    @Nullable
    public static String getElementName(@NotNull Object element) {
        String s;
        for (Function<Object, String> function : ourNameProviders) {
            s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        Object o = ElementPresentationManager.invokeNameValueMethod(element);
        if (o == null || o instanceof String) {
            return (String)o;
        }
        if (o instanceof GenericValue) {
            Object value;
            GenericValue gv = (GenericValue)o;
            s = gv.getStringValue();
            if (s == null && (value = gv.getValue()) != null) {
                return String.valueOf(value);
            }
            return s;
        }
        return null;
    }

    @Nullable
    public static String getDocumentationForElement(Object element) {
        for (Function<Object, String> function : ourDocumentationProviders) {
            String s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static Object invokeNameValueMethod(@NotNull Object element) {
        return ((Optional)ourNameValueMethods.get(element.getClass())).map(method -> DomReflectionUtil.invokeMethod(method, element, new Object[0])).orElse(null);
    }

    public static String getTypeNameForObject(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        o = firstImpl != null ? firstImpl : o;
        String typeName = TypePresentationService.getService().getTypeName(o);
        if (typeName != null) {
            return typeName;
        }
        if (o instanceof DomElement) {
            DomElement element = (DomElement)o;
            return StringUtil.capitalizeWords((String)element.getNameStrategy().splitIntoWords(element.getXmlElementName()), (boolean)true);
        }
        return TypePresentationService.getDefaultTypeName(o.getClass());
    }

    public static Icon getIcon(@NotNull Object o) {
        Icon icon;
        if (o instanceof Iconable && (icon = ((Iconable)o).getIcon(2)) != null) {
            return icon;
        }
        if (o instanceof DomElement) {
            return ((DomElement)o).getPresentation().getIcon();
        }
        return ElementPresentationManager.getIconOld(o);
    }

    @Nullable
    public static Icon getIconOld(Object o) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(o.getClass(), o));
    }

    @Nullable
    private static <T> T getFirst(T @Nullable [] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    @Nullable
    public static Icon getIconForClass(Class clazz) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(clazz, null));
    }

    private static Icon @Nullable [] getIconsForClass(Class clazz, @Nullable Object o) {
        Icon icon;
        TypePresentationService service = TypePresentationService.getService();
        Icon icon2 = icon = o == null ? service.getTypeIcon(clazz) : service.getIcon(o);
        if (icon != null) {
            return new Icon[]{icon};
        }
        return null;
    }

    @Nullable
    public static <T> T findByName(Collection<T> collection, String name) {
        return (T)ContainerUtil.find(collection, object -> Comparing.equal((String)name, (String)ElementPresentationManager.getElementName(object), (boolean)true));
    }
}

