/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaModuleFixtureBuilderImpl<T extends ModuleFixture>
extends ModuleFixtureBuilderImpl<T>
implements JavaModuleFixtureBuilder<T> {
    private final List<Lib> myLibraries = new ArrayList<Lib>();
    private String myJdk;
    private JavaModuleFixtureBuilder.MockJdkLevel myMockJdkLevel = JavaModuleFixtureBuilder.MockJdkLevel.jdk14;
    private LanguageLevel myLanguageLevel;

    public JavaModuleFixtureBuilderImpl(@NotNull TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(StdModuleTypes.JAVA, fixtureBuilder);
    }

    public JavaModuleFixtureBuilderImpl(ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(moduleType, fixtureBuilder);
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
        return this;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibrary(String libraryName, String ... classPath) {
        for (String path : classPath) {
            if (new File(path).exists()) continue;
            System.out.println(path + " does not exist");
        }
        Map<OrderRootType, String[]> map = Collections.singletonMap(OrderRootType.CLASSES, classPath);
        this.myLibraries.add(new Lib(libraryName, map));
        return this;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibrary(@NonNls String libraryName, @NotNull Map<OrderRootType, String[]> roots) {
        this.myLibraries.add(new Lib(libraryName, roots));
        return this;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibraryJars(String libraryName, @NotNull String basePath, String ... jars) {
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        String[] classPath = ArrayUtil.newStringArray((int)jars.length);
        for (int i = 0; i < jars.length; ++i) {
            classPath[i] = basePath + jars[i];
        }
        return this.addLibrary(libraryName, classPath);
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addJdk(@NotNull String jdkPath) {
        this.myJdk = jdkPath;
        return this;
    }

    @Override
    public void setMockJdkLevel(@NotNull JavaModuleFixtureBuilder.MockJdkLevel level) {
        this.myMockJdkLevel = level;
    }

    protected void initModule(Module module) {
        super.initModule(module);
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            Sdk jdk;
            LibraryTable libraryTable = model.getModuleLibraryTable();
            for (Lib lib : this.myLibraries) {
                Library library = libraryTable.createLibrary(lib.getName());
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                boolean success = false;
                try {
                    for (OrderRootType rootType : OrderRootType.getAllTypes()) {
                        for (String root : lib.getRoots(rootType)) {
                            VirtualFile jar;
                            VirtualFile vRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                            if (vRoot != null && OrderRootType.CLASSES.equals((Object)rootType) && !vRoot.isDirectory() && (jar = JarFileSystem.getInstance().refreshAndFindFileByPath(root + "!/")) != null) {
                                vRoot = jar;
                            }
                            if (vRoot == null) continue;
                            libraryModel.addRoot(vRoot, rootType);
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        Disposer.dispose((Disposable)libraryModel);
                    }
                }
                libraryModel.commit();
            }
            if (this.myJdk != null) {
                VfsRootAccess.allowRootAccess((Disposable)module, (String[])new String[]{this.myJdk});
                jdk = JavaSdk.getInstance().createJdk(module.getName() + "_jdk", this.myJdk, false);
                ((ProjectJdkImpl)jdk).setVersionString(StringUtil.notNullize((String)IdeaTestUtil.getMockJdkVersion(this.myJdk), (String)"java 1.5"));
            } else {
                jdk = IdeaTestUtil.getMockJdk17();
            }
            JavaModuleFixtureBuilderImpl.registerJdk(jdk, module.getProject());
            model.setSdk(jdk);
            if (this.myLanguageLevel != null) {
                ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
            } else if (this.myMockJdkLevel == JavaModuleFixtureBuilder.MockJdkLevel.jdk15) {
                ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevel.JDK_1_5);
            }
        });
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            this.libraryCreated(library, module);
        }
    }

    private static void registerJdk(Sdk jdk, Project project2) {
        Sdk byName;
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        while ((byName = jdkTable.findJdk(jdk.getName())) != null) {
            jdkTable.removeJdk(byName);
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)project2));
    }

    protected void setupRootModel(ModifiableRootModel rootModel) {
        if (this.myOutputPath != null) {
            File pathFile = new File(this.myOutputPath);
            if (!pathFile.mkdirs()) assert (pathFile.exists()) : "unable to create: " + this.myOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myOutputPath);
            assert (virtualFile != null) : "cannot find output path: " + this.myOutputPath;
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setCompilerOutputPath(virtualFile);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(false);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
        }
        if (this.myTestOutputPath != null) {
            assert (new File(this.myTestOutputPath).mkdirs()) : this.myTestOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTestOutputPath);
            assert (virtualFile != null) : "cannot find test output path: " + this.myTestOutputPath;
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setCompilerOutputPathForTests(virtualFile);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(false);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
        }
    }

    protected void libraryCreated(Library library, Module module) {
    }

    private static class Lib {
        private final String myName;
        private final Map<OrderRootType, String[]> myRoots;

        Lib(String name, Map<OrderRootType, String[]> roots) {
            this.myName = name;
            this.myRoots = roots;
        }

        public String getName() {
            return this.myName;
        }

        public String[] getRoots(OrderRootType rootType) {
            String[] roots = this.myRoots.get(rootType);
            return roots != null ? roots : ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
    }
}

