/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerTestUtil;
import com.intellij.compiler.server.BuildManager;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.LogSetup;
import org.junit.Assert;

public class CompilerTester {
    private static final Logger LOG = Logger.getInstance(CompilerTester.class);
    private final Project myProject;
    private List<? extends Module> myModules;
    private TempDirTestFixture myMainOutput;

    public CompilerTester(@NotNull Module module) throws Exception {
        this(module.getProject(), Collections.singletonList(module), null);
    }

    public CompilerTester(@NotNull IdeaProjectTestFixture fixture, @NotNull List<? extends Module> modules) throws Exception {
        this(fixture.getProject(), modules, fixture.getTestRootDisposable());
    }

    public CompilerTester(@NotNull Project project2, @NotNull List<? extends Module> modules, @Nullable Disposable disposable) throws Exception {
        this.myProject = project2;
        this.myModules = modules;
        this.myMainOutput = new TempDirTestFixtureImpl();
        this.myMainOutput.setUp();
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    CompilerTester.this.tearDown();
                }
            });
        }
        CompilerTestUtil.enableExternalCompiler();
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            Objects.requireNonNull(CompilerProjectExtension.getInstance((Project)this.getProject())).setCompilerOutputUrl(this.myMainOutput.findOrCreateDir("out").getUrl());
            if (!this.myModules.isEmpty()) {
                JavaAwareProjectJdkTableImpl projectJdkTable = JavaAwareProjectJdkTableImpl.getInstanceEx();
                for (Module module : this.myModules) {
                    ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)projectJdkTable.getInternalJdk());
                }
            }
        });
    }

    public void tearDown() {
        try {
            new RunAll(new ThrowableRunnable[]{() -> CompilerTestUtil.disableExternalCompiler(this.getProject()), () -> this.myMainOutput.tearDown()}).run();
        }
        finally {
            this.myMainOutput = null;
            this.myModules = null;
        }
    }

    private Project getProject() {
        return this.myProject;
    }

    public void deleteClassFile(@NotNull String className) throws IOException {
        WriteAction.runAndWait(() -> this.touch(JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())).getContainingFile().getVirtualFile()));
    }

    @Nullable
    public File findClassFile(String className, Module module) {
        VirtualFile out = ((CompilerModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
        assert (out != null);
        File cls = new File(out.getPath(), className.replace('.', '/') + ".class");
        return cls.exists() ? cls : null;
    }

    public void touch(VirtualFile file2) throws IOException {
        WriteAction.runAndWait(() -> {
            file2.setBinaryContent(file2.contentsToByteArray(), -1L, file2.getTimeStamp() + 1L);
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            assert (ioFile.setLastModified(ioFile.lastModified() - 100000L));
            file2.refresh(false, false);
        });
    }

    public void setFileText(PsiFile file2, String text) throws IOException {
        WriteAction.runAndWait(() -> {
            VirtualFile virtualFile = file2.getVirtualFile();
            VfsUtil.saveText((VirtualFile)Objects.requireNonNull(virtualFile), (String)text);
        });
        this.touch(file2.getVirtualFile());
    }

    public void setFileName(PsiFile file2, String name) {
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> file2.setName(name));
    }

    public List<CompilerMessage> make() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).make(callback)));
    }

    public List<CompilerMessage> rebuild() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).rebuild(callback)));
    }

    public List<CompilerMessage> compileModule(Module module) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).compile(module, callback)));
    }

    public List<CompilerMessage> make(CompileScope scope) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).make(scope, callback)));
    }

    public List<CompilerMessage> compileFiles(VirtualFile ... files) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance((Project)this.getProject()).compile(files, callback)));
    }

    @NotNull
    public List<CompilerMessage> runCompiler(@NotNull Consumer<? super CompileStatusNotification> runnable) {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ErrorReportingCallback callback = new ErrorReportingCallback(semaphore);
        EdtTestUtil.runInEdtAndWait(() -> {
            Path configDir;
            Path macroFilePath;
            PathMacros pathMacroManager;
            Map map;
            CompilerTester.refreshVfs(this.getProject().getProjectFilePath());
            for (Module module : this.myModules) {
                CompilerTester.refreshVfs(module.getModuleFilePath());
            }
            PlatformTestUtil.saveProject((Project)this.getProject(), (boolean)false);
            CompilerTestUtil.saveApplicationSettings();
            if (!ProjectKt.isDirectoryBased((Project)this.myProject)) {
                for (Module module : this.myModules) {
                    Path ioFile = Paths.get(module.getModuleFilePath(), new String[0]);
                    if (Files.exists(ioFile, new LinkOption[0])) continue;
                    this.getProject().save();
                    assert (Files.exists(ioFile, new LinkOption[0])) : "File does not exist: " + ioFile.toString();
                }
            }
            if (!(map = (pathMacroManager = PathMacros.getInstance()).getUserMacros()).isEmpty() && !Files.exists(macroFilePath = (configDir = PathManager.getConfigDir()).resolve("options").resolve("path.macros.xml"), new LinkOption[0])) {
                String message = "File " + macroFilePath + " doesn't exist, but user macros defined: " + map;
                LOG.warn(message);
                String fakeMacroName = "__remove_me__";
                IComponentStore applicationStore = CompilerTestUtil.getApplicationStore();
                pathMacroManager.setMacro(fakeMacroName, fakeMacroName);
                applicationStore.saveComponent((PersistentStateComponent)pathMacroManager);
                pathMacroManager.setMacro(fakeMacroName, null);
                applicationStore.saveComponent((PersistentStateComponent)pathMacroManager);
                if (!Files.exists(macroFilePath, new LinkOption[0])) {
                    throw new AssertionError((Object)message);
                }
            }
            CompilerTester.enableDebugLogging();
            runnable.consume((Object)callback);
        });
        while (!semaphore.waitFor(100L)) {
            if (!SwingUtilities.isEventDispatchThread()) continue;
            UIUtil.dispatchAllInvocationEvents();
        }
        CompilerTester.printBuildLog();
        callback.throwException();
        if (!((CompilerManagerImpl)CompilerManager.getInstance((Project)this.getProject())).waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES)) {
            throw new RuntimeException("External javac thread is still running. Thread dump:" + ThreadDumper.dumpThreadsToString());
        }
        this.checkVfsNotLoadedForOutput();
        return callback.getMessages();
    }

    private void checkVfsNotLoadedForOutput() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            if (extension == null) continue;
            for (String url : extension.getOutputRootUrls(true)) {
                VirtualFile root = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
                if (root == null) continue;
                UsefulTestCase.assertEmpty((String)"VFS should not be loaded for output: that increases the number of VFS events and reindexing costs", (Collection)((NewVirtualFile)root).getCachedChildren());
            }
        }
    }

    public static void printBuildLog() {
        File logDirectory = BuildManager.getBuildLogDirectory();
        File[] files = logDirectory.listFiles(file2 -> file2.getName().endsWith(".log"));
        if (files == null || files.length == 0) {
            LOG.debug("No *.log files in " + logDirectory + " after build");
            return;
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file3 : files) {
            LOG.debug(file3.getName() + ":");
            try {
                List lines = FileUtil.loadLines((File)file3);
                for (String line : lines) {
                    LOG.debug(line);
                }
            }
            catch (IOException e) {
                LOG.debug("Failed to load contents: " + e.getMessage());
            }
        }
    }

    public static void enableDebugLogging() throws IOException {
        File logDirectory = BuildManager.getBuildLogDirectory();
        FileUtil.delete((File)logDirectory);
        FileUtil.createDirectory((File)logDirectory);
        Properties properties = new Properties();
        try (InputStream config = LogSetup.readDefaultLogConfig();){
            properties.load(config);
        }
        properties.setProperty("log4j.rootLogger", "debug, file");
        File logFile = new File(logDirectory, "build-log.properties");
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(logFile));){
            properties.store(output, null);
        }
    }

    private static void refreshVfs(String path) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    private static class ErrorReportingCallback
    implements CompileStatusNotification {
        private final Semaphore mySemaphore;
        private Throwable myError;
        private final List<CompilerMessage> myMessages = new ArrayList<CompilerMessage>();

        ErrorReportingCallback(@NotNull Semaphore semaphore) {
            this.mySemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            try {
                for (CompilerMessageCategory category : CompilerMessageCategory.values()) {
                    CompilerMessage[] messages;
                    for (CompilerMessage message : messages = compileContext.getMessages(category)) {
                        String text = message.getMessage();
                        if (category == CompilerMessageCategory.INFORMATION && ErrorReportingCallback.isSpamMessage(text)) continue;
                        this.myMessages.add(message);
                    }
                }
                Assert.assertFalse((String)"Code did not compile!", (boolean)aborted);
            }
            catch (Throwable t) {
                this.myError = t;
            }
            finally {
                this.mySemaphore.up();
            }
        }

        private static boolean isSpamMessage(String text) {
            return text.contains(JavaCompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) || text.contains("used to compile") || text.contains("illegal reflective") || text.contains("Picked up") || text.contains("consider reporting this to the maintainers") || text.startsWith("Using Groovy-Eclipse");
        }

        void throwException() {
            if (this.myError != null) {
                ExceptionUtil.rethrow((Throwable)this.myError);
            }
        }

        @NotNull
        public List<CompilerMessage> getMessages() {
            return this.myMessages;
        }
    }
}

