/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.util.GithubAuthData;

@com.intellij.openapi.components.State(name="GithubSettings", storages={@Storage(value="github.xml"), @Storage(value="github_settings.xml", deprecated=true)})
public class GithubSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        this.myState = state2;
    }

    public static GithubSettings getInstance() {
        return (GithubSettings)ServiceManager.getService(GithubSettings.class);
    }

    public int getConnectionTimeout() {
        return this.myState.CONNECTION_TIMEOUT;
    }

    public void setConnectionTimeout(int timeout) {
        this.myState.CONNECTION_TIMEOUT = timeout;
    }

    public boolean isOpenInBrowserGist() {
        return this.myState.OPEN_IN_BROWSER_GIST;
    }

    public boolean isCopyURLGist() {
        return this.myState.COPY_URL_GIST;
    }

    public void setCopyURLGist(boolean copyLink) {
        this.myState.COPY_URL_GIST = copyLink;
    }

    public boolean isPrivateGist() {
        return this.myState.PRIVATE_GIST;
    }

    public boolean isCloneGitUsingSsh() {
        return this.myState.CLONE_GIT_USING_SSH;
    }

    @NotNull
    public ThreeState getCreatePullRequestCreateRemote() {
        return this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE;
    }

    public void setCreatePullRequestCreateRemote(@NotNull ThreeState value) {
        this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE = value;
    }

    public void setPrivateGist(boolean secretGist) {
        this.myState.PRIVATE_GIST = secretGist;
    }

    public void setOpenInBrowserGist(boolean openInBrowserGist) {
        this.myState.OPEN_IN_BROWSER_GIST = openInBrowserGist;
    }

    public void setCloneGitUsingSsh(boolean value) {
        this.myState.CLONE_GIT_USING_SSH = value;
    }

    @Deprecated
    @Nullable
    public String getHost() {
        return this.myState.HOST;
    }

    @Deprecated
    @Nullable
    public String getLogin() {
        return this.myState.LOGIN;
    }

    @Deprecated
    @Nullable
    public GithubAuthData.AuthType getAuthType() {
        return this.myState.AUTH_TYPE;
    }

    @Deprecated
    public boolean isAuthConfigured() {
        return GithubAuthenticationManager.getInstance().hasAccounts();
    }

    @Deprecated
    @NotNull
    public GithubAuthData getAuthData() {
        throw new IllegalStateException("Single account auth is deprecated");
    }

    public void clearAuth() {
        this.myState.HOST = null;
        this.myState.LOGIN = null;
        this.myState.AUTH_TYPE = null;
    }

    public static class State {
        @Nullable
        public String LOGIN = null;
        @Nullable
        public String HOST = null;
        @Nullable
        public GithubAuthData.AuthType AUTH_TYPE = null;
        public boolean OPEN_IN_BROWSER_GIST = true;
        public boolean COPY_URL_GIST = false;
        public boolean PRIVATE_GIST = true;
        public int CONNECTION_TIMEOUT = 5000;
        public ThreeState CREATE_PULL_REQUEST_CREATE_REMOTE = ThreeState.UNSURE;
        public boolean CLONE_GIT_USING_SSH = false;
    }
}

