/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandlerImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "project", "Lcom/intellij/openapi/project/Project;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "resetRunnable", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lkotlin/jvm/functions/Function0;)V", "getActionForError", "Ljavax/swing/Action;", "error", "", "ReLoginAction", "RetryAction", "intellij.vcs.github"})
public final class GHLoadingErrorHandlerImpl
implements GHLoadingErrorHandler {
    private final Project project;
    private final GithubAccount account;
    private final Function0<Unit> resetRunnable;

    @Override
    @Nullable
    public Action getActionForError(@NotNull Throwable error) {
        if (error instanceof GithubAuthenticationException) {
            return new ReLoginAction();
        }
        return new RetryAction();
    }

    public GHLoadingErrorHandlerImpl(@NotNull Project project, @NotNull GithubAccount account, @NotNull Function0<Unit> resetRunnable) {
        this.project = project;
        this.account = account;
        this.resetRunnable = resetRunnable;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandlerImpl$ReLoginAction;", "Ljavax/swing/AbstractAction;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandlerImpl;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.vcs.github"})
    private final class ReLoginAction
    extends AbstractAction {
        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            if (GithubAuthenticationManager.requestReLogin$default(GithubAuthenticationManager.Companion.getInstance(), GHLoadingErrorHandlerImpl.this.account, GHLoadingErrorHandlerImpl.this.project, null, 4, null)) {
                GHLoadingErrorHandlerImpl.this.resetRunnable.invoke();
            }
        }

        public ReLoginAction() {
            super(GithubBundle.message("accounts.relogin", new Object[0]));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandlerImpl$RetryAction;", "Ljavax/swing/AbstractAction;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandlerImpl;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.vcs.github"})
    private final class RetryAction
    extends AbstractAction {
        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            GHLoadingErrorHandlerImpl.this.resetRunnable.invoke();
        }

        public RetryAction() {
            super(GithubBundle.message("retry.action", new Object[0]));
        }
    }
}

