/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubUser;

public class GithubGist {
    private String id;
    private String description;
    @JsonProperty(value="public")
    private Boolean isPublic;
    private String url;
    private String htmlUrl;
    private String gitPullUrl;
    private String gitPushUrl;
    private Map<String, GistFile> files;
    private GithubUser owner;
    private Date createdAt;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getDescription() {
        return StringUtil.notNullize((String)this.description);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @NotNull
    public List<GistFile> getFiles() {
        return new ArrayList<GistFile>(this.files.values());
    }

    @Nullable
    public GithubUser getUser() {
        return this.owner;
    }

    public static class GistFile {
        private Long size;
        private String filename;
        private String content;
        private String raw_url;
        private String type;
        private String language;

        @NotNull
        public String getFilename() {
            return this.filename;
        }

        @NotNull
        public String getContent() {
            return this.content;
        }

        @NotNull
        public String getRawUrl() {
            return this.raw_url;
        }
    }
}

