/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLFileNotFoundException;
import org.jetbrains.plugins.github.api.GHGQLQueryLoader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0007J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\"\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000e\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004 \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLQueryLoader;", "", "()V", "GQL_DIRECTORY", "", "GQL_FILE_SUFFIX", "GQL_FRAGMENTS_DIRECTORY", "GQL_QUERY_DIRECTORY", "fragmentDefinitionRegex", "Lkotlin/text/Regex;", "fragmentsCache", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/api/GHGQLQueryLoader$Fragment;", "queriesCache", "findAllQueries", "", "getFragmentsWithDependencies", "", "names", "loadQuery", "queryName", "readCollectingFragmentNames", "Lkotlin/Pair;", "filePath", "Fragment", "intellij.vcs.github"})
public final class GHGQLQueryLoader {
    private static final String GQL_DIRECTORY = "graphql";
    private static final String GQL_FRAGMENTS_DIRECTORY = "fragment";
    private static final String GQL_QUERY_DIRECTORY = "query";
    private static final String GQL_FILE_SUFFIX = "graphql";
    private static final Regex fragmentDefinitionRegex;
    private static final Cache<String, Fragment> fragmentsCache;
    private static final Cache<String, String> queriesCache;
    public static final GHGQLQueryLoader INSTANCE;

    @NotNull
    public final String loadQuery(@NotNull String queryName) throws IOException {
        return (String)queriesCache.get((Object)queryName, (Callable)new Callable<String>(queryName){
            final /* synthetic */ String $queryName;

            /*
             * WARNING - void declaration
             */
            public final String call() {
                void body2;
                Pair pair = GHGQLQueryLoader.access$readCollectingFragmentNames(GHGQLQueryLoader.INSTANCE, "graphql/query/" + this.$queryName + ".graphql");
                String string = (String)pair.component1();
                Set fragmentNames = (Set)pair.component2();
                StringBuilder builder = new StringBuilder();
                for (Fragment fragment2 : GHGQLQueryLoader.access$getFragmentsWithDependencies(GHGQLQueryLoader.INSTANCE, fragmentNames)) {
                    builder.append(fragment2.getBody()).append("\n");
                }
                builder.append((String)body2);
                return builder.toString();
            }
            {
                this.$queryName = string;
            }
        });
    }

    private final Set<Fragment> getFragmentsWithDependencies(Set<String> names) {
        boolean bl = false;
        Set set = new LinkedHashSet();
        for (String name : names) {
            Fragment fragment2 = (Fragment)fragmentsCache.get((Object)name, (Callable)new Callable<Fragment>(name){
                final /* synthetic */ String $name;

                public final Fragment call() {
                    return new Fragment(this.$name);
                }
                {
                    this.$name = string;
                }
            });
            set.add(fragment2);
            set.addAll((Collection)this.getFragmentsWithDependencies(fragment2.getDependencies()));
        }
        return set;
    }

    private final Pair<String, Set<String>> readCollectingFragmentNames(String filePath) {
        InputStream stream;
        StringBuilder bodyBuilder = new StringBuilder();
        boolean bl = false;
        Set fragments = new LinkedHashSet();
        boolean bl2 = false;
        Set innerFragments = new LinkedHashSet();
        InputStream inputStream = GHGQLQueryLoader.class.getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            throw (Throwable)new GHGQLFileNotFoundException("Couldn't find file " + filePath);
        }
        InputStream inputStream2 = stream = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl3 = false;
        TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), (Function1)((Function1)new Function1<String, Unit>(bodyBuilder, innerFragments, fragments){
            final /* synthetic */ StringBuilder $bodyBuilder;
            final /* synthetic */ Set $innerFragments;
            final /* synthetic */ Set $fragments;

            public final void invoke(@NotNull String it) {
                String fragmentName;
                int n;
                String string = it;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String line = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                this.$bodyBuilder.append(line).append("\n");
                if (StringsKt.startsWith$default((String)line, (String)"fragment", (boolean)false, (int)2, null)) {
                    String string3;
                    Object object = GHGQLQueryLoader.access$getFragmentDefinitionRegex$p(GHGQLQueryLoader.INSTANCE).matchEntire((CharSequence)line);
                    if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null) {
                        Object object2 = object;
                        n = 0;
                        Object object3 = object2;
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                    } else {
                        string3 = fragmentName = null;
                    }
                    if (fragmentName != null) {
                        this.$innerFragments.add(fragmentName);
                    }
                }
                if (StringsKt.startsWith$default((String)line, (String)"...", (boolean)false, (int)2, null) && line.length() > 3 && !CharsKt.isWhitespace((char)line.charAt(3))) {
                    String string4 = line;
                    n = 3;
                    boolean bl2 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    fragmentName = string6;
                    this.$fragments.add(fragmentName);
                }
            }
            {
                this.$bodyBuilder = stringBuilder;
                this.$innerFragments = set;
                this.$fragments = set2;
                super(1);
            }
        }));
        fragments.removeAll(innerFragments);
        return TuplesKt.to((Object)bodyBuilder.toString(), (Object)fragments);
    }

    @VisibleForTesting
    @NotNull
    public final List<String> findAllQueries() {
        URL url = GHGQLQueryLoader.class.getClassLoader().getResource("graphql/query");
        Path directory = Paths.get(url.toURI());
        return Files.walk(directory, new FileVisitOption[0]).filter(findAllQueries.1.INSTANCE).map(findAllQueries.2.INSTANCE).collect(Collectors.toList());
    }

    private GHGQLQueryLoader() {
    }

    static {
        GHGQLQueryLoader gHGQLQueryLoader;
        INSTANCE = gHGQLQueryLoader = new GHGQLQueryLoader();
        fragmentDefinitionRegex = new Regex("fragment (.*) on .*\\{");
        fragmentsCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
        queriesCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    public static final /* synthetic */ Set access$getFragmentsWithDependencies(GHGQLQueryLoader $this, Set names) {
        return $this.getFragmentsWithDependencies(names);
    }

    public static final /* synthetic */ Regex access$getFragmentDefinitionRegex$p(GHGQLQueryLoader $this) {
        GHGQLQueryLoader gHGQLQueryLoader = $this;
        return fragmentDefinitionRegex;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLQueryLoader$Fragment;", "", "name", "", "(Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "dependencies", "", "getDependencies", "()Ljava/util/Set;", "getName", "equals", "", "other", "hashCode", "", "intellij.vcs.github"})
    private static final class Fragment {
        @NotNull
        private final String body;
        @NotNull
        private final Set<String> dependencies;
        @NotNull
        private final String name;

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final Set<String> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fragment)) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.name, (Object)((Fragment)other).name) ^ true);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        public Fragment(@NotNull String name) {
            void body2;
            this.name = name;
            Pair pair = INSTANCE.readCollectingFragmentNames("graphql/fragment/" + this.name + ".graphql");
            String string = (String)pair.component1();
            Set dependencies = (Set)pair.component2();
            this.body = body2;
            this.dependencies = dependencies;
        }
    }
}

