/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeepLinks {
    private List<DeepLink> myDeepLinkList = new ArrayList<DeepLink>();

    public int addLink(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean alwaysAddToEnd) {
        DeepLink newDeepLink = new DeepLink(order, activityData, url, pathData);
        if (!alwaysAddToEnd) {
            for (int i = 0; i < this.myDeepLinkList.size(); ++i) {
                DeepLink deepLink = this.myDeepLinkList.get(i);
                if (!deepLink.getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                if (deepLink.getOrder().getIntValue() > newDeepLink.getOrder().getIntValue()) {
                    this.myDeepLinkList.add(i, newDeepLink);
                    return i;
                }
                if (i != this.myDeepLinkList.size() - 1 && this.myDeepLinkList.get(i + 1).getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                this.myDeepLinkList.add(i + 1, newDeepLink);
                return i + 1;
            }
        }
        this.myDeepLinkList.add(newDeepLink);
        return this.myDeepLinkList.size() - 1;
    }

    public void clear() {
        this.myDeepLinkList.clear();
    }

    public void removeLinkAt(int index) {
        this.myDeepLinkList.remove(index);
    }

    public int updateLink(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean supportOrder, int index) {
        if (index < 0 || index >= this.myDeepLinkList.size()) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + "is invalid.");
        }
        DeepLink deepLink = this.myDeepLinkList.get(index);
        if (!activityData.getModuleName().equals(deepLink.getActivityData().getModuleName()) || supportOrder && deepLink.getOrder().getIntValue() != order.getIntValue()) {
            this.myDeepLinkList.remove(index);
            return this.addLink(order, url, pathData, activityData, supportOrder);
        }
        deepLink.myFullUrl = url;
        deepLink.myPathData = pathData;
        deepLink.myActivityData = activityData;
        return index;
    }

    @NotNull
    public final ImmutableList<DeepLink> getDeepLinkList() {
        return ImmutableList.copyOf(this.myDeepLinkList);
    }

    public void addDeepLinks(@NotNull List<DeepLink> deepLinkList) {
        this.myDeepLinkList.addAll(deepLinkList);
    }

    public static class DeepLink {
        private FullUrl myFullUrl;
        private ActivityData myActivityData;
        private PathData myPathData;
        private Order myOrder;

        public DeepLink(@NotNull Order order, @NotNull ActivityData data, @NotNull FullUrl url, @NotNull PathData path) {
            this.myActivityData = data;
            this.myFullUrl = url;
            this.myPathData = path;
            this.myOrder = order;
        }

        @NotNull
        public FullUrl getUrl() {
            return this.myFullUrl;
        }

        @NotNull
        public PathData getPath() {
            return this.myPathData;
        }

        @NotNull
        public ActivityData getActivityData() {
            return this.myActivityData;
        }

        @NotNull
        public Order getOrder() {
            return this.myOrder;
        }
    }
}

