/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.store.LayoutFileParser;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.RelativizableFile;
import android.databinding.tool.writer.JavaFileWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class LayoutXmlProcessor {
    private static final FilenameFilter LAYOUT_FOLDER_FILTER = (dir, name) -> name.startsWith("layout");
    private static final FilenameFilter XML_FILE_FILTER = (dir, name) -> name.toLowerCase().endsWith(".xml");
    private final JavaFileWriter mFileWriter;
    private final ResourceBundle mResourceBundle;
    private boolean mProcessingComplete;
    private final OriginalFileLookup mOriginalFileLookup;

    public LayoutXmlProcessor(String applicationPackage, JavaFileWriter fileWriter, OriginalFileLookup originalFileLookup, boolean useAndroidX) {
        this.mFileWriter = fileWriter;
        this.mResourceBundle = new ResourceBundle(applicationPackage, useAndroidX);
        this.mOriginalFileLookup = originalFileLookup;
    }

    private static void processIncrementalInputFiles(ResourceInput input, ProcessFileCallback callback) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException {
        LayoutXmlProcessor.processExistingIncrementalFiles(input.getRootInputFolder(), input.getAdded(), callback);
        LayoutXmlProcessor.processExistingIncrementalFiles(input.getRootInputFolder(), input.getChanged(), callback);
        LayoutXmlProcessor.processRemovedIncrementalFiles(input.getRootInputFolder(), input.getRemoved(), callback);
    }

    public static String exportLayoutNameFromInfoFileName(String infoFileName) {
        return infoFileName.substring(0, infoFileName.indexOf(45));
    }

    private static void processExistingIncrementalFiles(File inputRoot, List<File> files, ProcessFileCallback callback) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        for (File file : files) {
            File parent = file.getParentFile();
            if (inputRoot.equals(parent)) {
                if (LAYOUT_FOLDER_FILTER.accept(file, file.getName())) continue;
                callback.processOtherRootFile(file);
                continue;
            }
            if (LAYOUT_FOLDER_FILTER.accept(parent, parent.getName())) {
                callback.processLayoutFile(file);
                continue;
            }
            callback.processOtherFile(parent, file);
        }
    }

    private static void processRemovedIncrementalFiles(File inputRoot, List<File> files, ProcessFileCallback callback) throws IOException {
        for (File file : files) {
            File parent = file.getParentFile();
            if (inputRoot.equals(parent)) {
                callback.processRemovedOtherRootFile(file);
                continue;
            }
            if (LAYOUT_FOLDER_FILTER.accept(parent, parent.getName())) {
                callback.processRemovedLayoutFile(file);
                continue;
            }
            callback.processRemovedOtherFile(parent, file);
        }
    }

    private static void processAllInputFiles(ResourceInput input, ProcessFileCallback callback) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        FileUtils.deleteDirectory((File)input.getRootOutputFolder());
        Preconditions.check(input.getRootOutputFolder().mkdirs(), "out dir should be re-created", new Object[0]);
        Preconditions.check(input.getRootInputFolder().isDirectory(), "it must be a directory", new Object[0]);
        for (File firstLevel : input.getRootInputFolder().listFiles()) {
            if (firstLevel.isDirectory()) {
                if (LAYOUT_FOLDER_FILTER.accept(firstLevel, firstLevel.getName())) {
                    callback.processLayoutFolder(firstLevel);
                    for (File xmlFile : firstLevel.listFiles(XML_FILE_FILTER)) {
                        callback.processLayoutFile(xmlFile);
                    }
                    continue;
                }
                callback.processOtherFolder(firstLevel);
                for (File file : firstLevel.listFiles()) {
                    callback.processOtherFile(firstLevel, file);
                }
                continue;
            }
            callback.processOtherRootFile(firstLevel);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void processRemovedFile(File input) {
        this.mResourceBundle.addRemovedFile(input);
    }

    public void processFileWithNoDataBinding(File file) {
        this.mResourceBundle.addFileWithNoDataBinding(file);
    }

    public boolean processSingleFile(RelativizableFile input, File output, boolean isViewBindingEnabled, boolean isDataBindingEnabled) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        ResourceBundle.LayoutFileBundle bindingLayout = LayoutFileParser.parseXml(input, output, this.mResourceBundle.getAppPackage(), this.mOriginalFileLookup, isViewBindingEnabled, isDataBindingEnabled);
        if (bindingLayout == null || bindingLayout.isBindingData() && bindingLayout.isEmpty()) {
            return false;
        }
        this.mResourceBundle.addLayoutBundle(bindingLayout, true);
        return true;
    }

    public boolean processResources(final ResourceInput input, final boolean isViewBindingEnabled, final boolean isDataBindingEnabled) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (this.mProcessingComplete) {
            return false;
        }
        final URI inputRootUri = input.getRootInputFolder().toURI();
        ProcessFileCallback callback = new ProcessFileCallback(){

            private File convertToOutFile(File file) {
                String subPath = LayoutXmlProcessor.toSystemDependentPath(inputRootUri.relativize(file.toURI()).getPath());
                return new File(input.getRootOutputFolder(), subPath);
            }

            @Override
            public void processLayoutFile(File file) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
                LayoutXmlProcessor.this.processSingleFile(RelativizableFile.fromAbsoluteFile(file, null), this.convertToOutFile(file), isViewBindingEnabled, isDataBindingEnabled);
            }

            @Override
            public void processOtherFile(File parentFolder, File file) throws IOException {
                File outParent = this.convertToOutFile(parentFolder);
                FileUtils.copyFile((File)file, (File)new File(outParent, file.getName()));
            }

            @Override
            public void processRemovedLayoutFile(File file) {
                LayoutXmlProcessor.this.mResourceBundle.addRemovedFile(file);
                File out = this.convertToOutFile(file);
                FileUtils.deleteQuietly((File)out);
            }

            @Override
            public void processRemovedOtherFile(File parentFolder, File file) throws IOException {
                File outParent = this.convertToOutFile(parentFolder);
                FileUtils.deleteQuietly((File)new File(outParent, file.getName()));
            }

            @Override
            public void processOtherFolder(File folder) {
                this.convertToOutFile(folder).mkdirs();
            }

            @Override
            public void processLayoutFolder(File folder) {
                this.convertToOutFile(folder).mkdirs();
            }

            @Override
            public void processOtherRootFile(File file) throws IOException {
                File outFile = this.convertToOutFile(file);
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((File)file, (File)outFile);
                } else {
                    FileUtils.copyFile((File)file, (File)outFile);
                }
            }

            @Override
            public void processRemovedOtherRootFile(File file) throws IOException {
                File outFile = this.convertToOutFile(file);
                FileUtils.deleteQuietly((File)outFile);
            }
        };
        if (input.isIncremental()) {
            LayoutXmlProcessor.processIncrementalInputFiles(input, callback);
        } else {
            LayoutXmlProcessor.processAllInputFiles(input, callback);
        }
        this.mProcessingComplete = true;
        return true;
    }

    public static String toSystemDependentPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public void writeLayoutInfoFiles(File xmlOutDir) throws JAXBException {
        this.writeLayoutInfoFiles(xmlOutDir, this.mFileWriter);
    }

    public JavaFileWriter getFileWriter() {
        return this.mFileWriter;
    }

    public void writeLayoutInfoFiles(File xmlOutDir, JavaFileWriter writer) throws JAXBException {
        for (ResourceBundle.LayoutFileBundle layout : this.mResourceBundle.getAllLayoutFileBundlesInSource()) {
            this.writeXmlFile(writer, xmlOutDir, layout);
        }
        ArrayList<File> staleLayoutFiles = new ArrayList<File>(this.mResourceBundle.getRemovedFiles());
        staleLayoutFiles.addAll(this.mResourceBundle.getFilesWithNoDataBinding());
        for (File staleLayoutFile : staleLayoutFiles) {
            File staleLayoutInfoFile = new File(xmlOutDir, LayoutXmlProcessor.generateExportFileName(staleLayoutFile));
            FileUtils.deleteQuietly((File)staleLayoutInfoFile);
        }
    }

    private void writeXmlFile(JavaFileWriter writer, File xmlOutDir, ResourceBundle.LayoutFileBundle layout) throws JAXBException {
        String filename = LayoutXmlProcessor.generateExportFileName(layout);
        writer.writeToFile(new File(xmlOutDir, filename), layout.toXML());
    }

    private static String generateExportFileName(ResourceBundle.LayoutFileBundle layout) {
        return LayoutXmlProcessor.generateExportFileName(layout.getFileName(), layout.getDirectory());
    }

    private static String generateExportFileName(File file) {
        String fileName = file.getName();
        return LayoutXmlProcessor.generateExportFileName(fileName.substring(0, fileName.lastIndexOf(46)), file.getParentFile().getName());
    }

    public static String generateExportFileName(String fileName, String dirName) {
        return fileName + '-' + dirName + ".xml";
    }

    public String getPackage() {
        return this.mResourceBundle.getAppPackage();
    }

    private static interface ProcessFileCallback {
        public void processLayoutFile(File var1) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException;

        public void processOtherFile(File var1, File var2) throws IOException;

        public void processRemovedLayoutFile(File var1);

        public void processRemovedOtherFile(File var1, File var2) throws IOException;

        public void processOtherFolder(File var1);

        public void processLayoutFolder(File var1);

        public void processOtherRootFile(File var1) throws IOException;

        public void processRemovedOtherRootFile(File var1) throws IOException;
    }

    public static class ResourceInput {
        private final boolean mIncremental;
        private final File mRootInputFolder;
        private final File mRootOutputFolder;
        private List<File> mAdded = new ArrayList<File>();
        private List<File> mRemoved = new ArrayList<File>();
        private List<File> mChanged = new ArrayList<File>();

        public ResourceInput(boolean incremental, File rootInputFolder, File rootOutputFolder) {
            this.mIncremental = incremental;
            this.mRootInputFolder = rootInputFolder;
            this.mRootOutputFolder = rootOutputFolder;
        }

        public void added(File file) {
            this.mAdded.add(file);
        }

        public void removed(File file) {
            this.mRemoved.add(file);
        }

        public void changed(File file) {
            this.mChanged.add(file);
        }

        public boolean shouldCopy() {
            return !this.mRootInputFolder.equals(this.mRootOutputFolder);
        }

        List<File> getAdded() {
            return this.mAdded;
        }

        List<File> getRemoved() {
            return this.mRemoved;
        }

        List<File> getChanged() {
            return this.mChanged;
        }

        File getRootInputFolder() {
            return this.mRootInputFolder;
        }

        File getRootOutputFolder() {
            return this.mRootOutputFolder;
        }

        public boolean isIncremental() {
            return this.mIncremental;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("ResourceInput{").append("mIncremental=").append(this.mIncremental).append(", mRootInputFolder=").append(this.mRootInputFolder).append(", mRootOutputFolder=").append(this.mRootOutputFolder);
            ResourceInput.logFiles(out, "added", this.mAdded);
            ResourceInput.logFiles(out, "removed", this.mRemoved);
            ResourceInput.logFiles(out, "changed", this.mChanged);
            return out.toString();
        }

        private static void logFiles(StringBuilder out, String name, List<File> files) {
            out.append("\n  ").append(name);
            for (File file : files) {
                out.append("\n   - ").append(file.getAbsolutePath());
            }
        }
    }

    public static interface OriginalFileLookup {
        public File getOriginalFileFor(File var1);
    }
}

