/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.fir.FirModuleVisibilityChecker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.session.FirJvmModuleInfo;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/session/FirJvmModuleVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirModuleVisibilityChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "isInFriendModule", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isIn", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "jarOrDirectory", "", "entrypoint"})
public final class FirJvmModuleVisibilityChecker
implements FirModuleVisibilityChecker {
    @NotNull
    private final FirSession session;

    public FirJvmModuleVisibilityChecker(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInFriendModule(@NotNull FirMemberDeclaration declaration) {
        Boolean bl;
        Object it;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Object object = this.session.getModuleInfo();
        if (!(object instanceof FirJvmModuleInfo)) return false;
        FirJvmModuleInfo firJvmModuleInfo = (FirJvmModuleInfo)object;
        FirJvmModuleInfo firJvmModuleInfo2 = firJvmModuleInfo;
        if (firJvmModuleInfo2 == null) {
            return false;
        }
        FirJvmModuleInfo moduleInfo2 = firJvmModuleInfo2;
        SourceElement source = FirDeclarationUtilKt.getContainerSource(declaration);
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = source instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass() : (source instanceof JvmPackagePartSource ? ((JvmPackagePartSource)source).getKnownJvmBinaryClass() : null);
        if (!(kotlinJvmBinaryClass2 instanceof VirtualFileKotlinClass)) return false;
        VirtualFileKotlinClass virtualFileKotlinClass = (VirtualFileKotlinClass)kotlinJvmBinaryClass2;
        object = virtualFileKotlinClass;
        if (object == null) {
            return false;
        }
        Object binaryClass = object;
        Iterable $this$any$iv = moduleInfo2.getFriendPaths();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (String)element$iv;
                boolean bl3 = false;
                if (!this.isIn((VirtualFileKotlinClass)binaryClass, (String)it)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        object = moduleInfo2.getOutputDirectory();
        if (object == null) {
            bl = null;
        } else {
            Object object2 = object;
            boolean bl4 = false;
            boolean bl5 = false;
            it = object2;
            boolean bl6 = false;
            bl = this.isIn((VirtualFileKotlinClass)binaryClass, (String)it);
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        return true;
    }

    private final boolean isIn(VirtualFileKotlinClass $this$isIn, String jarOrDirectory) {
        boolean bl;
        String string2 = $this$isIn.getFile().getFileSystem().getProtocol();
        if (Intrinsics.areEqual((Object)string2, (Object)"file")) {
            bl = VfsUtilCore.virtualToIoFile((VirtualFile)$this$isIn.getFile()).toPath().startsWith(jarOrDirectory);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"jar")) {
            Path path2;
            VirtualFile virtualFile = VfsUtilCore.getVirtualFileForJar((VirtualFile)$this$isIn.getFile());
            if (virtualFile == null) {
                path2 = null;
            } else {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl2 = false;
                boolean bl3 = false;
                VirtualFile p0 = virtualFile2;
                boolean bl4 = false;
                File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)p0);
                path2 = file2 == null ? null : file2.toPath();
            }
            bl = Intrinsics.areEqual(path2, (Object)Paths.get(jarOrDirectory, new String[0]));
        } else {
            bl = false;
        }
        return bl;
    }
}

