/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.PersistentCheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.DiagnosticCollectorDeclarationAction;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirBreakExpression;
import org.jetbrains.kotlin.fir.expressions.FirContinueExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceivers;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculatorForFullBodyResolve;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001=B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!2\u0006\u0010#\u001a\u00020$J\u0012\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!H$J\b\u0010&\u001a\u00020\u001fH$J\u001f\u0010'\u001a\u00020\u001f2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0(\"\u00020\u000b\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0014J*\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u0010+\u001a\u00020,2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0082\b\u00a2\u0006\u0002\u00102J*\u00103\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u00104\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0082\b\u00a2\u0006\u0002\u00105J>\u00106\u001a\u0002H/\"\u0004\b\u0000\u0010/2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020,2\b\u0010:\u001a\u0004\u0018\u00010;2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0082\b\u00a2\u0006\u0002\u0010<R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "components", "", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "componentsInitialized", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/PersistentCheckerContext;", "getContext$annotations", "()V", "currentAction", "Lorg/jetbrains/kotlin/fir/analysis/collectors/DiagnosticCollectorDeclarationAction;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitor", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector$Visitor;", "beforeCollecting", "", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCollectedDiagnostics", "initializeCollector", "initializeComponents", "", "([Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;)V", "onDeclarationEnter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "onDeclarationExit", "withDeclaration", "R", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withDiagnosticsAction", "action", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/DiagnosticCollectorDeclarationAction;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withLabelAndReceiverType", "labelName", "Lorg/jetbrains/kotlin/name/Name;", "owner", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Visitor", "checkers"})
public abstract class AbstractDiagnosticCollector
implements SessionHolder {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<AbstractDiagnosticCollectorComponent> components;
    private boolean componentsInitialized;
    @NotNull
    private final Visitor visitor;
    @NotNull
    private PersistentCheckerContext context;
    @NotNull
    private DiagnosticCollectorDeclarationAction currentAction;

    public AbstractDiagnosticCollector(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
        this.session = session2;
        this.scopeSession = scopeSession;
        boolean bl = false;
        this.components = new ArrayList();
        this.visitor = new Visitor();
        this.context = new PersistentCheckerContext(this, returnTypeCalculator);
        this.currentAction = DiagnosticCollectorDeclarationAction.CHECK_CURRENT_DECLARATION_AND_CHECK_NESTED;
    }

    public /* synthetic */ AbstractDiagnosticCollector(FirSession firSession, ScopeSession scopeSession, ReturnTypeCalculator returnTypeCalculator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scopeSession = new ScopeSession();
        }
        if ((n & 4) != 0) {
            returnTypeCalculator = new ReturnTypeCalculatorForFullBodyResolve();
        }
        this(firSession, scopeSession, returnTypeCalculator);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    public final List<FirDiagnostic<?>> collectDiagnostics(@NotNull FirFile firFile) {
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        if (!this.componentsInitialized) {
            throw new IllegalStateException("Components are not initialized");
        }
        this.initializeCollector();
        firFile.accept(this.visitor, null);
        return this.getCollectedDiagnostics();
    }

    protected abstract void initializeCollector();

    @NotNull
    protected abstract List<FirDiagnostic<?>> getCollectedDiagnostics();

    @NotNull
    public abstract DiagnosticReporter getReporter();

    private static /* synthetic */ void getContext$annotations() {
    }

    public final void initializeComponents(AbstractDiagnosticCollectorComponent ... components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        if (this.componentsInitialized) {
            throw new IllegalStateException();
        }
        AbstractDiagnosticCollector abstractDiagnosticCollector = this;
        Collection collection = abstractDiagnosticCollector.components;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])components2);
        this.componentsInitialized = true;
    }

    protected void beforeCollecting() {
    }

    @NotNull
    protected DiagnosticCollectorDeclarationAction onDeclarationEnter(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return DiagnosticCollectorDeclarationAction.CHECK_CURRENT_DECLARATION_AND_CHECK_NESTED;
    }

    protected void onDeclarationExit(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withDeclaration(FirDeclaration declaration, Function0<? extends R> block) {
        boolean $i$f$withDeclaration = false;
        PersistentCheckerContext existingContext = this.context;
        this.context = this.context.addDeclaration(declaration);
        try {
            Object object = block.invoke();
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.context = existingContext;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withLabelAndReceiverType(Name labelName, FirDeclaration owner, ConeKotlinType type2, Function0<? extends R> block) {
        boolean $i$f$withLabelAndReceiverType = false;
        ImplicitReceivers implicitReceivers2 = BodyResolveComponentsKt.collectImplicitReceivers(this, type2, owner);
        ImplicitReceiverValue<?> implicitReceiverValue = implicitReceivers2.component1();
        List<ImplicitReceiverValue<?>> implicitCompanionValues = implicitReceivers2.component2();
        PersistentCheckerContext existingContext = this.context;
        Iterable $this$forEach$iv = implicitCompanionValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImplicitReceiverValue value2 = (ImplicitReceiverValue)element$iv;
            boolean bl = false;
            this.context = this.context.addImplicitReceiver(null, value2);
        }
        ImplicitReceiverValue<?> implicitReceiverValue2 = implicitReceiverValue;
        if (implicitReceiverValue2 != null) {
            ImplicitReceiverValue<?> implicitReceiverValue3 = implicitReceiverValue2;
            boolean bl = false;
            boolean bl2 = false;
            ImplicitReceiverValue<?> it = implicitReceiverValue3;
            boolean bl3 = false;
            this.context = this.context.addImplicitReceiver(labelName, it);
        }
        try {
            implicitReceiverValue2 = block.invoke();
            return (R)implicitReceiverValue2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.context = existingContext;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withDiagnosticsAction(DiagnosticCollectorDeclarationAction action, Function0<? extends R> block) {
        Object object;
        boolean $i$f$withDiagnosticsAction = false;
        DiagnosticCollectorDeclarationAction oldAction = this.currentAction;
        this.currentAction = action;
        try {
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentAction = oldAction;
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0015\u001a\u00020\u00022\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J!\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020C2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020DH\u0082\bJ$\u0010E\u001a\u00020\u00022\u0006\u0010B\u001a\u00020C2\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010H\u001a\u0004\u0018\u00010=H\u0002J\u001b\u0010I\u001a\u00020\u0002\"\b\b\u0000\u0010J*\u00020\"*\u0002HJH\u0002\u00a2\u0006\u0002\u0010K\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;)V", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "data", "visitAnonymousInitializer", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitBreakExpression", "breakExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBreakExpression;", "visitClassAndChildren", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitContinueExpression", "continueExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirContinueExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitJump", "loopJump", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visitValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitWithDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lkotlin/Function0;", "visitWithDeclarationAndReceiver", "labelName", "Lorg/jetbrains/kotlin/name/Name;", "receiverTypeRef", "runComponents", "T", "(Lorg/jetbrains/kotlin/fir/FirElement;)V", "checkers"})
    private final class Visitor
    extends FirDefaultVisitor {
        public Visitor() {
            Intrinsics.checkNotNullParameter((Object)AbstractDiagnosticCollector.this, (String)"this$0");
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends FirElement> void runComponents(T $this$runComponents) {
            void $this$forEach$iv;
            Iterable iterable = AbstractDiagnosticCollector.this.components;
            AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractDiagnosticCollectorComponent it = (AbstractDiagnosticCollectorComponent)element$iv;
                boolean bl = false;
                abstractDiagnosticCollector.beforeCollecting();
                $this$runComponents.accept(it, (PersistentCheckerContext)abstractDiagnosticCollector.context);
            }
        }

        @Override
        public void visitElement(@NotNull FirElement element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.runComponents(element);
            element.acceptChildren(this, null);
        }

        private final void visitJump(FirLoopJump loopJump) {
            FirLoop firLoop;
            this.runComponents((FirElement)loopJump);
            FirLoop firLoop2 = loopJump.getTarget().getLabeledElement();
            boolean bl = false;
            boolean bl2 = false;
            FirLoop it = firLoop2;
            boolean bl3 = false;
            FirLoop firLoop3 = firLoop = it instanceof FirErrorLoop ? firLoop2 : null;
            if (firLoop != null) {
                firLoop.accept(this, null);
            }
        }

        @Override
        public void visitBreakExpression(@NotNull FirBreakExpression breakExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)breakExpression, (String)"breakExpression");
            this.visitJump(breakExpression);
        }

        @Override
        public void visitContinueExpression(@NotNull FirContinueExpression continueExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)continueExpression, (String)"continueExpression");
            this.visitJump(continueExpression);
        }

        private final void visitClassAndChildren(FirClass<?> klass, ConeKotlinType type2) {
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirResolvedTypeRefBuilder $this$visitClassAndChildren_u24lambda_u2d2 = firResolvedTypeRefBuilder;
            boolean bl4 = false;
            $this$visitClassAndChildren_u24lambda_u2d2.setType(type2);
            FirResolvedTypeRef typeRef = firResolvedTypeRefBuilder.build();
            FirRegularClass firRegularClass = klass instanceof FirRegularClass ? (FirRegularClass)klass : null;
            this.visitWithDeclarationAndReceiver(klass, firRegularClass == null ? null : firRegularClass.getName(), typeRef);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            this.visitClassAndChildren(regularClass, ScopeUtilsKt.defaultType(regularClass));
        }

        @Override
        public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
            this.visitClassAndChildren(anonymousObject, ScopeUtilsKt.defaultType(anonymousObject));
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            this.visitWithDeclarationAndReceiver(simpleFunction, simpleFunction.getName(), simpleFunction.getReceiverTypeRef());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = constructor2;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(constructor2);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(constructor2);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(constructor2);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(constructor2);
            }
        }

        @Override
        public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @Nullable Void data) {
            Name name;
            Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            FirLabel firLabel = anonymousFunction.getLabel();
            if (firLabel == null) {
                name = null;
            } else {
                String string2 = firLabel.getName();
                if (string2 == null) {
                    name = null;
                } else {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    name = Name.identifier(it);
                }
            }
            Name labelName = name;
            this.visitWithDeclarationAndReceiver(anonymousFunction, labelName, anonymousFunction.getReceiverTypeRef());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = property2;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(property2);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(property2);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(property2);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(property2);
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            if (!(propertyAccessor instanceof FirDefaultPropertyAccessor)) {
                FirProperty property2 = (FirProperty)CollectionsKt.last((List)((List)AbstractDiagnosticCollector.this.context.getContainingDeclarations()));
                this.visitWithDeclarationAndReceiver(propertyAccessor, property2.getName(), property2.getReceiverTypeRef());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = valueParameter2;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(valueParameter2);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(valueParameter2);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(valueParameter2);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(valueParameter2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = enumEntry;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(enumEntry);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(enumEntry);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(enumEntry);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(enumEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitFile(@NotNull FirFile file2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = file2;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(file2);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(file2);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(file2);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(file2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)anonymousInitializer, (String)"anonymousInitializer");
            Visitor visitor2 = this;
            FirDeclaration firDeclaration = anonymousInitializer;
            boolean $i$f$visitWithDeclaration = false;
            if (AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = AbstractDiagnosticCollector.this.onDeclarationEnter(anonymousInitializer);
                if (action$iv.getCheckCurrentDeclaration()) {
                    this.runComponents(anonymousInitializer);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector2;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(anonymousInitializer);
                    try {
                        boolean bl2 = false;
                        firDeclaration.acceptChildren(visitor2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                AbstractDiagnosticCollector.this.onDeclarationExit(anonymousInitializer);
            }
        }

        @Override
        public void visitBlock(@NotNull FirBlock block, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.visitExpression(block, data);
        }

        @Override
        public void visitTypeRef(@NotNull FirTypeRef typeRef, @Nullable Void data) {
            FirSourceElement firSourceElement;
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            if (typeRef.getSource() != null && !(((firSourceElement = typeRef.getSource()) == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind)) {
                super.visitTypeRef(typeRef, null);
            }
        }

        @Override
        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @Nullable Void data) {
            Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
            super.visitResolvedTypeRef(resolvedTypeRef, data);
            FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
            if (firTypeRef != null) {
                firTypeRef.accept(this, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void visitWithDeclaration(FirDeclaration declaration, Function0<Unit> block) {
            void this_$iv;
            boolean $i$f$visitWithDeclaration = false;
            if (!AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                return;
            }
            DiagnosticCollectorDeclarationAction action = AbstractDiagnosticCollector.this.onDeclarationEnter(declaration);
            if (action.getCheckCurrentDeclaration()) {
                this.runComponents(declaration);
            }
            AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
            AbstractDiagnosticCollector abstractDiagnosticCollector2 = AbstractDiagnosticCollector.this;
            boolean $i$f$withDiagnosticsAction = false;
            DiagnosticCollectorDeclarationAction oldAction$iv = ((AbstractDiagnosticCollector)this_$iv).currentAction;
            ((AbstractDiagnosticCollector)this_$iv).currentAction = action;
            try {
                boolean bl = false;
                AbstractDiagnosticCollector this_$iv2 = abstractDiagnosticCollector2;
                boolean $i$f$withDeclaration = false;
                PersistentCheckerContext existingContext$iv = this_$iv2.context;
                this_$iv2.context = this_$iv2.context.addDeclaration(declaration);
                try {
                    boolean bl2 = false;
                    block.invoke();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    this_$iv2.context = existingContext$iv;
                    InlineMarker.finallyEnd((int)1);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                ((AbstractDiagnosticCollector)this_$iv).currentAction = oldAction$iv;
                InlineMarker.finallyEnd((int)1);
            }
            AbstractDiagnosticCollector.this.onDeclarationExit(declaration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        static /* synthetic */ void visitWithDeclaration$default(Visitor this_, FirDeclaration declaration, Function0 block, int n, Object object) {
            void this_$iv;
            if ((n & 2) != 0) {
                block = (Function0)new Function0<Unit>(declaration, this_){
                    final /* synthetic */ FirDeclaration $declaration;
                    final /* synthetic */ Visitor this$0;
                    {
                        this.$declaration = $declaration;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$declaration.acceptChildren(this.this$0, null);
                    }
                };
            }
            boolean $i$f$visitWithDeclaration = false;
            if (!this_.AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                return;
            }
            DiagnosticCollectorDeclarationAction action = this_.AbstractDiagnosticCollector.this.onDeclarationEnter(declaration);
            if (action.getCheckCurrentDeclaration()) {
                this_.runComponents(declaration);
            }
            AbstractDiagnosticCollector abstractDiagnosticCollector = this_.AbstractDiagnosticCollector.this;
            AbstractDiagnosticCollector abstractDiagnosticCollector2 = this_.AbstractDiagnosticCollector.this;
            boolean $i$f$withDiagnosticsAction = false;
            DiagnosticCollectorDeclarationAction oldAction$iv = ((AbstractDiagnosticCollector)this_$iv).currentAction;
            ((AbstractDiagnosticCollector)this_$iv).currentAction = action;
            try {
                boolean bl = false;
                AbstractDiagnosticCollector this_$iv2 = abstractDiagnosticCollector2;
                boolean $i$f$withDeclaration = false;
                PersistentCheckerContext existingContext$iv = this_$iv2.context;
                this_$iv2.context = this_$iv2.context.addDeclaration(declaration);
                try {
                    boolean bl2 = false;
                    block.invoke();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    this_$iv2.context = existingContext$iv;
                    InlineMarker.finallyEnd((int)1);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                ((AbstractDiagnosticCollector)this_$iv).currentAction = oldAction$iv;
                InlineMarker.finallyEnd((int)1);
            }
            this_.AbstractDiagnosticCollector.this.onDeclarationExit(declaration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void visitWithDeclarationAndReceiver(FirDeclaration declaration, Name labelName, FirTypeRef receiverTypeRef) {
            void this_$iv;
            Visitor visitor2 = this;
            AbstractDiagnosticCollector abstractDiagnosticCollector = AbstractDiagnosticCollector.this;
            boolean $i$f$visitWithDeclaration = false;
            if (this_$iv.AbstractDiagnosticCollector.this.currentAction.getCheckNested()) {
                void this_$iv$iv;
                DiagnosticCollectorDeclarationAction action$iv = this_$iv.AbstractDiagnosticCollector.this.onDeclarationEnter(declaration);
                if (action$iv.getCheckCurrentDeclaration()) {
                    ((Visitor)this_$iv).runComponents(declaration);
                }
                AbstractDiagnosticCollector abstractDiagnosticCollector2 = this_$iv.AbstractDiagnosticCollector.this;
                AbstractDiagnosticCollector abstractDiagnosticCollector3 = this_$iv.AbstractDiagnosticCollector.this;
                boolean $i$f$withDiagnosticsAction = false;
                DiagnosticCollectorDeclarationAction oldAction$iv$iv = ((AbstractDiagnosticCollector)this_$iv$iv).currentAction;
                ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = action$iv;
                try {
                    boolean bl = false;
                    AbstractDiagnosticCollector this_$iv$iv2 = abstractDiagnosticCollector3;
                    boolean $i$f$withDeclaration = false;
                    PersistentCheckerContext existingContext$iv$iv = this_$iv$iv2.context;
                    this_$iv$iv2.context = this_$iv$iv2.context.addDeclaration(declaration);
                    try {
                        void type$iv;
                        void this_$iv2;
                        ConeKotlinType coneKotlinType;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        AbstractDiagnosticCollector abstractDiagnosticCollector4 = abstractDiagnosticCollector;
                        FirTypeRef firTypeRef = receiverTypeRef;
                        if (firTypeRef == null) {
                            coneKotlinType = null;
                        } else {
                            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
                            boolean $i$f$coneTypeSafe = false;
                            boolean bl4 = false;
                            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                            coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                            if (!(coneKotlinType instanceof ConeKotlinType)) {
                                coneKotlinType = null;
                            }
                        }
                        firTypeRef = coneKotlinType;
                        boolean $i$f$withLabelAndReceiverType = false;
                        ImplicitReceivers implicitReceivers2 = BodyResolveComponentsKt.collectImplicitReceivers((SessionHolder)this_$iv2, (ConeKotlinType)type$iv, declaration);
                        Unit implicitReceiverValue$iv = implicitReceivers2.component1();
                        List<ImplicitReceiverValue<?>> implicitCompanionValues$iv = implicitReceivers2.component2();
                        PersistentCheckerContext existingContext$iv = ((AbstractDiagnosticCollector)this_$iv2).context;
                        Iterable $this$forEach$iv$iv = implicitCompanionValues$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv$iv : $this$forEach$iv$iv) {
                            ImplicitReceiverValue value$iv = (ImplicitReceiverValue)element$iv$iv;
                            boolean bl5 = false;
                            ((AbstractDiagnosticCollector)this_$iv2).context = ((AbstractDiagnosticCollector)this_$iv2).context.addImplicitReceiver(null, value$iv);
                        }
                        Unit unit = implicitReceiverValue$iv;
                        if (unit != null) {
                            Unit unit2 = unit;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Unit it$iv = unit2;
                            boolean bl8 = false;
                            ((AbstractDiagnosticCollector)this_$iv2).context = ((AbstractDiagnosticCollector)this_$iv2).context.addImplicitReceiver(labelName, (ImplicitReceiverValue<?>)it$iv);
                        }
                        try {
                            boolean bl9 = false;
                            declaration.acceptChildren(this, null);
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            ((AbstractDiagnosticCollector)this_$iv2).context = existingContext$iv;
                        }
                        Unit unit3 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv2.context = existingContext$iv$iv;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((AbstractDiagnosticCollector)this_$iv$iv).currentAction = oldAction$iv$iv;
                }
                this_$iv.AbstractDiagnosticCollector.this.onDeclarationExit(declaration);
            }
        }
    }
}

