/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnmarshalException;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClientKt;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RmiFriendlyCompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteCompilationCanceledStatusClient;", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "lastChecked", "", "getLastChecked", "()J", "setLastChecked", "(J)V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "checkCanceled", "", "kotlin-daemon"})
public final class RemoteCompilationCanceledStatusClient
implements CompilationCanceledStatus {
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final Profiler profiler;
    @NotNull
    private final Lazy log$delegate;
    private volatile long lastChecked;

    public RemoteCompilationCanceledStatusClient(@NotNull CompilerCallbackServicesFacade facade, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        this.facade = facade;
        this.profiler = profiler;
        this.log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
        this.lastChecked = System.nanoTime();
    }

    public /* synthetic */ RemoteCompilationCanceledStatusClient(CompilerCallbackServicesFacade compilerCallbackServicesFacade, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profiler = new DummyProfiler();
        }
        this(compilerCallbackServicesFacade, profiler);
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public final long getLastChecked() {
        return this.lastChecked;
    }

    public final void setLastChecked(long l) {
        this.lastChecked = l;
    }

    @Override
    public void checkCanceled() {
        long curNanos = System.nanoTime();
        if (curNanos - this.lastChecked > RemoteCompilationCanceledStatusClientKt.getCANCELED_STATUS_CHECK_THRESHOLD_NS()) {
            Void void_;
            Profiler $this$withMeasure$iv = this.profiler;
            boolean $i$f$withMeasure = false;
            List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
            boolean bl = false;
            try {
                void_ = this.getFacade().compilationCanceledStatus_checkCanceled();
            }
            catch (RmiFriendlyCompilationCanceledException e) {
                throw new CompilationCanceledException();
            }
            catch (ConnectIOException e) {
                RemoteCompilationCanceledStatusClient.checkCanceled$cancelOnError(this, e);
                void_ = Unit.INSTANCE;
            }
            catch (ConnectException e) {
                RemoteCompilationCanceledStatusClient.checkCanceled$cancelOnError(this, e);
                void_ = Unit.INSTANCE;
            }
            catch (NoSuchObjectException e) {
                RemoteCompilationCanceledStatusClient.checkCanceled$cancelOnError(this, e);
                void_ = Unit.INSTANCE;
            }
            catch (UnmarshalException e) {
                RemoteCompilationCanceledStatusClient.checkCanceled$cancelOnError(this, e);
                void_ = Unit.INSTANCE;
            }
            Void res$iv = void_;
            $this$withMeasure$iv.endMeasure(this, startState$iv);
            this.lastChecked = curNanos;
        }
    }

    private static final void checkCanceled$cancelOnError(RemoteCompilationCanceledStatusClient this$0, Exception e) {
        this$0.getLog().warning("error communicating with host, assuming compilation canceled (" + e.getMessage() + ')');
        throw new CompilationCanceledException();
    }
}

