/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import com.android.tools.layoutlib.java.System_Delegate;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import libcore.timezone.CountryTimeZones;
import libcore.timezone.CountryZonesFinder;
import libcore.timezone.TimeZoneDataFiles;
import libcore.timezone.XmlUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class TimeZoneFinder {
    public static final String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    private static final String TIMEZONES_ELEMENT = "timezones";
    private static final String IANA_VERSION_ATTRIBUTE = "ianaversion";
    private static final String COUNTRY_ZONES_ELEMENT = "countryzones";
    private static final String COUNTRY_ELEMENT = "country";
    private static final String COUNTRY_CODE_ATTRIBUTE = "code";
    private static final String DEFAULT_TIME_ZONE_ID_ATTRIBUTE = "default";
    private static final String DEFAULT_TIME_ZONE_BOOST_ATTRIBUTE = "defaultBoost";
    private static final String EVER_USES_UTC_ATTRIBUTE = "everutc";
    private static final String ZONE_ID_ELEMENT = "id";
    private static final String ZONE_SHOW_IN_PICKER_ATTRIBUTE = "picker";
    private static final String ZONE_NOT_USED_AFTER_ATTRIBUTE = "notafter";
    private static TimeZoneFinder instance;
    private final XmlUtils.ReaderSupplier xmlSource;
    private CountryTimeZones lastCountryTimeZones;

    private TimeZoneFinder(XmlUtils.ReaderSupplier xmlSource) {
        this.xmlSource = xmlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZoneFinder getInstance() {
        Class<TimeZoneFinder> clazz = TimeZoneFinder.class;
        synchronized (TimeZoneFinder.class) {
            if (instance == null) {
                String[] tzLookupFilePaths = TimeZoneDataFiles.getTimeZoneFilePaths(TZLOOKUP_FILE_NAME);
                instance = TimeZoneFinder.createInstanceWithFallback(tzLookupFilePaths);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static TimeZoneFinder createInstanceWithFallback(String ... tzLookupFilePaths) {
        IOException lastException = null;
        for (String tzLookupFilePath : tzLookupFilePaths) {
            try {
                return TimeZoneFinder.createInstance(tzLookupFilePath);
            }
            catch (IOException e) {
                if (lastException != null) {
                    e.addSuppressed(lastException);
                }
                lastException = e;
            }
        }
        System_Delegate.log("No valid file found in set: " + Arrays.toString(tzLookupFilePaths) + " Printing exceptions and falling back to empty map.", lastException);
        return TimeZoneFinder.createInstanceForTests("<timezones><countryzones /></timezones>");
    }

    public static TimeZoneFinder createInstance(String path) throws IOException {
        XmlUtils.ReaderSupplier xmlSupplier = XmlUtils.ReaderSupplier.forFile(path, StandardCharsets.UTF_8);
        return new TimeZoneFinder(xmlSupplier);
    }

    public static TimeZoneFinder createInstanceForTests(String xml2) {
        return new TimeZoneFinder(XmlUtils.ReaderSupplier.forString(xml2));
    }

    public void validate() throws IOException {
        try {
            this.processXml(new TimeZonesValidator());
        }
        catch (XmlPullParserException e) {
            throw new IOException("Parsing error", e);
        }
    }

    public String getIanaVersion() {
        IanaVersionExtractor ianaVersionExtractor = new IanaVersionExtractor();
        try {
            this.processXml(ianaVersionExtractor);
            return ianaVersionExtractor.getIanaVersion();
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    public CountryZonesFinder getCountryZonesFinder() {
        CountryZonesLookupExtractor extractor = new CountryZonesLookupExtractor();
        try {
            this.processXml(extractor);
            return extractor.getCountryZonesLookup();
        }
        catch (IOException | XmlPullParserException e) {
            System_Delegate.log("Error reading country zones ", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountryTimeZones lookupCountryTimeZones(String countryIso) {
        TimeZoneFinder timeZoneFinder = this;
        synchronized (timeZoneFinder) {
            if (this.lastCountryTimeZones != null && this.lastCountryTimeZones.isForCountryCode(countryIso)) {
                return this.lastCountryTimeZones;
            }
        }
        SelectiveCountryTimeZonesExtractor extractor = new SelectiveCountryTimeZonesExtractor(countryIso);
        try {
            this.processXml(extractor);
            CountryTimeZones countryTimeZones = extractor.getValidatedCountryTimeZones();
            if (countryTimeZones == null) {
                return null;
            }
            TimeZoneFinder timeZoneFinder2 = this;
            synchronized (timeZoneFinder2) {
                this.lastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
        catch (IOException | XmlPullParserException e) {
            System_Delegate.log("Error reading country zones ", e);
            return null;
        }
    }

    private void processXml(TimeZonesProcessor processor) throws XmlPullParserException, IOException {
        try (Reader reader = this.xmlSource.get();){
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput(reader);
            XmlUtils.findNextStartTagOrThrowNoRecurse(parser, TIMEZONES_ELEMENT);
            String ianaVersion = parser.getAttributeValue(null, IANA_VERSION_ATTRIBUTE);
            if (!processor.processHeader(ianaVersion)) {
                return;
            }
            XmlUtils.findNextStartTagOrThrowNoRecurse(parser, COUNTRY_ZONES_ELEMENT);
            if (!TimeZoneFinder.processCountryZones(parser, processor)) {
                return;
            }
            XmlUtils.checkOnEndTag(parser, COUNTRY_ZONES_ELEMENT);
            parser.next();
            XmlUtils.consumeUntilEndTag(parser, TIMEZONES_ELEMENT);
            XmlUtils.checkOnEndTag(parser, TIMEZONES_ELEMENT);
        }
    }

    private static boolean processCountryZones(XmlPullParser parser, TimeZonesProcessor processor) throws IOException, XmlPullParserException {
        while (XmlUtils.findNextStartTagOrEndTagNoRecurse(parser, COUNTRY_ELEMENT)) {
            String code = parser.getAttributeValue(null, COUNTRY_CODE_ATTRIBUTE);
            if (code == null || code.isEmpty()) {
                throw new XmlPullParserException("Unable to find country code: " + parser.getPositionDescription());
            }
            String defaultTimeZoneId = parser.getAttributeValue(null, DEFAULT_TIME_ZONE_ID_ATTRIBUTE);
            if (defaultTimeZoneId == null || defaultTimeZoneId.isEmpty()) {
                throw new XmlPullParserException("Unable to find default time zone ID: " + parser.getPositionDescription());
            }
            boolean defaultTimeZoneBoost = XmlUtils.parseBooleanAttribute(parser, DEFAULT_TIME_ZONE_BOOST_ATTRIBUTE, false);
            Boolean everUsesUtc = XmlUtils.parseBooleanAttribute(parser, EVER_USES_UTC_ATTRIBUTE, null);
            if (everUsesUtc == null) {
                throw new XmlPullParserException("Unable to find UTC hint attribute (everutc): " + parser.getPositionDescription());
            }
            String debugInfo = parser.getPositionDescription();
            List<CountryTimeZones.TimeZoneMapping> timeZoneMappings = TimeZoneFinder.parseTimeZoneMappings(parser);
            boolean result = processor.processCountryZones(code, defaultTimeZoneId, defaultTimeZoneBoost, everUsesUtc, timeZoneMappings, debugInfo);
            if (!result) {
                return false;
            }
            XmlUtils.checkOnEndTag(parser, COUNTRY_ELEMENT);
        }
        return true;
    }

    private static List<CountryTimeZones.TimeZoneMapping> parseTimeZoneMappings(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<CountryTimeZones.TimeZoneMapping> timeZoneMappings = new ArrayList<CountryTimeZones.TimeZoneMapping>();
        while (XmlUtils.findNextStartTagOrEndTagNoRecurse(parser, ZONE_ID_ELEMENT)) {
            boolean showInPicker = XmlUtils.parseBooleanAttribute(parser, ZONE_SHOW_IN_PICKER_ATTRIBUTE, true);
            Long notUsedAfter = XmlUtils.parseLongAttribute(parser, ZONE_NOT_USED_AFTER_ATTRIBUTE, null);
            String zoneIdString = XmlUtils.consumeText(parser);
            XmlUtils.checkOnEndTag(parser, ZONE_ID_ELEMENT);
            if (zoneIdString == null || zoneIdString.length() == 0) {
                throw new XmlPullParserException("Missing text for id): " + parser.getPositionDescription());
            }
            CountryTimeZones.TimeZoneMapping timeZoneMapping = new CountryTimeZones.TimeZoneMapping(zoneIdString, showInPicker, notUsedAfter);
            timeZoneMappings.add(timeZoneMapping);
        }
        return Collections.unmodifiableList(timeZoneMappings);
    }

    private static class SelectiveCountryTimeZonesExtractor
    implements TimeZonesProcessor {
        private final String countryCodeToMatch;
        private CountryTimeZones validatedCountryTimeZones;

        private SelectiveCountryTimeZonesExtractor(String countryCodeToMatch) {
            this.countryCodeToMatch = XmlUtils.normalizeCountryIso(countryCodeToMatch);
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoost, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) {
            if (!this.countryCodeToMatch.equals(countryIso = XmlUtils.normalizeCountryIso(countryIso))) {
                return true;
            }
            this.validatedCountryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, defaultTimeZoneBoost, everUsesUtc, timeZoneMappings, debugInfo);
            return false;
        }

        CountryTimeZones getValidatedCountryTimeZones() {
            return this.validatedCountryTimeZones;
        }
    }

    private static class CountryZonesLookupExtractor
    implements TimeZonesProcessor {
        private List<CountryTimeZones> countryTimeZonesList = new ArrayList<CountryTimeZones>(250);

        private CountryZonesLookupExtractor() {
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoost, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            CountryTimeZones countryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, defaultTimeZoneBoost, everUsesUtc, timeZoneMappings, debugInfo);
            this.countryTimeZonesList.add(countryTimeZones);
            return true;
        }

        CountryZonesFinder getCountryZonesLookup() {
            return new CountryZonesFinder(this.countryTimeZonesList);
        }
    }

    private static class IanaVersionExtractor
    implements TimeZonesProcessor {
        private String ianaVersion;

        private IanaVersionExtractor() {
        }

        @Override
        public boolean processHeader(String ianaVersion) throws XmlPullParserException {
            this.ianaVersion = ianaVersion;
            return false;
        }

        public String getIanaVersion() {
            return this.ianaVersion;
        }
    }

    private static class TimeZonesValidator
    implements TimeZonesProcessor {
        private final Set<String> knownCountryCodes = new HashSet<String>();

        private TimeZonesValidator() {
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoost, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            if (!XmlUtils.normalizeCountryIso(countryIso).equals(countryIso)) {
                throw new XmlPullParserException("Country code: " + countryIso + " is not normalized at " + debugInfo);
            }
            if (this.knownCountryCodes.contains(countryIso)) {
                throw new XmlPullParserException("Second entry for country code: " + countryIso + " at " + debugInfo);
            }
            if (timeZoneMappings.isEmpty()) {
                throw new XmlPullParserException("No time zone IDs for country code: " + countryIso + " at " + debugInfo);
            }
            if (!CountryTimeZones.TimeZoneMapping.containsTimeZoneId(timeZoneMappings, defaultTimeZoneId)) {
                throw new XmlPullParserException("defaultTimeZoneId for country code: " + countryIso + " is not one of the zones " + timeZoneMappings + " at " + debugInfo);
            }
            this.knownCountryCodes.add(countryIso);
            return true;
        }
    }

    private static interface TimeZonesProcessor {
        public static final boolean CONTINUE = true;
        public static final boolean HALT = false;

        default public boolean processHeader(String ianaVersion) throws XmlPullParserException {
            return true;
        }

        default public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoost, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            return true;
        }
    }
}

