/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

class SysUiOverlay
extends View {
    private final Path mCornerPath;
    private final Path mNotchPath;
    private final Paint mCornerPaint;
    private final Paint mNotchPaint;
    private final int mNotchTopWidth;

    private static Path createCornerPath(float width, float height, float r) {
        Path corner = new Path();
        corner.moveTo(0.0f, 0.0f);
        corner.lineTo(width, 0.0f);
        corner.cubicTo(width, 0.0f, width / 2.0f - r, height / 2.0f - r, 0.0f, height);
        corner.close();
        return corner;
    }

    private static Path createNotchPath(float topWidth, float bottomWidth, float height, float r) {
        Path corner = new Path();
        corner.moveTo(0.0f, 0.0f);
        float widthDiff = topWidth - bottomWidth;
        corner.lineTo(topWidth, 0.0f);
        corner.lineTo(topWidth - widthDiff / 2.0f, height);
        corner.lineTo(widthDiff / 2.0f, height);
        corner.close();
        return corner;
    }

    private static float dpToPx(DisplayMetrics metrics, float value) {
        return TypedValue.applyDimension(0, value, metrics);
    }

    public SysUiOverlay(Context context, int cornerSizeDp, int radiusDp, int topNotchWidthDp, int bottomNotchWidthDp, int notchHeightDp) {
        super(context);
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float cornerSizePx = SysUiOverlay.dpToPx(metrics, cornerSizeDp);
        float radiusPx = SysUiOverlay.dpToPx(metrics, radiusDp);
        float topNotchWidthPx = SysUiOverlay.dpToPx(metrics, topNotchWidthDp);
        float bottomNotchWidthPx = SysUiOverlay.dpToPx(metrics, bottomNotchWidthDp);
        float notchHeightPx = SysUiOverlay.dpToPx(metrics, notchHeightDp);
        this.mCornerPath = SysUiOverlay.createCornerPath(cornerSizePx, cornerSizePx, radiusPx);
        this.mNotchPath = SysUiOverlay.createNotchPath(topNotchWidthPx, bottomNotchWidthPx, notchHeightPx, 0.0f);
        this.mNotchTopWidth = topNotchWidthDp;
        this.mCornerPaint = new Paint();
        this.mCornerPaint.setColor(-16777216);
        this.mCornerPaint.setStrokeWidth(0.0f);
        this.mCornerPaint.setAntiAlias(true);
        this.mNotchPaint = new Paint();
        this.mNotchPaint.setColor(-16777216);
        this.mNotchPaint.setStrokeWidth(0.0f);
        this.mNotchPaint.setAntiAlias(true);
    }

    public void setCornerColor(int color2) {
        this.mCornerPaint.setColor(color2);
    }

    public void setNotchColor(int color2) {
        this.mNotchPaint.setColor(color2);
    }

    private void paintRoundedBorders(Canvas canvas) {
        canvas.drawPath(this.mCornerPath, this.mCornerPaint);
        canvas.save();
        canvas.translate(this.getWidth(), 0.0f);
        canvas.rotate(90.0f);
        canvas.drawPath(this.mCornerPath, this.mCornerPaint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.getWidth(), this.getHeight());
        canvas.rotate(180.0f);
        canvas.drawPath(this.mCornerPath, this.mCornerPaint);
        canvas.restore();
        canvas.save();
        canvas.translate(0.0f, this.getHeight());
        canvas.rotate(270.0f);
        canvas.drawPath(this.mCornerPath, this.mCornerPaint);
        canvas.restore();
    }

    private void paintNotch(Canvas canvas) {
        canvas.translate(this.getWidth() / 2 - this.mNotchTopWidth / 2, 0.0f);
        canvas.drawPath(this.mNotchPath, this.mNotchPaint);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.paintRoundedBorders(canvas);
        this.paintNotch(canvas);
    }
}

