/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.os.UserHandle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ChooserListAdapter;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.widget.GridLayoutManager;
import com.android.internal.widget.RecyclerView;

@VisibleForTesting
public class ChooserMultiProfilePagerAdapter
extends AbstractMultiProfilePagerAdapter {
    private static final int SINGLE_CELL_SPAN_SIZE = 1;
    private final ChooserProfileDescriptor[] mItems;
    private final boolean mIsSendAction;
    private int mBottomOffset;

    ChooserMultiProfilePagerAdapter(Context context, ChooserActivity.ChooserGridAdapter adapter, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean isSendAction) {
        super(context, 0, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ChooserProfileDescriptor[]{this.createProfileDescriptor(adapter)};
        this.mIsSendAction = isSendAction;
    }

    ChooserMultiProfilePagerAdapter(Context context, ChooserActivity.ChooserGridAdapter personalAdapter, ChooserActivity.ChooserGridAdapter workAdapter, @AbstractMultiProfilePagerAdapter.Profile int defaultProfile, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean isSendAction) {
        super(context, defaultProfile, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ChooserProfileDescriptor[]{this.createProfileDescriptor(personalAdapter), this.createProfileDescriptor(workAdapter)};
        this.mIsSendAction = isSendAction;
    }

    private ChooserProfileDescriptor createProfileDescriptor(ChooserActivity.ChooserGridAdapter adapter) {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        ViewGroup rootView = (ViewGroup)inflater.inflate(17367132, null, false);
        return new ChooserProfileDescriptor(rootView, adapter);
    }

    RecyclerView getListViewForIndex(int index) {
        return this.getItem(index).recyclerView;
    }

    @Override
    ChooserProfileDescriptor getItem(int pageIndex) {
        return this.mItems[pageIndex];
    }

    @Override
    int getItemCount() {
        return this.mItems.length;
    }

    @Override
    @VisibleForTesting
    public ChooserActivity.ChooserGridAdapter getAdapterForIndex(int pageIndex) {
        return this.mItems[pageIndex].chooserGridAdapter;
    }

    @Override
    ChooserListAdapter getListAdapterForUserHandle(UserHandle userHandle) {
        if (this.getActiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getActiveListAdapter();
        }
        if (this.getInactiveListAdapter() != null && this.getInactiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getInactiveListAdapter();
        }
        return null;
    }

    @Override
    void setupListAdapter(int pageIndex) {
        RecyclerView recyclerView = this.getItem(pageIndex).recyclerView;
        final ChooserActivity.ChooserGridAdapter chooserGridAdapter = this.getItem(pageIndex).chooserGridAdapter;
        final GridLayoutManager glm = (GridLayoutManager)recyclerView.getLayoutManager();
        glm.setSpanCount(chooserGridAdapter.getMaxTargetsPerRow());
        glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            @Override
            public int getSpanSize(int position) {
                return chooserGridAdapter.shouldCellSpan(position) ? 1 : glm.getSpanCount();
            }
        });
    }

    @Override
    @VisibleForTesting
    public ChooserListAdapter getActiveListAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage()).getListAdapter();
    }

    @Override
    @VisibleForTesting
    public ChooserListAdapter getInactiveListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1 - this.getCurrentPage()).getListAdapter();
    }

    @Override
    public ResolverListAdapter getPersonalListAdapter() {
        return this.getAdapterForIndex(0).getListAdapter();
    }

    @Override
    public ResolverListAdapter getWorkListAdapter() {
        return this.getAdapterForIndex(1).getListAdapter();
    }

    @Override
    ChooserActivity.ChooserGridAdapter getCurrentRootAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage());
    }

    @Override
    RecyclerView getActiveAdapterView() {
        return this.getListViewForIndex(this.getCurrentPage());
    }

    @Override
    RecyclerView getInactiveAdapterView() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getListViewForIndex(1 - this.getCurrentPage());
    }

    @Override
    String getMetricsCategory() {
        return "intent_chooser";
    }

    @Override
    protected void showWorkProfileOffEmptyState(ResolverListAdapter activeListAdapter, View.OnClickListener listener) {
        this.showEmptyState(activeListAdapter, 17302875, 17041143, 0, listener);
    }

    @Override
    protected void showNoPersonalToWorkIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(activeListAdapter, 17302823, 17041134, 17041135);
        } else {
            this.showEmptyState(activeListAdapter, 17302823, 17041130, 17041131);
        }
    }

    @Override
    protected void showNoWorkToPersonalIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(activeListAdapter, 17302823, 17041132, 17041133);
        } else {
            this.showEmptyState(activeListAdapter, 17302823, 17041128, 17041129);
        }
    }

    @Override
    protected void showNoPersonalAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(listAdapter, 17302753, 17041137, 0);
        } else {
            this.showEmptyState(listAdapter, 17302753, 17041136, 0);
        }
    }

    @Override
    protected void showNoWorkAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(listAdapter, 17302753, 17041139, 0);
        } else {
            this.showEmptyState(listAdapter, 17302753, 17041138, 0);
        }
    }

    void setEmptyStateBottomOffset(int bottomOffset) {
        this.mBottomOffset = bottomOffset;
    }

    @Override
    protected void setupContainerPadding(View container) {
        container.setPadding(container.getPaddingLeft(), container.getPaddingTop(), container.getPaddingRight(), container.getPaddingBottom() + this.mBottomOffset);
    }

    class ChooserProfileDescriptor
    extends AbstractMultiProfilePagerAdapter.ProfileDescriptor {
        private ChooserActivity.ChooserGridAdapter chooserGridAdapter;
        private RecyclerView recyclerView;

        ChooserProfileDescriptor(ViewGroup rootView, ChooserActivity.ChooserGridAdapter adapter) {
            super(rootView);
            this.chooserGridAdapter = adapter;
            this.recyclerView = (RecyclerView)rootView.findViewById(16909355);
        }
    }
}

