/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.os.RemoteException;
import android.util.Singleton;
import android.view.SurfaceControl;
import android.window.ITaskOrganizer;
import android.window.ITaskOrganizerController;
import android.window.WindowContainerToken;
import android.window.WindowOrganizer;
import java.util.List;

public class TaskOrganizer
extends WindowOrganizer {
    private final ITaskOrganizer mInterface = new ITaskOrganizer.Stub(){

        @Override
        public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) {
            TaskOrganizer.this.onTaskAppeared(taskInfo, leash);
        }

        @Override
        public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) {
            TaskOrganizer.this.onTaskVanished(taskInfo);
        }

        @Override
        public void onTaskInfoChanged(ActivityManager.RunningTaskInfo info) {
            TaskOrganizer.this.onTaskInfoChanged(info);
        }

        @Override
        public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo info) {
            TaskOrganizer.this.onBackPressedOnTaskRoot(info);
        }
    };
    private static final Singleton<ITaskOrganizerController> ITaskOrganizerControllerSingleton = new Singleton<ITaskOrganizerController>(){

        @Override
        protected ITaskOrganizerController create() {
            try {
                return WindowOrganizer.getWindowOrganizerController().getTaskOrganizerController();
            }
            catch (RemoteException e) {
                return null;
            }
        }
    };

    public void registerOrganizer(int windowingMode) {
        try {
            TaskOrganizer.getController().registerTaskOrganizer(this.mInterface, windowingMode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterOrganizer() {
        try {
            TaskOrganizer.getController().unregisterTaskOrganizer(this.mInterface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) {
    }

    public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) {
    }

    public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) {
    }

    public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) {
    }

    public static ActivityManager.RunningTaskInfo createRootTask(int displayId, int windowingMode) {
        try {
            return TaskOrganizer.getController().createRootTask(displayId, windowingMode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean deleteRootTask(WindowContainerToken task) {
        try {
            return TaskOrganizer.getController().deleteRootTask(task);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static List<ActivityManager.RunningTaskInfo> getChildTasks(WindowContainerToken parent, int[] activityTypes) {
        try {
            return TaskOrganizer.getController().getChildTasks(parent, activityTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static List<ActivityManager.RunningTaskInfo> getRootTasks(int displayId, int[] activityTypes) {
        try {
            return TaskOrganizer.getController().getRootTasks(displayId, activityTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static WindowContainerToken getImeTarget(int display) {
        try {
            return TaskOrganizer.getController().getImeTarget(display);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setLaunchRoot(int displayId, WindowContainerToken root) {
        try {
            TaskOrganizer.getController().setLaunchRoot(displayId, root);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setInterceptBackPressedOnTaskRoot(boolean interceptBackPressed) {
        try {
            TaskOrganizer.getController().setInterceptBackPressedOnTaskRoot(this.mInterface, interceptBackPressed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static ITaskOrganizerController getController() {
        return ITaskOrganizerControllerSingleton.get();
    }
}

