/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.IDisplayAreaOrganizerController;
import android.window.ITaskOrganizerController;
import android.window.IWindowContainerTransactionCallback;
import android.window.WindowContainerToken;
import android.window.WindowContainerTransaction;

public interface IWindowOrganizerController
extends IInterface {
    public void applyTransaction(WindowContainerTransaction var1) throws RemoteException;

    public int applySyncTransaction(WindowContainerTransaction var1, IWindowContainerTransactionCallback var2) throws RemoteException;

    public ITaskOrganizerController getTaskOrganizerController() throws RemoteException;

    public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException;

    public boolean takeScreenshot(WindowContainerToken var1, SurfaceControl var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowOrganizerController {
        private static final String DESCRIPTOR = "android.window.IWindowOrganizerController";
        static final int TRANSACTION_applyTransaction = 1;
        static final int TRANSACTION_applySyncTransaction = 2;
        static final int TRANSACTION_getTaskOrganizerController = 3;
        static final int TRANSACTION_getDisplayAreaOrganizerController = 4;
        static final int TRANSACTION_takeScreenshot = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowOrganizerController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowOrganizerController) {
                return (IWindowOrganizerController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "applyTransaction";
                }
                case 2: {
                    return "applySyncTransaction";
                }
                case 3: {
                    return "getTaskOrganizerController";
                }
                case 4: {
                    return "getDisplayAreaOrganizerController";
                }
                case 5: {
                    return "takeScreenshot";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    WindowContainerTransaction _arg0 = 0 != data.readInt() ? WindowContainerTransaction.CREATOR.createFromParcel(data) : null;
                    this.applyTransaction(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    WindowContainerTransaction _arg0 = 0 != data.readInt() ? WindowContainerTransaction.CREATOR.createFromParcel(data) : null;
                    IWindowContainerTransactionCallback _arg1 = IWindowContainerTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    int _result = this.applySyncTransaction(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ITaskOrganizerController _result = this.getTaskOrganizerController();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IDisplayAreaOrganizerController _result = this.getDisplayAreaOrganizerController();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    WindowContainerToken _arg0 = 0 != data.readInt() ? WindowContainerToken.CREATOR.createFromParcel(data) : null;
                    SurfaceControl _arg1 = new SurfaceControl();
                    boolean _result = this.takeScreenshot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWindowOrganizerController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWindowOrganizerController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWindowOrganizerController {
            private IBinder mRemote;
            public static IWindowOrganizerController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyTransaction(WindowContainerTransaction t) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (t != null) {
                        _data.writeInt(1);
                        t.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().applyTransaction(t);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int applySyncTransaction(WindowContainerTransaction t, IWindowContainerTransactionCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (t != null) {
                        _data.writeInt(1);
                        t.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().applySyncTransaction(t, callback);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITaskOrganizerController getTaskOrganizerController() throws RemoteException {
                ITaskOrganizerController _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ITaskOrganizerController iTaskOrganizerController = Stub.getDefaultImpl().getTaskOrganizerController();
                        return iTaskOrganizerController;
                    }
                    _reply.readException();
                    _result = ITaskOrganizerController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException {
                IDisplayAreaOrganizerController _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IDisplayAreaOrganizerController iDisplayAreaOrganizerController = Stub.getDefaultImpl().getDisplayAreaOrganizerController();
                        return iDisplayAreaOrganizerController;
                    }
                    _reply.readException();
                    _result = IDisplayAreaOrganizerController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean takeScreenshot(WindowContainerToken token, SurfaceControl outSurfaceControl) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().takeScreenshot(token, outSurfaceControl);
                        return bl;
                    }
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWindowOrganizerController {
        @Override
        public void applyTransaction(WindowContainerTransaction t) throws RemoteException {
        }

        @Override
        public int applySyncTransaction(WindowContainerTransaction t, IWindowContainerTransactionCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public ITaskOrganizerController getTaskOrganizerController() throws RemoteException {
            return null;
        }

        @Override
        public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException {
            return null;
        }

        @Override
        public boolean takeScreenshot(WindowContainerToken token, SurfaceControl outSurfaceControl) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

