/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class EditorTouchState {
    private float mLastDownX;
    private float mLastDownY;
    private long mLastDownMillis;
    private float mLastUpX;
    private float mLastUpY;
    private long mLastUpMillis;
    private boolean mIsOnHandle;
    private int mMultiTapStatus = 0;
    private boolean mMultiTapInSameArea;
    private boolean mMovedEnoughForDrag;
    private boolean mIsDragCloseToVertical;

    public float getLastDownX() {
        return this.mLastDownX;
    }

    public float getLastDownY() {
        return this.mLastDownY;
    }

    public float getLastUpX() {
        return this.mLastUpX;
    }

    public float getLastUpY() {
        return this.mLastUpY;
    }

    public boolean isDoubleTap() {
        return this.mMultiTapStatus == 2;
    }

    public boolean isTripleClick() {
        return this.mMultiTapStatus == 3;
    }

    public boolean isMultiTap() {
        return this.mMultiTapStatus == 2 || this.mMultiTapStatus == 3;
    }

    public boolean isMultiTapInSameArea() {
        return this.isMultiTap() && this.mMultiTapInSameArea;
    }

    public boolean isMovedEnoughForDrag() {
        return this.mMovedEnoughForDrag;
    }

    public boolean isDragCloseToVertical() {
        return this.mIsDragCloseToVertical && !this.mIsOnHandle;
    }

    public void setIsOnHandle(boolean onHandle) {
        this.mIsOnHandle = onHandle;
    }

    public boolean isOnHandle() {
        return this.mIsOnHandle;
    }

    public void update(MotionEvent event, ViewConfiguration config) {
        int action = event.getActionMasked();
        if (action == 0) {
            boolean isMouse = event.isFromSource(8194);
            long millisSinceLastUp = event.getEventTime() - this.mLastUpMillis;
            long millisBetweenLastDownAndLastUp = this.mLastUpMillis - this.mLastDownMillis;
            if (millisSinceLastUp <= (long)ViewConfiguration.getDoubleTapTimeout() && millisBetweenLastDownAndLastUp <= (long)ViewConfiguration.getDoubleTapTimeout() && (this.mMultiTapStatus == 1 || this.mMultiTapStatus == 2 && isMouse)) {
                this.mMultiTapStatus = this.mMultiTapStatus == 1 ? 2 : 3;
                this.mMultiTapInSameArea = EditorTouchState.isDistanceWithin(this.mLastDownX, this.mLastDownY, event.getX(), event.getY(), config.getScaledDoubleTapSlop());
            } else {
                this.mMultiTapStatus = 1;
                this.mMultiTapInSameArea = false;
            }
            this.mLastDownX = event.getX();
            this.mLastDownY = event.getY();
            this.mLastDownMillis = event.getEventTime();
            this.mMovedEnoughForDrag = false;
            this.mIsDragCloseToVertical = false;
        } else if (action == 1) {
            this.mLastUpX = event.getX();
            this.mLastUpY = event.getY();
            this.mLastUpMillis = event.getEventTime();
            this.mMovedEnoughForDrag = false;
            this.mIsDragCloseToVertical = false;
        } else if (action == 2) {
            if (!this.mMovedEnoughForDrag) {
                int touchSlop;
                float deltaY;
                float deltaX = event.getX() - this.mLastDownX;
                float deltaXSquared = deltaX * deltaX;
                float distanceSquared = deltaXSquared + (deltaY = event.getY() - this.mLastDownY) * deltaY;
                boolean bl = this.mMovedEnoughForDrag = distanceSquared > (float)((touchSlop = config.getScaledTouchSlop()) * touchSlop);
                if (this.mMovedEnoughForDrag) {
                    this.mIsDragCloseToVertical = Math.abs(deltaX) <= Math.abs(deltaY);
                }
            }
        } else if (action == 3) {
            this.mLastDownMillis = 0L;
            this.mLastUpMillis = 0L;
            this.mMultiTapStatus = 0;
            this.mMultiTapInSameArea = false;
            this.mMovedEnoughForDrag = false;
            this.mIsDragCloseToVertical = false;
        }
    }

    public static boolean isDistanceWithin(float x1, float y1, float x2, float y2, int maxDistance) {
        float deltaX = x2 - x1;
        float deltaY = y2 - y1;
        float distanceSquared = deltaX * deltaX + deltaY * deltaY;
        return distanceSquared <= (float)(maxDistance * maxDistance);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @VisibleForTesting
    public static @interface MultiTapStatus {
        public static final int NONE = 0;
        public static final int FIRST_TAP = 1;
        public static final int DOUBLE_TAP = 2;
        public static final int TRIPLE_CLICK = 3;
    }
}

