/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.ViewGroup;
import android.view.math.Math3DHelper;
import android.view.shadow.AmbientShadowConfig;
import android.view.shadow.AmbientShadowTriangulator;
import android.view.shadow.SpotShadowConfig;
import android.view.shadow.SpotShadowTriangulator;
import android.view.shadow.TriangleBuffer;

public class HighQualityShadowPainter {
    private static final float sRoundedGap = (float)(1.0 - Math.sqrt(2.0) / 2.0);

    private HighQualityShadowPainter() {
    }

    public static void paintRectShadow(ViewGroup parent, Outline outline, float elevation, Canvas canvas, float alpha, float densityDpi) {
        float[] shadowBounds;
        if (!HighQualityShadowPainter.validate(elevation, densityDpi)) {
            return;
        }
        int width = parent.getWidth() / 5;
        int height = parent.getHeight() / 5;
        Rect rectOriginal = new Rect();
        Rect rectScaled = new Rect();
        if (!outline.getRect(rectScaled) || alpha < 0.2f) {
            return;
        }
        outline.getRect(rectOriginal);
        rectScaled.left /= 5;
        rectScaled.right /= 5;
        rectScaled.top /= 5;
        rectScaled.bottom /= 5;
        float radius = outline.getRadius() / 5.0f;
        if (radius > (float)rectScaled.width() || radius > (float)rectScaled.height()) {
            return;
        }
        alpha = alpha > 1.0f ? 1.0f : alpha;
        boolean isOpaque = outline.getAlpha() * alpha == 1.0f;
        float[] poly = HighQualityShadowPainter.getPoly(rectScaled, elevation / 5.0f, radius);
        AmbientShadowConfig ambientConfig = new AmbientShadowConfig.Builder().setPolygon(poly).setLightSourcePosition((float)(rectScaled.left + rectScaled.right) / 2.0f, (float)(rectScaled.top + rectScaled.bottom) / 2.0f).setEdgeScale(60.0f).setShadowBoundRatio(0.099999994f).setShadowStrength(1.0f * alpha).build();
        AmbientShadowTriangulator ambientTriangulator = new AmbientShadowTriangulator(ambientConfig);
        ambientTriangulator.triangulate();
        SpotShadowTriangulator spotTriangulator = null;
        float lightZHeightPx = 10.0f * (densityDpi / 160.0f);
        if (lightZHeightPx - elevation / 5.0f >= 2.0f) {
            float lightX = (rectScaled.left + rectScaled.right) / 2;
            float lightY = rectScaled.top;
            int dynamicLightRadius = Math.min(rectScaled.width(), rectScaled.height());
            SpotShadowConfig spotConfig = new SpotShadowConfig.Builder().setLightCoord(lightX, lightY, lightZHeightPx).setLightRadius(dynamicLightRadius).setShadowStrength(0.3f * alpha).setPolygon(poly, poly.length / 3).build();
            spotTriangulator = new SpotShadowTriangulator(spotConfig);
            spotTriangulator.triangulate();
        }
        int translateX = 0;
        int translateY = 0;
        int imgW = 0;
        int imgH = 0;
        if (ambientTriangulator.isValid()) {
            shadowBounds = Math3DHelper.flatBound(ambientTriangulator.getVertices(), 2);
            translateX = -((int)Math.floor(shadowBounds[0]));
            translateY = -((int)Math.floor(shadowBounds[1]));
            imgW = (int)Math.ceil(shadowBounds[2] + (float)translateX);
            imgH = (int)Math.ceil(shadowBounds[3] + (float)translateY);
        }
        if (spotTriangulator != null && spotTriangulator.validate()) {
            shadowBounds = Math3DHelper.flatBound(spotTriangulator.getStrips()[0], 3);
            if (shadowBounds[2] - shadowBounds[0] > (float)width || shadowBounds[3] - shadowBounds[1] > (float)height) {
                spotTriangulator = null;
            }
            translateX = Math.max(-((int)Math.floor(shadowBounds[0])), translateX);
            translateY = Math.max(-((int)Math.floor(shadowBounds[1])), translateY);
            imgW = Math.max((int)Math.ceil(shadowBounds[2] + (float)translateX), imgW);
            imgH = Math.max((int)Math.ceil(shadowBounds[3] + (float)translateY), imgH);
        }
        TriangleBuffer renderer = new TriangleBuffer();
        renderer.setSize(imgW, imgH, 0);
        if (ambientTriangulator.isValid()) {
            Math3DHelper.translate(ambientTriangulator.getVertices(), translateX, translateY, 2);
            renderer.drawTriangles(ambientTriangulator.getIndices(), ambientTriangulator.getVertices(), ambientTriangulator.getColors(), ambientConfig.getShadowStrength());
        }
        if (spotTriangulator != null && spotTriangulator.validate()) {
            float[][] strips = spotTriangulator.getStrips();
            for (int i = 0; i < strips.length; ++i) {
                Math3DHelper.translate(strips[i], translateX, translateY, 3);
                renderer.drawTriangles(strips[i], 0.3f * alpha);
            }
        }
        Bitmap img = renderer.createImage();
        HighQualityShadowPainter.drawScaled(canvas, img, translateX, translateY, rectOriginal, radius, isOpaque);
    }

    private static boolean validate(float elevation, float densityDpi) {
        float scaledElevationPx = elevation / 5.0f;
        float scaledSpotLightHeightPx = 10.0f * (densityDpi / 160.0f);
        return !(scaledElevationPx > scaledSpotLightHeightPx);
    }

    private static void drawScaled(Canvas canvas, Bitmap bitmap, int translateX, int translateY, Rect shadowCaster, float radius, boolean isOpaque) {
        int unscaledTranslateX = translateX * 5;
        int unscaledTranslateY = translateY * 5;
        Rect dest = new Rect(-unscaledTranslateX, -unscaledTranslateY, bitmap.getWidth() * 5 - unscaledTranslateX, bitmap.getHeight() * 5 - unscaledTranslateY);
        Rect destSrc = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        if (radius > 0.0f && !isOpaque) {
            int save = canvas.save();
            canvas.drawBitmap(bitmap, destSrc, dest, null);
            canvas.restoreToCount(save);
            return;
        }
        int gap = (int)Math.ceil(radius * 5.0f * sRoundedGap);
        shadowCaster.bottom -= gap;
        shadowCaster.top += gap;
        shadowCaster.left += gap;
        shadowCaster.right -= gap;
        Rect left = new Rect(dest.left, shadowCaster.top, shadowCaster.left, shadowCaster.bottom);
        int leftScaled = left.width() / 5 + destSrc.left;
        Rect top = new Rect(dest.left, dest.top, dest.right, shadowCaster.top);
        int topScaled = top.height() / 5 + destSrc.top;
        Rect right = new Rect(shadowCaster.right, shadowCaster.top, dest.right, shadowCaster.bottom);
        int rightScaled = (shadowCaster.right - dest.left) / 5 + destSrc.left;
        Rect bottom = new Rect(dest.left, shadowCaster.bottom, dest.right, dest.bottom);
        int bottomScaled = (shadowCaster.bottom - dest.top) / 5 + destSrc.top;
        Rect leftSrc = new Rect(destSrc.left, topScaled, leftScaled, bottomScaled);
        Rect topSrc = new Rect(destSrc.left, destSrc.top, destSrc.right, topScaled);
        Rect rightSrc = new Rect(rightScaled, topScaled, destSrc.right, bottomScaled);
        Rect bottomSrc = new Rect(destSrc.left, bottomScaled, destSrc.right, destSrc.bottom);
        int save = canvas.save();
        Paint paint = new Paint();
        canvas.drawBitmap(bitmap, leftSrc, left, paint);
        canvas.drawBitmap(bitmap, topSrc, top, paint);
        canvas.drawBitmap(bitmap, rightSrc, right, paint);
        canvas.drawBitmap(bitmap, bottomSrc, bottom, paint);
        canvas.restoreToCount(save);
    }

    private static float[] getPoly(Rect rect, float elevation, float radius) {
        if (radius <= 0.0f) {
            float[] poly = new float[12];
            poly[0] = poly[9] = (float)rect.left;
            poly[1] = poly[4] = (float)rect.top;
            poly[3] = poly[6] = (float)rect.right;
            poly[7] = poly[10] = (float)rect.bottom;
            poly[8] = poly[11] = elevation;
            poly[5] = poly[11];
            poly[2] = poly[11];
            return poly;
        }
        return HighQualityShadowPainter.buildRoundedEdges(rect, elevation, radius);
    }

    private static float[] buildRoundedEdges(Rect rect, float elevation, float radius) {
        float y;
        float x;
        double theta;
        int i;
        float[] roundedEdgeVertices = new float[72];
        int index = 0;
        for (i = 0; i <= 5; ++i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.left + ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.top + ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 5; i >= 0; --i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.right - ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.top + ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 0; i <= 5; ++i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.right - ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.bottom - ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        for (i = 5; i >= 0; --i) {
            theta = 1.5707963267948966 * ((double)i / 5.0);
            x = (float)((double)rect.left + ((double)radius - (double)radius * Math.cos(theta)));
            y = (float)((double)rect.bottom - ((double)radius - (double)radius * Math.sin(theta)));
            roundedEdgeVertices[index++] = x;
            roundedEdgeVertices[index++] = y;
            roundedEdgeVertices[index++] = elevation;
        }
        return roundedEdgeVertices;
    }
}

