/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.LocusId;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.contentcapture.ContentCaptureSessionId;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ContentCaptureContext
implements Parcelable {
    @SystemApi
    public static final int FLAG_DISABLED_BY_APP = 1;
    @SystemApi
    public static final int FLAG_DISABLED_BY_FLAG_SECURE = 2;
    @SystemApi
    public static final int FLAG_RECONNECTED = 4;
    private final boolean mHasClientContext;
    private final Bundle mExtras;
    private final LocusId mId;
    private final ComponentName mComponentName;
    private final int mTaskId;
    private final int mFlags;
    private final int mDisplayId;
    private int mParentSessionId = 0;
    public static final Parcelable.Creator<ContentCaptureContext> CREATOR = new Parcelable.Creator<ContentCaptureContext>(){

        @Override
        public ContentCaptureContext createFromParcel(Parcel parcel) {
            ContentCaptureContext clientContext;
            boolean hasClientContext;
            boolean bl = hasClientContext = parcel.readInt() == 1;
            if (hasClientContext) {
                LocusId id2 = (LocusId)parcel.readParcelable(null);
                Bundle extras = parcel.readBundle();
                Builder builder = new Builder(id2);
                if (extras != null) {
                    builder.setExtras(extras);
                }
                clientContext = new ContentCaptureContext(builder);
            } else {
                clientContext = null;
            }
            ComponentName componentName = (ComponentName)parcel.readParcelable(null);
            if (componentName == null) {
                return clientContext;
            }
            int taskId = parcel.readInt();
            int displayId = parcel.readInt();
            int flags = parcel.readInt();
            return new ContentCaptureContext(clientContext, componentName, taskId, displayId, flags);
        }

        public ContentCaptureContext[] newArray(int size) {
            return new ContentCaptureContext[size];
        }
    };

    public ContentCaptureContext(ContentCaptureContext clientContext, ComponentName componentName, int taskId, int displayId, int flags) {
        if (clientContext != null) {
            this.mHasClientContext = true;
            this.mExtras = clientContext.mExtras;
            this.mId = clientContext.mId;
        } else {
            this.mHasClientContext = false;
            this.mExtras = null;
            this.mId = null;
        }
        this.mComponentName = Preconditions.checkNotNull(componentName);
        this.mTaskId = taskId;
        this.mDisplayId = displayId;
        this.mFlags = flags;
    }

    private ContentCaptureContext(Builder builder) {
        this.mHasClientContext = true;
        this.mExtras = builder.mExtras;
        this.mId = builder.mId;
        this.mComponentName = null;
        this.mFlags = 0;
        this.mTaskId = 0;
        this.mDisplayId = -1;
    }

    public ContentCaptureContext(ContentCaptureContext original, int extraFlags) {
        this.mHasClientContext = original.mHasClientContext;
        this.mExtras = original.mExtras;
        this.mId = original.mId;
        this.mComponentName = original.mComponentName;
        this.mTaskId = original.mTaskId;
        this.mFlags = original.mFlags | extraFlags;
        this.mDisplayId = original.mDisplayId;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public LocusId getLocusId() {
        return this.mId;
    }

    @SystemApi
    public int getTaskId() {
        return this.mTaskId;
    }

    @SystemApi
    public ComponentName getActivityComponent() {
        return this.mComponentName;
    }

    @SystemApi
    public ContentCaptureSessionId getParentSessionId() {
        return this.mParentSessionId == 0 ? null : new ContentCaptureSessionId(this.mParentSessionId);
    }

    public void setParentSessionId(int parentSessionId) {
        this.mParentSessionId = parentSessionId;
    }

    @SystemApi
    public int getDisplayId() {
        return this.mDisplayId;
    }

    @SystemApi
    public int getFlags() {
        return this.mFlags;
    }

    public static ContentCaptureContext forLocusId(String id2) {
        return new Builder(new LocusId(id2)).build();
    }

    public void dump(PrintWriter pw) {
        if (this.mComponentName != null) {
            pw.print("activity=");
            pw.print(this.mComponentName.flattenToShortString());
        }
        if (this.mId != null) {
            pw.print(", id=");
            this.mId.dump(pw);
        }
        pw.print(", taskId=");
        pw.print(this.mTaskId);
        pw.print(", displayId=");
        pw.print(this.mDisplayId);
        if (this.mParentSessionId != 0) {
            pw.print(", parentId=");
            pw.print(this.mParentSessionId);
        }
        if (this.mFlags > 0) {
            pw.print(", flags=");
            pw.print(this.mFlags);
        }
        if (this.mExtras != null) {
            pw.print(", hasExtras");
        }
    }

    private boolean fromServer() {
        return this.mComponentName != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Context[");
        if (this.fromServer()) {
            builder.append("act=").append(ComponentName.flattenToShortString(this.mComponentName)).append(", taskId=").append(this.mTaskId).append(", displayId=").append(this.mDisplayId).append(", flags=").append(this.mFlags);
        } else {
            builder.append("id=").append(this.mId);
            if (this.mExtras != null) {
                builder.append(", hasExtras");
            }
        }
        if (this.mParentSessionId != 0) {
            builder.append(", parentId=").append(this.mParentSessionId);
        }
        return builder.append(']').toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mHasClientContext ? 1 : 0);
        if (this.mHasClientContext) {
            parcel.writeParcelable(this.mId, flags);
            parcel.writeBundle(this.mExtras);
        }
        parcel.writeParcelable(this.mComponentName, flags);
        if (this.fromServer()) {
            parcel.writeInt(this.mTaskId);
            parcel.writeInt(this.mDisplayId);
            parcel.writeInt(this.mFlags);
        }
    }

    public static class Builder {
        private Bundle mExtras;
        private final LocusId mId;
        private boolean mDestroyed;

        public Builder(LocusId id2) {
            this.mId = Preconditions.checkNotNull(id2);
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = Preconditions.checkNotNull(extras);
            this.throwIfDestroyed();
            return this;
        }

        public ContentCaptureContext build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new ContentCaptureContext(this);
        }

        private void throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called #build()");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ContextCreationFlags {
    }
}

