/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.util.Pools;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

public class VelocityTracker {
    private static final Pools.SynchronizedPool<VelocityTracker> sPool = new Pools.SynchronizedPool(2);
    private static final int ACTIVE_POINTER_ID = -1;
    private long mPtr;
    private final String mStrategy;

    private static long nativeInitialize(String string2) {
        return OverrideMethod.invokeL("android.view.VelocityTracker#nativeInitialize(Ljava/lang/String;)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeDispose(J)V", true, null);
    }

    private static void nativeClear(long l) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeClear(J)V", true, null);
    }

    private static void nativeAddMovement(long l, MotionEvent motionEvent) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeAddMovement(JLandroid/view/MotionEvent;)V", true, null);
    }

    private static void nativeComputeCurrentVelocity(long l, int n, float f) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeComputeCurrentVelocity(JIF)V", true, null);
    }

    private static float nativeGetXVelocity(long l, int n) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetXVelocity(JI)F", true, null);
    }

    private static float nativeGetYVelocity(long l, int n) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetYVelocity(JI)F", true, null);
    }

    private static boolean nativeGetEstimator(long l, int n, Estimator estimator) {
        return OverrideMethod.invokeI("android.view.VelocityTracker#nativeGetEstimator(JILandroid/view/VelocityTracker$Estimator;)Z", true, null) != 0;
    }

    public static VelocityTracker obtain() {
        VelocityTracker instance = sPool.acquire();
        return instance != null ? instance : new VelocityTracker(null);
    }

    @UnsupportedAppUsage
    public static VelocityTracker obtain(String strategy) {
        if (strategy == null) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(strategy);
    }

    public void recycle() {
        if (this.mStrategy == null) {
            this.clear();
            sPool.release(this);
        }
    }

    private VelocityTracker(String strategy) {
        this.mPtr = VelocityTracker.nativeInitialize(strategy);
        this.mStrategy = strategy;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0L) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, -1);
    }

    public float getYVelocity() {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, -1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, id2);
    }

    public boolean getEstimator(int id2, Estimator outEstimator) {
        if (outEstimator == null) {
            throw new IllegalArgumentException("outEstimator must not be null");
        }
        return VelocityTracker.nativeGetEstimator(this.mPtr, id2, outEstimator);
    }

    public static class Estimator {
        private static final int MAX_DEGREE = 4;
        @UnsupportedAppUsage
        public final float[] xCoeff = new float[5];
        @UnsupportedAppUsage
        public final float[] yCoeff = new float[5];
        @UnsupportedAppUsage
        public int degree;
        @UnsupportedAppUsage
        public float confidence;

        public float estimateX(float time) {
            return this.estimate(time, this.xCoeff);
        }

        public float estimateY(float time) {
            return this.estimate(time, this.yCoeff);
        }

        public float getXCoeff(int index) {
            return index <= this.degree ? this.xCoeff[index] : 0.0f;
        }

        public float getYCoeff(int index) {
            return index <= this.degree ? this.yCoeff[index] : 0.0f;
        }

        private float estimate(float time, float[] c) {
            float a = 0.0f;
            float scale = 1.0f;
            for (int i = 0; i <= this.degree; ++i) {
                a += c[i] * scale;
                scale *= time;
            }
            return a;
        }
    }
}

