/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.SparseIntArray;
import android.view.DisplayCutout;
import android.view.InsetsSource;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class InsetsState
implements Parcelable {
    public static final int ITYPE_INVALID = -1;
    static final int FIRST_TYPE = 0;
    public static final int ITYPE_STATUS_BAR = 0;
    public static final int ITYPE_NAVIGATION_BAR = 1;
    public static final int ITYPE_CAPTION_BAR = 2;
    public static final int ITYPE_TOP_GESTURES = 3;
    public static final int ITYPE_BOTTOM_GESTURES = 4;
    public static final int ITYPE_LEFT_GESTURES = 5;
    public static final int ITYPE_RIGHT_GESTURES = 6;
    public static final int ITYPE_TOP_TAPPABLE_ELEMENT = 7;
    public static final int ITYPE_BOTTOM_TAPPABLE_ELEMENT = 8;
    public static final int ITYPE_LEFT_DISPLAY_CUTOUT = 9;
    public static final int ITYPE_TOP_DISPLAY_CUTOUT = 10;
    public static final int ITYPE_RIGHT_DISPLAY_CUTOUT = 11;
    public static final int ITYPE_BOTTOM_DISPLAY_CUTOUT = 12;
    public static final int ITYPE_IME = 13;
    public static final int ITYPE_CLIMATE_BAR = 14;
    public static final int ITYPE_EXTRA_NAVIGATION_BAR = 15;
    static final int LAST_TYPE = 15;
    public static final int SIZE = 16;
    public static final int ITYPE_SHELF = 1;
    static final int ISIDE_LEFT = 0;
    static final int ISIDE_TOP = 1;
    static final int ISIDE_RIGHT = 2;
    static final int ISIDE_BOTTOM = 3;
    static final int ISIDE_FLOATING = 4;
    static final int ISIDE_UNKNOWN = 5;
    private InsetsSource[] mSources = new InsetsSource[16];
    private final Rect mDisplayFrame = new Rect();
    public static final Parcelable.Creator<InsetsState> CREATOR = new Parcelable.Creator<InsetsState>(){

        @Override
        public InsetsState createFromParcel(Parcel in) {
            return new InsetsState(in);
        }

        public InsetsState[] newArray(int size) {
            return new InsetsState[size];
        }
    };

    public InsetsState() {
    }

    public InsetsState(InsetsState copy) {
        this.set(copy);
    }

    public InsetsState(InsetsState copy, boolean copySources) {
        this.set(copy, copySources);
    }

    public WindowInsets calculateInsets(Rect frame, InsetsState ignoringVisibilityState, boolean isScreenRound, boolean alwaysConsumeSystemBars, DisplayCutout cutout, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags, SparseIntArray typeSideMap) {
        Insets[] typeInsetsMap = new Insets[9];
        Insets[] typeMaxInsetsMap = new Insets[9];
        boolean[] typeVisibilityMap = new boolean[16];
        Rect relativeFrame = new Rect(frame);
        Rect relativeFrameMax = new Rect(frame);
        for (int type = 0; type <= 15; ++type) {
            InsetsSource ignoringVisibilitySource;
            boolean skipLegacyTypes;
            InsetsSource source = this.mSources[type];
            if (source == null) {
                int index = WindowInsets.Type.indexOf(InsetsState.toPublicType(type));
                if (typeInsetsMap[index] != null) continue;
                typeInsetsMap[index] = Insets.NONE;
                continue;
            }
            boolean skipNonImeInImeMode = ViewRootImpl.sNewInsetsMode == 1 && source.getType() != 13;
            boolean skipSystemBars = ViewRootImpl.sNewInsetsMode != 2 && (type == 0 || type == 1);
            boolean bl = skipLegacyTypes = ViewRootImpl.sNewInsetsMode == 0 && (type == 0 || type == 1 || type == 13);
            if (skipSystemBars || skipLegacyTypes || skipNonImeInImeMode) {
                typeVisibilityMap[WindowInsets.Type.indexOf((int)InsetsState.toPublicType((int)type))] = source.isVisible();
                continue;
            }
            this.processSource(source, relativeFrame, false, typeInsetsMap, typeSideMap, typeVisibilityMap);
            if (source.getType() == 13) continue;
            InsetsSource insetsSource = ignoringVisibilitySource = ignoringVisibilityState != null ? ignoringVisibilityState.getSource(type) : source;
            if (ignoringVisibilitySource == null) continue;
            this.processSource(ignoringVisibilitySource, relativeFrameMax, true, typeMaxInsetsMap, null, null);
        }
        int softInputAdjustMode = legacySoftInputMode & 0xF0;
        int compatInsetsTypes = WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout();
        if (softInputAdjustMode == 16) {
            compatInsetsTypes |= WindowInsets.Type.ime();
        }
        if ((legacyWindowFlags & 0x400) != 0) {
            compatInsetsTypes &= ~WindowInsets.Type.statusBars();
        }
        return new WindowInsets(typeInsetsMap, typeMaxInsetsMap, typeVisibilityMap, isScreenRound, alwaysConsumeSystemBars, cutout, compatInsetsTypes, ViewRootImpl.sNewInsetsMode == 2 && (legacySystemUiFlags & 0x100) != 0);
    }

    public Rect calculateVisibleInsets(Rect frame, int softInputMode) {
        Insets insets = Insets.NONE;
        for (int type = 0; type <= 15; ++type) {
            int publicType;
            InsetsSource source = this.mSources[type];
            if (source == null || ViewRootImpl.sNewInsetsMode != 2 && type != 13 || !WindowInsets.Type.isVisibleInsetsType(publicType = InsetsState.toPublicType(type), softInputMode)) continue;
            insets = Insets.max(source.calculateVisibleInsets(frame), insets);
        }
        return insets.toRect();
    }

    public int calculateUncontrollableInsetsFromFrame(Rect frame) {
        int blocked = 0;
        for (int type = 0; type <= 15; ++type) {
            InsetsSource source = this.mSources[type];
            if (source == null || this.canControlSide(frame, this.getInsetSide(source.calculateInsets(frame, true)))) continue;
            blocked |= InsetsState.toPublicType(type);
        }
        return blocked;
    }

    private boolean canControlSide(Rect frame, int side) {
        switch (side) {
            case 0: 
            case 2: {
                return frame.left == this.mDisplayFrame.left && frame.right == this.mDisplayFrame.right;
            }
            case 1: 
            case 3: {
                return frame.top == this.mDisplayFrame.top && frame.bottom == this.mDisplayFrame.bottom;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void processSource(InsetsSource source, Rect relativeFrame, boolean ignoreVisibility, Insets[] typeInsetsMap, SparseIntArray typeSideMap, boolean[] typeVisibilityMap) {
        Insets insets = source.calculateInsets(relativeFrame, ignoreVisibility);
        int type = InsetsState.toPublicType(source.getType());
        this.processSourceAsPublicType(source, typeInsetsMap, typeSideMap, typeVisibilityMap, insets, type);
        if (type == 32) {
            this.processSourceAsPublicType(source, typeInsetsMap, typeSideMap, typeVisibilityMap, insets, 16);
        }
    }

    private void processSourceAsPublicType(InsetsSource source, Insets[] typeInsetsMap, SparseIntArray typeSideMap, boolean[] typeVisibilityMap, Insets insets, int type) {
        int insetSide;
        int index = WindowInsets.Type.indexOf(type);
        Insets existing = typeInsetsMap[index];
        typeInsetsMap[index] = existing == null ? insets : Insets.max(existing, insets);
        if (typeVisibilityMap != null) {
            typeVisibilityMap[index] = source.isVisible();
        }
        if (typeSideMap != null && (insetSide = this.getInsetSide(insets)) != 5) {
            typeSideMap.put(source.getType(), insetSide);
        }
    }

    private int getInsetSide(Insets insets) {
        if (Insets.NONE.equals(insets)) {
            return 4;
        }
        if (insets.left != 0) {
            return 0;
        }
        if (insets.top != 0) {
            return 1;
        }
        if (insets.right != 0) {
            return 2;
        }
        if (insets.bottom != 0) {
            return 3;
        }
        return 5;
    }

    public InsetsSource getSource(int type) {
        InsetsSource source = this.mSources[type];
        if (source != null) {
            return source;
        }
        this.mSources[type] = source = new InsetsSource(type);
        return source;
    }

    public InsetsSource peekSource(int type) {
        return this.mSources[type];
    }

    public boolean hasSources() {
        for (int i = 0; i < 16; ++i) {
            if (this.mSources[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean getSourceOrDefaultVisibility(int type) {
        InsetsSource source = this.mSources[type];
        return source != null ? source.isVisible() : InsetsState.getDefaultVisibility(type);
    }

    public void setDisplayFrame(Rect frame) {
        this.mDisplayFrame.set(frame);
    }

    public Rect getDisplayFrame() {
        return this.mDisplayFrame;
    }

    public void removeSource(int type) {
        this.mSources[type] = null;
    }

    public void setSourceVisible(int type, boolean visible) {
        InsetsSource source = this.mSources[type];
        if (source != null) {
            source.setVisible(visible);
        }
    }

    public void set(InsetsState other) {
        this.set(other, false);
    }

    public void set(InsetsState other, boolean copySources) {
        this.mDisplayFrame.set(other.mDisplayFrame);
        if (copySources) {
            for (int i = 0; i < 16; ++i) {
                InsetsSource source = other.mSources[i];
                this.mSources[i] = source != null ? new InsetsSource(source) : null;
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                this.mSources[i] = other.mSources[i];
            }
        }
    }

    public void addSource(InsetsSource source) {
        this.mSources[source.getType()] = source;
    }

    public static ArraySet<Integer> toInternalType(int types) {
        ArraySet<Integer> result = new ArraySet<Integer>();
        if ((types & 1) != 0) {
            result.add(0);
        }
        if ((types & 2) != 0) {
            result.add(1);
        }
        if ((types & 4) != 0) {
            result.add(2);
        }
        if ((types & 0x80) != 0) {
            result.add(9);
            result.add(10);
            result.add(11);
            result.add(12);
        }
        if ((types & 8) != 0) {
            result.add(13);
        }
        return result;
    }

    public static int toPublicType(int type) {
        switch (type) {
            case 0: 
            case 14: {
                return 1;
            }
            case 1: 
            case 15: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 13: {
                return 8;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: 
            case 6: {
                return 16;
            }
            case 7: 
            case 8: {
                return 64;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static boolean getDefaultVisibility(int type) {
        return type != 13;
    }

    public static boolean containsType(int[] types, int type) {
        if (types == null) {
            return false;
        }
        for (int t : types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "InsetsState");
        for (int i = 0; i < 16; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            source.dump(prefix + "  ", pw);
        }
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "ITYPE_STATUS_BAR";
            }
            case 1: {
                return "ITYPE_NAVIGATION_BAR";
            }
            case 2: {
                return "ITYPE_CAPTION_BAR";
            }
            case 3: {
                return "ITYPE_TOP_GESTURES";
            }
            case 4: {
                return "ITYPE_BOTTOM_GESTURES";
            }
            case 5: {
                return "ITYPE_LEFT_GESTURES";
            }
            case 6: {
                return "ITYPE_RIGHT_GESTURES";
            }
            case 7: {
                return "ITYPE_TOP_TAPPABLE_ELEMENT";
            }
            case 8: {
                return "ITYPE_BOTTOM_TAPPABLE_ELEMENT";
            }
            case 9: {
                return "ITYPE_LEFT_DISPLAY_CUTOUT";
            }
            case 10: {
                return "ITYPE_TOP_DISPLAY_CUTOUT";
            }
            case 11: {
                return "ITYPE_RIGHT_DISPLAY_CUTOUT";
            }
            case 12: {
                return "ITYPE_BOTTOM_DISPLAY_CUTOUT";
            }
            case 13: {
                return "ITYPE_IME";
            }
            case 14: {
                return "ITYPE_CLIMATE_BAR";
            }
            case 15: {
                return "ITYPE_EXTRA_NAVIGATION_BAR";
            }
        }
        return "ITYPE_UNKNOWN_" + type;
    }

    public boolean equals(Object o) {
        return this.equals(o, false, false);
    }

    @VisibleForTesting
    public boolean equals(Object o, boolean excludingCaptionInsets, boolean excludeInvisibleImeFrames) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsState state = (InsetsState)o;
        if (!this.mDisplayFrame.equals(state.mDisplayFrame)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (excludingCaptionInsets && i == 2) continue;
            InsetsSource source = this.mSources[i];
            InsetsSource otherSource = state.mSources[i];
            if (source == null && otherSource == null) continue;
            if (source != null && otherSource == null || source == null && otherSource != null) {
                return false;
            }
            if (otherSource.equals(source, excludeInvisibleImeFrames)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mDisplayFrame, Arrays.hashCode(this.mSources));
    }

    public InsetsState(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mDisplayFrame, flags);
        dest.writeParcelableArray(this.mSources, 0);
    }

    public void readFromParcel(Parcel in) {
        this.mDisplayFrame.set((Rect)in.readParcelable(null));
        this.mSources = (InsetsSource[])in.readParcelableArray(null, InsetsSource.class);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < 16; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            joiner.add(source.toString());
        }
        return "InsetsState: {mDisplayFrame=" + this.mDisplayFrame + ", mSources= { " + joiner + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsSide {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsType {
    }
}

