/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.Pin;
import android.security.net.config.PinSet;
import android.security.net.config.TrustAnchor;
import android.security.net.config.TrustedCertificateStoreAdapter;
import android.util.ArrayMap;
import com.android.org.conscrypt.ConscryptCertStore;
import com.android.org.conscrypt.TrustManagerImpl;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

public class NetworkSecurityTrustManager
extends X509ExtendedTrustManager {
    private final TrustManagerImpl mDelegate;
    private final NetworkSecurityConfig mNetworkSecurityConfig;
    private final Object mIssuersLock = new Object();
    private X509Certificate[] mIssuers;

    public NetworkSecurityTrustManager(NetworkSecurityConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.mNetworkSecurityConfig = config;
        try {
            TrustedCertificateStoreAdapter certStore = new TrustedCertificateStoreAdapter(config);
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(null);
            this.mDelegate = new TrustManagerImpl(store, null, (ConscryptCertStore)certStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.mDelegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        this.mDelegate.checkClientTrusted(certs, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        this.mDelegate.checkClientTrusted(certs, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.checkServerTrusted(certs, authType, (String)null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        List trustedChain = this.mDelegate.getTrustedChainForServer(certs, authType, socket);
        this.checkPins(trustedChain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        List trustedChain = this.mDelegate.getTrustedChainForServer(certs, authType, engine);
        this.checkPins(trustedChain);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] certs, String authType, String host) throws CertificateException {
        List trustedChain = this.mDelegate.checkServerTrusted(certs, authType, host);
        this.checkPins(trustedChain);
        return trustedChain;
    }

    private void checkPins(List<X509Certificate> chain) throws CertificateException {
        PinSet pinSet = this.mNetworkSecurityConfig.getPins();
        if (pinSet.pins.isEmpty() || System_Delegate.currentTimeMillis() > pinSet.expirationTime || !this.isPinningEnforced(chain)) {
            return;
        }
        Set<String> pinAlgorithms = pinSet.getPinAlgorithms();
        ArrayMap<String, MessageDigest> digestMap = new ArrayMap<String, MessageDigest>(pinAlgorithms.size());
        for (int i = chain.size() - 1; i >= 0; --i) {
            X509Certificate cert = chain.get(i);
            byte[] encodedSPKI = cert.getPublicKey().getEncoded();
            for (String algorithm : pinAlgorithms) {
                MessageDigest md = (MessageDigest)digestMap.get(algorithm);
                if (md == null) {
                    try {
                        md = MessageDigest.getInstance(algorithm);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    digestMap.put(algorithm, md);
                }
                if (!pinSet.pins.contains(new Pin(algorithm, md.digest(encodedSPKI)))) continue;
                return;
            }
        }
        throw new CertificateException("Pin verification failed");
    }

    private boolean isPinningEnforced(List<X509Certificate> chain) throws CertificateException {
        if (chain.isEmpty()) {
            return false;
        }
        X509Certificate anchorCert = chain.get(chain.size() - 1);
        TrustAnchor chainAnchor = this.mNetworkSecurityConfig.findTrustAnchorBySubjectAndPublicKey(anchorCert);
        if (chainAnchor == null) {
            throw new CertificateException("Trusted chain does not end in a TrustAnchor");
        }
        return !chainAnchor.overridesPins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getAcceptedIssuers() {
        Object object = this.mIssuersLock;
        synchronized (object) {
            if (this.mIssuers == null) {
                Set<TrustAnchor> anchors = this.mNetworkSecurityConfig.getTrustAnchors();
                X509Certificate[] issuers = new X509Certificate[anchors.size()];
                int i = 0;
                for (TrustAnchor anchor : anchors) {
                    issuers[i++] = anchor.certificate;
                }
                this.mIssuers = issuers;
            }
            return (X509Certificate[])this.mIssuers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTrustStorageUpdate() {
        Object object = this.mIssuersLock;
        synchronized (object) {
            this.mIssuers = null;
            this.mDelegate.handleTrustStorageUpdate();
        }
    }
}

