/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class FileObserver {
    public static final int ACCESS = 1;
    public static final int MODIFY = 2;
    public static final int ATTRIB = 4;
    public static final int CLOSE_WRITE = 8;
    public static final int CLOSE_NOWRITE = 16;
    public static final int OPEN = 32;
    public static final int MOVED_FROM = 64;
    public static final int MOVED_TO = 128;
    public static final int CREATE = 256;
    public static final int DELETE = 512;
    public static final int DELETE_SELF = 1024;
    public static final int MOVE_SELF = 2048;
    public static final int ALL_EVENTS = 4095;
    private static final String LOG_TAG = "FileObserver";
    @UnsupportedAppUsage
    private static ObserverThread s_observerThread = new ObserverThread();
    private final List<File> mFiles;
    private int[] mDescriptors;
    private final int mMask;

    @Deprecated
    public FileObserver(String path) {
        this(new File(path));
    }

    public FileObserver(File file) {
        this(Arrays.asList(file));
    }

    public FileObserver(List<File> files) {
        this(files, 4095);
    }

    @Deprecated
    public FileObserver(String path, int mask) {
        this(new File(path), mask);
    }

    public FileObserver(File file, int mask) {
        this(Arrays.asList(file), mask);
    }

    public FileObserver(List<File> files, int mask) {
        this.mFiles = files;
        this.mMask = mask;
    }

    protected void finalize() {
        this.stopWatching();
    }

    public void startWatching() {
        if (this.mDescriptors == null) {
            this.mDescriptors = s_observerThread.startWatching(this.mFiles, this.mMask, this);
        }
    }

    public void stopWatching() {
        if (this.mDescriptors != null) {
            s_observerThread.stopWatching(this.mDescriptors);
            this.mDescriptors = null;
        }
    }

    public abstract void onEvent(int var1, String var2);

    static {
        s_observerThread.start();
    }

    private static class ObserverThread
    extends Thread {
        private HashMap<Integer, WeakReference> m_observers = new HashMap();
        private int m_fd = this.init();

        public ObserverThread() {
            super(FileObserver.LOG_TAG);
        }

        @Override
        public void run() {
            this.observe(this.m_fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] startWatching(List<File> files, int mask, FileObserver observer) {
            int count = files.size();
            String[] paths = new String[count];
            for (int i = 0; i < count; ++i) {
                paths[i] = files.get(i).getAbsolutePath();
            }
            int[] wfds = new int[count];
            Arrays.fill(wfds, -1);
            this.startWatching(this.m_fd, paths, mask, wfds);
            WeakReference<FileObserver> fileObserverWeakReference = new WeakReference<FileObserver>(observer);
            HashMap<Integer, WeakReference> hashMap = this.m_observers;
            synchronized (hashMap) {
                for (int wfd : wfds) {
                    if (wfd < 0) continue;
                    this.m_observers.put(wfd, fileObserverWeakReference);
                }
            }
            return wfds;
        }

        public void stopWatching(int[] descriptors) {
            this.stopWatching(this.m_fd, descriptors);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnsupportedAppUsage
        public void onEvent(int wfd, int mask, String path) {
            FileObserver observer = null;
            HashMap<Integer, WeakReference> hashMap = this.m_observers;
            synchronized (hashMap) {
                WeakReference weak = this.m_observers.get(wfd);
                if (weak != null && (observer = (FileObserver)weak.get()) == null) {
                    this.m_observers.remove(wfd);
                }
            }
            if (observer != null) {
                try {
                    observer.onEvent(mask, path);
                }
                catch (Throwable throwable) {
                    Log.wtf(FileObserver.LOG_TAG, "Unhandled exception in FileObserver " + observer, throwable);
                }
            }
        }

        private int init() {
            return OverrideMethod.invokeI("android.os.FileObserver$ObserverThread#init()I", true, this);
        }

        private void observe(int n) {
            OverrideMethod.invokeV("android.os.FileObserver$ObserverThread#observe(I)V", true, this);
        }

        private void startWatching(int n, String[] stringArray, int n2, int[] nArray) {
            OverrideMethod.invokeV("android.os.FileObserver$ObserverThread#startWatching(I[Ljava/lang/String;I[I)V", true, this);
        }

        private void stopWatching(int n, int[] nArray) {
            OverrideMethod.invokeV("android.os.FileObserver$ObserverThread#stopWatching(I[I)V", true, this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyEventType {
    }
}

