/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.app.ActivityThread;
import android.content.Intent;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingPackageImpl;
import android.content.pm.parsing.ParsingPackageRead;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedActivity;
import android.content.pm.parsing.component.ParsedActivityUtils;
import android.content.pm.parsing.component.ParsedAttribution;
import android.content.pm.parsing.component.ParsedAttributionUtils;
import android.content.pm.parsing.component.ParsedInstrumentation;
import android.content.pm.parsing.component.ParsedInstrumentationUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedIntentInfoUtils;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.content.pm.parsing.component.ParsedPermission;
import android.content.pm.parsing.component.ParsedPermissionGroup;
import android.content.pm.parsing.component.ParsedPermissionUtils;
import android.content.pm.parsing.component.ParsedProcess;
import android.content.pm.parsing.component.ParsedProcessUtils;
import android.content.pm.parsing.component.ParsedProvider;
import android.content.pm.parsing.component.ParsedProviderUtils;
import android.content.pm.parsing.component.ParsedService;
import android.content.pm.parsing.component.ParsedServiceUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.parsing.result.ParseTypeImpl;
import android.content.pm.permission.SplitPermissionInfoParcelable;
import android.content.pm.split.DefaultSplitAssetLoader;
import android.content.pm.split.SplitAssetDependencyLoader;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.Trace;
import android.os._Original_Build;
import android.os.ext.SdkExtensions;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.R;
import com.android.internal.os.ClassLoaderFactory;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

public class ParsingPackageUtils {
    public static final String TAG = "PackageParsing";
    private boolean mOnlyCoreApps;
    private String[] mSeparateProcesses;
    private DisplayMetrics mDisplayMetrics;
    private Callback mCallback;

    public static ParseResult<ParsingPackage> parseDefaultOneTime(File file, int parseFlags, boolean collectCertificates) {
        ParseInput input = ParseTypeImpl.forDefaultParsing().reset();
        return ParsingPackageUtils.parseDefault(input, file, parseFlags, collectCertificates);
    }

    public static ParseResult<ParsingPackage> parseDefault(ParseInput input, File file, int parseFlags, boolean collectCertificates) {
        ParseResult<ParsingPackage> result;
        ParsingPackageUtils parser = new ParsingPackageUtils(false, null, null, new Callback(){

            @Override
            public boolean hasFeature(String feature) {
                return false;
            }

            @Override
            public ParsingPackage startParsingPackage(String packageName, String baseCodePath, String codePath, TypedArray manifestArray, boolean isCoreApp) {
                return new ParsingPackageImpl(packageName, baseCodePath, codePath, manifestArray);
            }
        });
        try {
            result = parser.parsePackage(input, file, parseFlags);
            if (result.isError()) {
                return result;
            }
        }
        catch (PackageParser.PackageParserException e) {
            return input.error(-102, "Error parsing package", e);
        }
        try {
            ParsingPackage pkg = result.getResult();
            if (collectCertificates) {
                pkg.setSigningDetails(ParsingPackageUtils.getSigningDetails(pkg, false));
            }
            return input.success(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            return input.error(-102, "Error collecting package certificates", e);
        }
    }

    public ParsingPackageUtils(boolean onlyCoreApps, String[] separateProcesses, DisplayMetrics displayMetrics, Callback callback) {
        this.mOnlyCoreApps = onlyCoreApps;
        this.mSeparateProcesses = separateProcesses;
        this.mDisplayMetrics = displayMetrics;
        this.mCallback = callback;
    }

    public ParseResult<ParsingPackage> parsePackage(ParseInput input, File packageFile, int flags) throws PackageParser.PackageParserException {
        if (packageFile.isDirectory()) {
            return this.parseClusterPackage(input, packageFile, flags);
        }
        return this.parseMonolithicPackage(input, packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseClusterPackage(ParseInput input, File packageDir, int flags) {
        SplitAssetLoader assetLoader;
        ParseResult<PackageParser.PackageLite> liteResult = ApkLiteParseUtils.parseClusterPackageLite(input, packageDir, 0);
        if (liteResult.isError()) {
            return input.error(liteResult);
        }
        PackageParser.PackageLite lite = liteResult.getResult();
        if (this.mOnlyCoreApps && !lite.coreApp) {
            return input.error(-123, "Not a coreApp: " + packageDir);
        }
        SparseArray<int[]> splitDependencies = null;
        if (lite.isolatedSplits && !ArrayUtils.isEmpty(lite.splitNames)) {
            try {
                splitDependencies = SplitAssetDependencyLoader.createDependenciesFromPackage(lite);
                assetLoader = new SplitAssetDependencyLoader(lite, splitDependencies, flags);
            }
            catch (SplitDependencyLoader.IllegalDependencyException e) {
                return input.error(-101, e.getMessage());
            }
        } else {
            assetLoader = new DefaultSplitAssetLoader(lite, flags);
        }
        try {
            AssetManager assets = assetLoader.getBaseAssetManager();
            File baseApk = new File(lite.baseCodePath);
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, baseApk, lite.codePath, assets, flags);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result);
                return parseResult;
            }
            ParsingPackage pkg = result.getResult();
            if (!ArrayUtils.isEmpty(lite.splitNames)) {
                pkg.asSplit(lite.splitNames, lite.splitCodePaths, lite.splitRevisionCodes, splitDependencies);
                int num = lite.splitNames.length;
                for (int i = 0; i < num; ++i) {
                    AssetManager splitAssets = assetLoader.getSplitAssetManager(i);
                    this.parseSplitApk(input, pkg, i, splitAssets, flags);
                }
            }
            pkg.setUse32BitAbi(lite.use32bitAbi);
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        catch (PackageParser.PackageParserException e) {
            ParseResult<ParsingPackage> parseResult = input.error(-102, "Failed to load assets: " + lite.baseCodePath, e);
            return parseResult;
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseMonolithicPackage(ParseInput input, File apkFile, int flags) throws PackageParser.PackageParserException {
        ParseResult<PackageParser.PackageLite> liteResult = ApkLiteParseUtils.parseMonolithicPackageLite(input, apkFile, flags);
        if (liteResult.isError()) {
            return input.error(liteResult);
        }
        PackageParser.PackageLite lite = liteResult.getResult();
        if (this.mOnlyCoreApps && !lite.coreApp) {
            return input.error(-123, "Not a coreApp: " + apkFile);
        }
        DefaultSplitAssetLoader assetLoader = new DefaultSplitAssetLoader(lite, flags);
        try {
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, apkFile, apkFile.getCanonicalPath(), assetLoader.getBaseAssetManager(), flags);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result);
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(result.getResult().setUse32BitAbi(lite.use32bitAbi));
            return parseResult;
        }
        catch (IOException e) {
            ParseResult<ParsingPackage> parseResult = input.error(-102, "Failed to get path: " + apkFile, e);
            return parseResult;
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParseResult<ParsingPackage> parseBaseApk(ParseInput input, File apkFile, String codePath, AssetManager assets, int flags) {
        int cookie;
        String apkPath = apkFile.getAbsolutePath();
        String volumeUuid = null;
        if (apkPath.startsWith("/mnt/expand/")) {
            int end = apkPath.indexOf(47, "/mnt/expand/".length());
            volumeUuid = apkPath.substring("/mnt/expand/".length(), end);
        }
        if ((cookie = assets.findCookieForPath(apkPath)) == 0) {
            return input.error(-101, "Failed adding asset path: " + apkPath);
        }
        try (XmlResourceParser parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");){
            ParseResult<?> deferResult;
            Resources res = new Resources(assets, this.mDisplayMetrics, null);
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, apkPath, codePath, res, parser, flags);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result.getErrorCode(), apkPath + " (at " + parser.getPositionDescription() + "): " + result.getErrorMessage());
                return parseResult;
            }
            ParsingPackage pkg = result.getResult();
            if (assets.containsAllocatedTable() && (deferResult = input.deferError("Targeting R+ (version 30 and above) requires the resources.arsc of installed APKs to be stored uncompressed and aligned on a 4-byte boundary", 132742131L)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(-124, deferResult.getErrorMessage());
                return parseResult;
            }
            ApkAssets apkAssets = assets.getApkAssets()[0];
            if (apkAssets.definesOverlayable()) {
                SparseArray<String> packageNames = assets.getAssignedPackageIdentifiers();
                int size = packageNames.size();
                for (int index = 0; index < size; ++index) {
                    String packageName = packageNames.get(index);
                    Map<String, String> overlayableToActor = assets.getOverlayableMap(packageName);
                    if (overlayableToActor == null || overlayableToActor.isEmpty()) continue;
                    for (String overlayable : overlayableToActor.keySet()) {
                        pkg.addOverlayable(overlayable, overlayableToActor.get(overlayable));
                    }
                }
            }
            pkg.setVolumeUuid(volumeUuid);
            if ((flags & 0x20) != 0) {
                pkg.setSigningDetails(ParsingPackageUtils.getSigningDetails(pkg, false));
            } else {
                pkg.setSigningDetails(PackageParser.SigningDetails.UNKNOWN);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        catch (Exception e) {
            return input.error(-102, "Failed to read manifest from " + apkPath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParseResult<ParsingPackage> parseSplitApk(ParseInput input, ParsingPackage pkg, int splitIndex, AssetManager assets, int flags) {
        String apkPath = pkg.getSplitCodePaths()[splitIndex];
        int cookie = assets.findCookieForPath(apkPath);
        if (cookie == 0) {
            return input.error(-101, "Failed adding asset path: " + apkPath);
        }
        try (XmlResourceParser parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");){
            Resources res = new Resources(assets, this.mDisplayMetrics, null);
            ParseResult<ParsingPackage> parseResult = this.parseSplitApk(input, pkg, res, parser, flags, splitIndex);
            if (parseResult.isError()) {
                ParseResult<ParsingPackage> parseResult2 = input.error(parseResult.getErrorCode(), apkPath + " (at " + parser.getPositionDescription() + "): " + parseResult.getErrorMessage());
                return parseResult2;
            }
            ParseResult<ParsingPackage> parseResult3 = parseResult;
            return parseResult3;
        }
        catch (Exception e) {
            return input.error(-102, "Failed to read manifest from " + apkPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseBaseApk(ParseInput input, String apkPath, String codePath, Resources res, XmlResourceParser parser, int flags) throws XmlPullParserException, IOException, PackageParser.PackageParserException {
        ParseResult<Pair<String, String>> packageSplitResult = ApkLiteParseUtils.parsePackageSplitNames(input, parser, parser);
        if (packageSplitResult.isError()) {
            return input.error(packageSplitResult);
        }
        Pair<String, String> packageSplit = packageSplitResult.getResult();
        String pkgName = (String)packageSplit.first;
        String splitName = (String)packageSplit.second;
        if (!TextUtils.isEmpty(splitName)) {
            return input.error(-106, "Expected base APK, but found split " + splitName);
        }
        TypedArray manifestArray = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        try {
            boolean isCoreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
            ParsingPackage pkg = this.mCallback.startParsingPackage(pkgName, apkPath, codePath, manifestArray, isCoreApp);
            ParseResult<ParsingPackage> result = this.parseBaseApkTags(input, pkg, manifestArray, res, parser, flags);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = result;
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            manifestArray.recycle();
        }
    }

    private ParseResult<ParsingPackage> parseSplitApk(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex) throws XmlPullParserException, IOException, PackageParser.PackageParserException {
        ParseResult<?> deferResult;
        int type;
        XmlResourceParser attrs = parser;
        PackageParser.parsePackageSplitNames(parser, attrs);
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1) {
            ParseResult<Object> result;
            if (outerDepth + 1 < parser.getDepth() || type != 2) continue;
            String tagName = parser.getName();
            if ("application".equals(tagName)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    result = input.success(null);
                } else {
                    foundApp = true;
                    result = this.parseSplitApplication(input, pkg, res, parser, flags, splitIndex);
                }
            } else {
                result = ParsingUtils.unknownTag("<manifest>", pkg, parser, input);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!foundApp && (deferResult = input.deferError("<manifest> does not contain an <application>", 150776642L)).isError()) {
            return input.error(deferResult);
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseSplitApplication(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex) throws XmlPullParserException, IOException {
        int type;
        block26: {
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
            try {
                pkg.setSplitHasCode(splitIndex, sa.getBoolean(7, true));
                String classLoaderName = sa.getString(46);
                if (classLoaderName == null || ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
                    pkg.setSplitClassLoaderName(splitIndex, classLoaderName);
                    break block26;
                }
                ParseResult<ParsingPackage> parseResult = input.error("Invalid class loader name: " + classLoaderName);
                return parseResult;
            }
            finally {
                sa.recycle();
            }
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedMainComponent> result;
            if (type != 2) continue;
            ParsedMainComponent mainComponent = null;
            String tagName = parser.getName();
            boolean isActivity = false;
            switch (tagName) {
                case "activity": {
                    isActivity = true;
                }
                case "receiver": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityOrReceiver(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        if (isActivity) {
                            pkg.addActivity(activity);
                        } else {
                            pkg.addReceiver(activity);
                        }
                        mainComponent = activity;
                    }
                    result = activityResult;
                    break;
                }
                case "service": {
                    ParseResult<ParsedService> serviceResult = ParsedServiceUtils.parseService(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (serviceResult.isSuccess()) {
                        ParsedService service = serviceResult.getResult();
                        pkg.addService(service);
                        mainComponent = service;
                    }
                    result = serviceResult;
                    break;
                }
                case "provider": {
                    ParseResult<ParsedProvider> providerResult = ParsedProviderUtils.parseProvider(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (providerResult.isSuccess()) {
                        ParsedProvider provider = providerResult.getResult();
                        pkg.addProvider(provider);
                        mainComponent = provider;
                    }
                    result = providerResult;
                    break;
                }
                case "activity-alias": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityAlias(pkg, res, parser, PackageParser.sUseRoundIcon, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        pkg.addActivity(activity);
                        mainComponent = activity;
                    }
                    result = activityResult;
                    break;
                }
                default: {
                    result = this.parseSplitBaseAppChildTags(input, tagName, pkg, res, parser);
                }
            }
            if (result.isError()) {
                return input.error(result);
            }
            if (mainComponent == null || mainComponent.getSplitName() != null) continue;
            mainComponent.setSplitName(pkg.getSplitNames()[splitIndex]);
        }
        return input.success(pkg);
    }

    private ParseResult parseSplitBaseAppChildTags(ParseInput input, String tag, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        switch (tag) {
            case "meta-data": {
                ParseResult<Bundle> metaDataResult = ParsingPackageUtils.parseMetaData(pkg, res, parser, pkg.getMetaData(), input);
                if (metaDataResult.isSuccess()) {
                    pkg.setMetaData(metaDataResult.getResult());
                }
                return metaDataResult;
            }
            case "uses-static-library": {
                return ParsingPackageUtils.parseUsesStaticLibrary(input, pkg, res, parser);
            }
            case "uses-library": {
                return ParsingPackageUtils.parseUsesLibrary(input, pkg, res, parser);
            }
            case "uses-package": {
                return input.success(null);
            }
        }
        return ParsingUtils.unknownTag("<application>", pkg, parser, input);
    }

    private ParseResult<ParsingPackage> parseBaseApkTags(ParseInput input, ParsingPackage pkg, TypedArray sa, Resources res, XmlResourceParser parser, int flags) throws XmlPullParserException, IOException {
        ParseResult<?> deferResult;
        int type;
        ParseResult<ParsingPackage> sharedUserResult = ParsingPackageUtils.parseSharedUser(input, pkg, sa);
        if (sharedUserResult.isError()) {
            return sharedUserResult;
        }
        pkg.setInstallLocation(ParsingPackageUtils.anInteger(-1, 4, sa)).setTargetSandboxVersion(ParsingPackageUtils.anInteger(1, 7, sa)).setExternalStorage((flags & 8) != 0);
        boolean foundApp = false;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            if (type != 2) continue;
            String tagName = parser.getName();
            if ("application".equals(tagName)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    result = input.success(null);
                } else {
                    foundApp = true;
                    result = this.parseBaseApplication(input, pkg, res, parser, flags);
                }
            } else {
                result = this.parseBaseApkTag(tagName, input, pkg, res, parser, flags);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!foundApp && ArrayUtils.size(pkg.getInstrumentations()) == 0 && (deferResult = input.deferError("<manifest> does not contain an <application> or <instrumentation>", 150776642L)).isError()) {
            return input.error(deferResult);
        }
        if (!ParsedAttribution.isCombinationValid(pkg.getAttributions())) {
            return input.error(-101, "Combination <feature> tags are not valid");
        }
        ParsingPackageUtils.convertNewPermissions(pkg);
        ParsingPackageUtils.convertSplitPermissions(pkg);
        if (!(pkg.getTargetSdkVersion() >= 4 && (pkg.isSupportsSmallScreens() || pkg.isSupportsNormalScreens() || pkg.isSupportsLargeScreens() || pkg.isSupportsExtraLargeScreens() || pkg.isResizeable() || pkg.isAnyDensity()))) {
            ParsingPackageUtils.adjustPackageToBeUnresizeableAndUnpipable(pkg);
        }
        return input.success(pkg);
    }

    private ParseResult parseBaseApkTag(String tag, ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws IOException, XmlPullParserException {
        switch (tag) {
            case "overlay": {
                return ParsingPackageUtils.parseOverlay(input, pkg, res, parser);
            }
            case "key-sets": {
                return ParsingPackageUtils.parseKeySets(input, pkg, res, parser);
            }
            case "feature": 
            case "attribution": {
                return ParsingPackageUtils.parseAttribution(input, pkg, res, parser);
            }
            case "permission-group": {
                return ParsingPackageUtils.parsePermissionGroup(input, pkg, res, parser);
            }
            case "permission": {
                return ParsingPackageUtils.parsePermission(input, pkg, res, parser);
            }
            case "permission-tree": {
                return ParsingPackageUtils.parsePermissionTree(input, pkg, res, parser);
            }
            case "uses-permission": 
            case "uses-permission-sdk-m": 
            case "uses-permission-sdk-23": {
                return this.parseUsesPermission(input, pkg, res, parser);
            }
            case "uses-configuration": {
                return ParsingPackageUtils.parseUsesConfiguration(input, pkg, res, parser);
            }
            case "uses-feature": {
                return ParsingPackageUtils.parseUsesFeature(input, pkg, res, parser);
            }
            case "feature-group": {
                return ParsingPackageUtils.parseFeatureGroup(input, pkg, res, parser);
            }
            case "uses-sdk": {
                return ParsingPackageUtils.parseUsesSdk(input, pkg, res, parser);
            }
            case "supports-screens": {
                return ParsingPackageUtils.parseSupportScreens(input, pkg, res, parser);
            }
            case "protected-broadcast": {
                return ParsingPackageUtils.parseProtectedBroadcast(input, pkg, res, parser);
            }
            case "instrumentation": {
                return ParsingPackageUtils.parseInstrumentation(input, pkg, res, parser);
            }
            case "original-package": {
                return ParsingPackageUtils.parseOriginalPackage(input, pkg, res, parser);
            }
            case "adopt-permissions": {
                return ParsingPackageUtils.parseAdoptPermissions(input, pkg, res, parser);
            }
            case "uses-gl-texture": 
            case "compatible-screens": 
            case "supports-input": 
            case "eat-comment": {
                XmlUtils.skipCurrentTag(parser);
                return input.success(pkg);
            }
            case "restrict-update": {
                return ParsingPackageUtils.parseRestrictUpdateHash(flags, input, pkg, res, parser);
            }
            case "queries": {
                return ParsingPackageUtils.parseQueries(input, pkg, res, parser);
            }
        }
        return ParsingUtils.unknownTag("<manifest>", pkg, parser, input);
    }

    private static ParseResult<ParsingPackage> parseSharedUser(ParseInput input, ParsingPackage pkg, TypedArray sa) {
        ParseResult nameResult;
        String str = ParsingPackageUtils.nonConfigString(0, 0, sa);
        if (TextUtils.isEmpty(str)) {
            return input.success(pkg);
        }
        if (!"android".equals(pkg.getPackageName()) && (nameResult = ParsingPackageUtils.validateName(input, str, true, true)).isError()) {
            return input.error(-107, "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameResult.getErrorMessage());
        }
        return input.success(pkg.setSharedUserId(str.intern()).setSharedUserLabel(ParsingPackageUtils.resId(3, sa)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseKeySets(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        block22: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            switch (tagName = parser.getName()) {
                case "key-set": {
                    if (currentKeySet != null) {
                        return input.error("Improperly nested 'key-set' tag at " + parser.getPositionDescription());
                    }
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestKeySet);
                    try {
                        String keysetName = sa.getNonResourceString(0);
                        definedKeySets.put(keysetName, new ArraySet());
                        currentKeySet = keysetName;
                        currentKeySetDepth = parser.getDepth();
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                case "public-key": {
                    if (currentKeySet == null) {
                        return input.error("Improperly nested 'key-set' tag at " + parser.getPositionDescription());
                    }
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPublicKey);
                    try {
                        String publicKeyName = ParsingPackageUtils.nonResString(0, sa);
                        String encodedKey = ParsingPackageUtils.nonResString(1, sa);
                        if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                            ParseResult<ParsingPackage> parseResult = input.error("'public-key' " + publicKeyName + " must define a public-key value on first use at " + parser.getPositionDescription());
                            return parseResult;
                        }
                        if (encodedKey != null) {
                            PublicKey currentKey = PackageParser.parsePublicKey(encodedKey);
                            if (currentKey == null) {
                                Slog.w(TAG, "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                                improperKeySets.add(currentKeySet);
                                XmlUtils.skipCurrentTag(parser);
                                continue block22;
                            }
                            if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                                publicKeys.put(publicKeyName, currentKey);
                            } else {
                                ParseResult<ParsingPackage> parseResult = input.error("Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription());
                                return parseResult;
                            }
                        }
                        ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                        XmlUtils.skipCurrentTag(parser);
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                case "upgrade-key-set": {
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUpgradeKeySet);
                    try {
                        String name = sa.getNonResourceString(0);
                        upgradeKeySets.add(name);
                        XmlUtils.skipCurrentTag(parser);
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                default: {
                    ParseResult result = ParsingUtils.unknownTag("<key-sets>", pkg, parser, input);
                    if (!result.isError()) continue block22;
                    return input.error(result);
                }
            }
        }
        String packageName = pkg.getPackageName();
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            return input.error("Package" + packageName + " AndroidManifest.xml 'key-set' and 'public-key' names must be distinct.");
        }
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w(TAG, "Package" + packageName + " AndroidManifest.xml 'key-set' " + keySetName + " has no valid associated 'public-key'. Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w(TAG, "Package" + packageName + " AndroidManifest.xml 'key-set' " + keySetName + " contained improper 'public-key' tags. Not including in package's defined key-sets.");
                continue;
            }
            for (String s : (ArraySet)e.getValue()) {
                pkg.addKeySet(keySetName, (PublicKey)publicKeys.get(s));
            }
        }
        if (!pkg.getKeySetMapping().keySet().containsAll(upgradeKeySets)) {
            return input.error("Package" + packageName + " AndroidManifest.xml does not define all 'upgrade-key-set's .");
        }
        pkg.setUpgradeKeySets(upgradeKeySets);
        return input.success(pkg);
    }

    private static ParseResult<ParsingPackage> parseAttribution(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        ParseResult<ParsedAttribution> result = ParsedAttributionUtils.parseAttribution(res, parser, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addAttribution(result.getResult()));
    }

    private static ParseResult<ParsingPackage> parsePermissionGroup(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermissionGroup> result = ParsedPermissionUtils.parsePermissionGroup(pkg, res, parser, PackageParser.sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addPermissionGroup(result.getResult()));
    }

    private static ParseResult<ParsingPackage> parsePermission(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermission> result = ParsedPermissionUtils.parsePermission(pkg, res, parser, PackageParser.sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addPermission(result.getResult()));
    }

    private static ParseResult<ParsingPackage> parsePermissionTree(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermission> result = ParsedPermissionUtils.parsePermissionTree(pkg, res, parser, PackageParser.sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addPermission(result.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseUsesPermission(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesPermission);
        try {
            String name = sa.getNonResourceString(0);
            int maxSdkVersion = 0;
            TypedValue val = sa.peekValue(1);
            if (val != null && val.type >= 16 && val.type <= 31) {
                maxSdkVersion = val.data;
            }
            String requiredFeature = sa.getNonConfigurationString(2, 0);
            String requiredNotfeature = sa.getNonConfigurationString(3, 0);
            XmlUtils.skipCurrentTag(parser);
            ParseResult<ParsingPackage> success = input.success(pkg);
            if (name == null) {
                ParseResult<ParsingPackage> parseResult = success;
                return parseResult;
            }
            if (maxSdkVersion != 0 && maxSdkVersion < _Original_Build.VERSION.RESOURCES_SDK_INT) {
                ParseResult<ParsingPackage> parseResult = success;
                return parseResult;
            }
            if (requiredFeature != null && this.mCallback != null && !this.mCallback.hasFeature(requiredFeature)) {
                ParseResult<ParsingPackage> parseResult = success;
                return parseResult;
            }
            if (requiredNotfeature != null && this.mCallback != null && this.mCallback.hasFeature(requiredNotfeature)) {
                ParseResult<ParsingPackage> parseResult = success;
                return parseResult;
            }
            if (!pkg.getRequestedPermissions().contains(name)) {
                pkg.addRequestedPermission(name.intern());
            } else {
                Slog.w(TAG, "Ignoring duplicate uses-permissions/uses-permissions-sdk-m: " + name + " in package: " + pkg.getPackageName() + " at: " + parser.getPositionDescription());
            }
            ParseResult<ParsingPackage> parseResult = success;
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesConfiguration(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        ConfigurationInfo cPref = new ConfigurationInfo();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesConfiguration);
        try {
            cPref.reqTouchScreen = sa.getInt(0, 0);
            cPref.reqKeyboardType = sa.getInt(1, 0);
            if (sa.getBoolean(2, false)) {
                cPref.reqInputFeatures |= 1;
            }
            cPref.reqNavigation = sa.getInt(3, 0);
            if (sa.getBoolean(4, false)) {
                cPref.reqInputFeatures |= 2;
            }
            pkg.addConfigPreference(cPref);
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseUsesFeature(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        FeatureInfo fi = ParsingPackageUtils.parseFeatureInfo(res, parser);
        pkg.addReqFeature(fi);
        if (fi.name == null) {
            ConfigurationInfo cPref = new ConfigurationInfo();
            cPref.reqGlEsVersion = fi.reqGlEsVersion;
            pkg.addConfigPreference(cPref);
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureInfo parseFeatureInfo(Resources res, AttributeSet attrs) {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        try {
            fi.name = sa.getNonResourceString(0);
            fi.version = sa.getInt(3, 0);
            if (fi.name == null) {
                fi.reqGlEsVersion = sa.getInt(1, 0);
            }
            if (sa.getBoolean(2, true)) {
                fi.flags |= 1;
            }
            FeatureInfo featureInfo = fi;
            return featureInfo;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseFeatureGroup(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        int type;
        FeatureGroupInfo group = new FeatureGroupInfo();
        ArrayList<FeatureInfo> features = null;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            if (type != 2) continue;
            String innerTagName = parser.getName();
            if (innerTagName.equals("uses-feature")) {
                FeatureInfo featureInfo = ParsingPackageUtils.parseFeatureInfo(res, parser);
                featureInfo.flags |= 1;
                features = ArrayUtils.add(features, featureInfo);
                continue;
            }
            Slog.w(TAG, "Unknown element under <feature-group>: " + innerTagName + " at " + pkg.getBaseCodePath() + " " + parser.getPositionDescription());
        }
        if (features != null) {
            group.features = new FeatureInfo[features.size()];
            group.features = features.toArray(group.features);
        }
        pkg.addFeatureGroup(group);
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesSdk(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        if (PackageParser.SDK_VERSION > 0) {
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdk);
            try {
                int type;
                ParseResult<Integer> targetSdkVersionResult;
                int minVers = 1;
                String minCode = null;
                int targetVers = 0;
                String targetCode = null;
                TypedValue val = sa.peekValue(0);
                if (val != null) {
                    if (val.type == 3 && val.string != null) {
                        minCode = val.string.toString();
                    } else {
                        minVers = val.data;
                    }
                }
                if ((val = sa.peekValue(1)) != null) {
                    if (val.type == 3 && val.string != null) {
                        targetCode = val.string.toString();
                        if (minCode == null) {
                            minCode = targetCode;
                        }
                    } else {
                        targetVers = val.data;
                    }
                } else {
                    targetVers = minVers;
                    targetCode = minCode;
                }
                if ((targetSdkVersionResult = ParsingPackageUtils.computeTargetSdkVersion(targetVers, targetCode, PackageParser.SDK_CODENAMES, input)).isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(targetSdkVersionResult);
                    return parseResult;
                }
                int targetSdkVersion = targetSdkVersionResult.getResult();
                ParseResult<?> deferResult = input.enableDeferredError(pkg.getPackageName(), targetSdkVersion);
                if (deferResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(deferResult);
                    return parseResult;
                }
                ParseResult<Integer> minSdkVersionResult = ParsingPackageUtils.computeMinSdkVersion(minVers, minCode, PackageParser.SDK_VERSION, PackageParser.SDK_CODENAMES, input);
                if (minSdkVersionResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(minSdkVersionResult);
                    return parseResult;
                }
                int minSdkVersion = minSdkVersionResult.getResult();
                pkg.setMinSdkVersion(minSdkVersion).setTargetSdkVersion(targetSdkVersion);
                int innerDepth = parser.getDepth();
                SparseIntArray minExtensionVersions = null;
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    ParseResult<SparseIntArray> result;
                    if (type == 3 || type == 4) continue;
                    if (parser.getName().equals("extension-sdk")) {
                        if (minExtensionVersions == null) {
                            minExtensionVersions = new SparseIntArray();
                        }
                        result = ParsingPackageUtils.parseExtensionSdk(input, res, parser, minExtensionVersions);
                        XmlUtils.skipCurrentTag(parser);
                    } else {
                        result = ParsingUtils.unknownTag("<uses-sdk>", pkg, parser, input);
                    }
                    if (!result.isError()) continue;
                    ParseResult<ParsingPackage> parseResult = input.error(result);
                    return parseResult;
                }
                pkg.setMinExtensionVersions(ParsingPackageUtils.exactSizedCopyOfSparseArray(minExtensionVersions));
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    private static SparseIntArray exactSizedCopyOfSparseArray(SparseIntArray input) {
        if (input == null) {
            return null;
        }
        SparseIntArray output = new SparseIntArray(input.size());
        for (int i = 0; i < input.size(); ++i) {
            output.put(input.keyAt(i), input.valueAt(i));
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<SparseIntArray> parseExtensionSdk(ParseInput input, Resources res, XmlResourceParser parser, SparseIntArray minExtensionVersions) {
        int minVersion;
        int sdkVersion;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestExtensionSdk);
        try {
            sdkVersion = sa.getInt(0, -1);
            minVersion = sa.getInt(1, -1);
        }
        finally {
            sa.recycle();
        }
        if (sdkVersion < 0) {
            return input.error(-108, "<extension-sdk> must specify an sdkVersion >= 0");
        }
        if (minVersion < 0) {
            return input.error(-108, "<extension-sdk> must specify minExtensionVersion >= 0");
        }
        try {
            int version = SdkExtensions.getExtensionVersion(sdkVersion);
            if (version < minVersion) {
                return input.error(-12, "Package requires " + sdkVersion + " extension version " + minVersion + " which exceeds device version " + version);
            }
        }
        catch (RuntimeException e) {
            return input.error(-108, "Specified sdkVersion " + sdkVersion + " is not valid");
        }
        minExtensionVersions.put(sdkVersion, minVersion);
        return input.success(minExtensionVersions);
    }

    public static ParseResult<Integer> computeMinSdkVersion(int minVers, String minCode, int platformSdkVersion, String[] platformSdkCodenames, ParseInput input) {
        if (minCode == null) {
            if (minVers <= platformSdkVersion) {
                return input.success(minVers);
            }
            return input.error(-12, "Requires newer sdk version #" + minVers + " (current version is #" + platformSdkVersion + ")");
        }
        if (ParsingPackageUtils.matchTargetCode(platformSdkCodenames, minCode)) {
            return input.success(10000);
        }
        if (platformSdkCodenames.length > 0) {
            return input.error(-12, "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")");
        }
        return input.error(-12, "Requires development platform " + minCode + " but this is a release platform.");
    }

    public static ParseResult<Integer> computeTargetSdkVersion(int targetVers, String targetCode, String[] platformSdkCodenames, ParseInput input) {
        if (targetCode == null) {
            return input.success(targetVers);
        }
        if (ParsingPackageUtils.matchTargetCode(platformSdkCodenames, targetCode)) {
            return input.success(10000);
        }
        if (platformSdkCodenames.length > 0) {
            return input.error(-12, "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")");
        }
        return input.error(-12, "Requires development platform " + targetCode + " but this is a release platform.");
    }

    private static boolean matchTargetCode(String[] codeNames, String targetCode) {
        int targetCodeIdx = targetCode.indexOf(46);
        String targetCodeName = targetCodeIdx == -1 ? targetCode : targetCode.substring(0, targetCodeIdx);
        return ArrayUtils.contains(codeNames, targetCodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseRestrictUpdateHash(int flags, ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        if ((flags & 0x10) != 0) {
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestRestrictUpdate);
            try {
                String hash = sa.getNonConfigurationString(0, 0);
                if (hash != null) {
                    int hashLength = hash.length();
                    byte[] hashBytes = new byte[hashLength / 2];
                    for (int i = 0; i < hashLength; i += 2) {
                        hashBytes[i / 2] = (byte)((Character.digit(hash.charAt(i), 16) << 4) + Character.digit(hash.charAt(i + 1), 16));
                    }
                    pkg.setRestrictUpdateHash(hashBytes);
                } else {
                    pkg.setRestrictUpdateHash(null);
                }
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseQueries(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        int type;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            TypedArray sa;
            Object data;
            if (type != 2) continue;
            if (parser.getName().equals("intent")) {
                ParseResult<ParsedIntentInfo> result = ParsedIntentInfoUtils.parseIntentInfo(null, pkg, res, parser, true, true, input);
                if (result.isError()) {
                    return input.error(result);
                }
                ParsedIntentInfo intentInfo = result.getResult();
                data = null;
                String dataType = null;
                String host = null;
                int numActions = intentInfo.countActions();
                int numSchemes = intentInfo.countDataSchemes();
                int numTypes = intentInfo.countDataTypes();
                int numHosts = intentInfo.getHosts().length;
                if (numSchemes == 0 && numTypes == 0 && numActions == 0) {
                    return input.error("intent tags must contain either an action or data.");
                }
                if (numActions > 1) {
                    return input.error("intent tag may have at most one action.");
                }
                if (numTypes > 1) {
                    return input.error("intent tag may have at most one data type.");
                }
                if (numSchemes > 1) {
                    return input.error("intent tag may have at most one data scheme.");
                }
                if (numHosts > 1) {
                    return input.error("intent tag may have at most one data host.");
                }
                Intent intent = new Intent();
                int max = intentInfo.countCategories();
                for (int i = 0; i < max; ++i) {
                    intent.addCategory(intentInfo.getCategory(i));
                }
                if (numHosts == 1) {
                    host = intentInfo.getHosts()[0];
                }
                if (numSchemes == 1) {
                    data = new Uri.Builder().scheme(intentInfo.getDataScheme(0)).authority(host).path("/*").build();
                }
                if (numTypes == 1) {
                    dataType = intentInfo.getDataType(0);
                    if (!dataType.contains("/")) {
                        dataType = dataType + "/*";
                    }
                    if (data == null) {
                        data = new Uri.Builder().scheme("content").authority("*").path("/*").build();
                    }
                }
                intent.setDataAndType((Uri)data, dataType);
                if (numActions == 1) {
                    intent.setAction(intentInfo.getAction(0));
                }
                pkg.addQueriesIntent(intent);
                continue;
            }
            if (parser.getName().equals("package")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestQueriesPackage);
                String packageName = sa.getNonConfigurationString(0, 0);
                if (TextUtils.isEmpty(packageName)) {
                    return input.error("Package name is missing from package tag.");
                }
                pkg.addQueriesPackage(packageName.intern());
                continue;
            }
            if (!parser.getName().equals("provider")) continue;
            sa = res.obtainAttributes(parser, R.styleable.AndroidManifestQueriesProvider);
            try {
                String authorities = sa.getNonConfigurationString(0, 0);
                if (TextUtils.isEmpty(authorities)) {
                    data = input.error(-108, "Authority missing from provider tag.");
                    return data;
                }
                StringTokenizer authoritiesTokenizer = new StringTokenizer(authorities, ";");
                while (authoritiesTokenizer.hasMoreElements()) {
                    pkg.addQueriesProvider(authoritiesTokenizer.nextToken());
                }
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseBaseApplication(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws XmlPullParserException, IOException {
        int type;
        String pkgName = pkg.getPackageName();
        int targetSdk = pkg.getTargetSdkVersion();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        try {
            String pname;
            ParseResult<String> processNameResult;
            TypedValue labelValue;
            if (sa == null) {
                ParseResult<ParsingPackage> parseResult = input.error("<application> does not contain any attributes");
                return parseResult;
            }
            String name = sa.getNonConfigurationString(3, 0);
            if (name != null) {
                String packageName = pkg.getPackageName();
                String outInfoName = ParsingUtils.buildClassName(packageName, name);
                if (PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(outInfoName)) {
                    ParseResult<ParsingPackage> parseResult = input.error("<application> invalid android:name");
                    return parseResult;
                }
                if (outInfoName == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + packageName);
                    return parseResult;
                }
                pkg.setClassName(outInfoName);
            }
            if ((labelValue = sa.peekValue(1)) != null) {
                pkg.setLabelRes(labelValue.resourceId);
                if (labelValue.resourceId == 0) {
                    pkg.setNonLocalizedLabel(labelValue.coerceToString());
                }
            }
            this.parseBaseAppBasicFlags(pkg, sa);
            String manageSpaceActivity = ParsingPackageUtils.nonConfigString(1024, 4, sa);
            if (manageSpaceActivity != null) {
                String manageSpaceActivityName = ParsingUtils.buildClassName(pkgName, manageSpaceActivity);
                if (manageSpaceActivityName == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                    return parseResult;
                }
                pkg.setManageSpaceActivityName(manageSpaceActivityName);
            }
            if (pkg.isAllowBackup()) {
                String backupAgent = ParsingPackageUtils.nonConfigString(1024, 16, sa);
                if (backupAgent != null) {
                    String backupAgentName = ParsingUtils.buildClassName(pkgName, backupAgent);
                    if (backupAgentName == null) {
                        ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                        return parseResult;
                    }
                    pkg.setBackupAgentName(backupAgentName).setKillAfterRestore(ParsingPackageUtils.bool(true, 18, sa)).setRestoreAnyVersion(ParsingPackageUtils.bool(false, 21, sa)).setFullBackupOnly(ParsingPackageUtils.bool(false, 32, sa)).setBackupInForeground(ParsingPackageUtils.bool(false, 40, sa));
                }
                TypedValue v = sa.peekValue(35);
                int fullBackupContent = 0;
                if (v != null) {
                    fullBackupContent = v.resourceId;
                    if (v.resourceId == 0) {
                        fullBackupContent = v.data == 0 ? -1 : 0;
                    }
                    pkg.setFullBackupContent(fullBackupContent);
                }
            }
            if (sa.getBoolean(8, false)) {
                String requiredFeature = sa.getNonResourceString(45);
                pkg.setPersistent(requiredFeature == null || this.mCallback.hasFeature(requiredFeature));
            }
            pkg.setProfileableByShell(pkg.isProfileableByShell() || pkg.isDebuggable());
            if (sa.hasValueOrEmpty(37)) {
                pkg.setResizeableActivity(sa.getBoolean(37, true));
            } else {
                pkg.setResizeableActivityViaSdkVersion(targetSdk >= 24);
            }
            String taskAffinity = targetSdk >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
            ParseResult<String> taskAffinityResult = ComponentParseUtils.buildTaskAffinityName(pkgName, pkgName, taskAffinity, input);
            if (taskAffinityResult.isError()) {
                ParseResult<ParsingPackage> fullBackupContent = input.error(taskAffinityResult);
                return fullBackupContent;
            }
            pkg.setTaskAffinity(taskAffinityResult.getResult());
            String factory = sa.getNonResourceString(48);
            if (factory != null) {
                String appComponentFactory = ParsingUtils.buildClassName(pkgName, factory);
                if (appComponentFactory == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                    return parseResult;
                }
                pkg.setAppComponentFactory(appComponentFactory);
            }
            if ((processNameResult = ComponentParseUtils.buildProcessName(pkgName, null, pname = targetSdk >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11), flags, this.mSeparateProcesses, input)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(processNameResult);
                return parseResult;
            }
            String processName = processNameResult.getResult();
            pkg.setProcessName(processName);
            if (pkg.isCantSaveState() && processName != null && !processName.equals(pkgName)) {
                ParseResult<ParsingPackage> parseResult = input.error("cantSaveState applications can not use custom processes");
                return parseResult;
            }
            String classLoaderName = pkg.getClassLoaderName();
            if (classLoaderName != null && !ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
                ParseResult<ParsingPackage> parseResult = input.error("Invalid class loader name: " + classLoaderName);
                return parseResult;
            }
            pkg.setGwpAsanMode(sa.getInt(62, -1));
        }
        finally {
            sa.recycle();
        }
        boolean hasActivityOrder = false;
        boolean hasReceiverOrder = false;
        boolean hasServiceOrder = false;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedMainComponent> result;
            if (type != 2) continue;
            String tagName = parser.getName();
            boolean isActivity = false;
            switch (tagName) {
                case "activity": {
                    isActivity = true;
                }
                case "receiver": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityOrReceiver(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        if (isActivity) {
                            hasActivityOrder |= activity.getOrder() != 0;
                            pkg.addActivity(activity);
                        } else {
                            hasReceiverOrder |= activity.getOrder() != 0;
                            pkg.addReceiver(activity);
                        }
                    }
                    result = activityResult;
                    break;
                }
                case "service": {
                    ParseResult<ParsedService> serviceResult = ParsedServiceUtils.parseService(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (serviceResult.isSuccess()) {
                        ParsedService service = serviceResult.getResult();
                        hasServiceOrder |= service.getOrder() != 0;
                        pkg.addService(service);
                    }
                    result = serviceResult;
                    break;
                }
                case "provider": {
                    ParseResult<ParsedProvider> providerResult = ParsedProviderUtils.parseProvider(this.mSeparateProcesses, pkg, res, parser, flags, PackageParser.sUseRoundIcon, input);
                    if (providerResult.isSuccess()) {
                        pkg.addProvider(providerResult.getResult());
                    }
                    result = providerResult;
                    break;
                }
                case "activity-alias": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityAlias(pkg, res, parser, PackageParser.sUseRoundIcon, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        hasActivityOrder |= activity.getOrder() != 0;
                        pkg.addActivity(activity);
                    }
                    result = activityResult;
                    break;
                }
                default: {
                    result = this.parseBaseAppChildTag(input, tagName, pkg, res, parser, flags);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (TextUtils.isEmpty(pkg.getStaticSharedLibName())) {
            ParseResult<ParsedActivity> a = ParsingPackageUtils.generateAppDetailsHiddenActivity(input, pkg);
            if (a.isError()) {
                return input.error(a);
            }
            pkg.addActivity(a.getResult());
        }
        if (hasActivityOrder) {
            pkg.sortActivities();
        }
        if (hasReceiverOrder) {
            pkg.sortReceivers();
        }
        if (hasServiceOrder) {
            pkg.sortServices();
        }
        ParsingPackageUtils.setMaxAspectRatio(pkg);
        this.setMinAspectRatio(pkg);
        this.setSupportsSizeChanges(pkg);
        pkg.setHasDomainUrls(ParsingPackageUtils.hasDomainURLs(pkg));
        return input.success(pkg);
    }

    private void parseBaseAppBasicFlags(ParsingPackage pkg, TypedArray sa) {
        int targetSdk = pkg.getTargetSdkVersion();
        pkg.setAllowBackup(ParsingPackageUtils.bool(true, 17, sa)).setAllowClearUserData(ParsingPackageUtils.bool(true, 5, sa)).setAllowClearUserDataOnFailedRestore(ParsingPackageUtils.bool(true, 54, sa)).setAllowNativeHeapPointerTagging(ParsingPackageUtils.bool(true, 59, sa)).setEnabled(ParsingPackageUtils.bool(true, 9, sa)).setExtractNativeLibs(ParsingPackageUtils.bool(true, 34, sa)).setHasCode(ParsingPackageUtils.bool(true, 7, sa)).setAllowTaskReparenting(ParsingPackageUtils.bool(false, 14, sa)).setCantSaveState(ParsingPackageUtils.bool(false, 47, sa)).setCrossProfile(ParsingPackageUtils.bool(false, 58, sa)).setDebuggable(ParsingPackageUtils.bool(false, 10, sa)).setDefaultToDeviceProtectedStorage(ParsingPackageUtils.bool(false, 38, sa)).setDirectBootAware(ParsingPackageUtils.bool(false, 39, sa)).setForceQueryable(ParsingPackageUtils.bool(false, 57, sa)).setGame(ParsingPackageUtils.bool(false, 31, sa)).setHasFragileUserData(ParsingPackageUtils.bool(false, 50, sa)).setLargeHeap(ParsingPackageUtils.bool(false, 24, sa)).setMultiArch(ParsingPackageUtils.bool(false, 33, sa)).setPreserveLegacyExternalStorage(ParsingPackageUtils.bool(false, 61, sa)).setRequiredForAllUsers(ParsingPackageUtils.bool(false, 27, sa)).setSupportsRtl(ParsingPackageUtils.bool(false, 26, sa)).setTestOnly(ParsingPackageUtils.bool(false, 15, sa)).setUseEmbeddedDex(ParsingPackageUtils.bool(false, 53, sa)).setUsesNonSdkApi(ParsingPackageUtils.bool(false, 49, sa)).setVmSafeMode(ParsingPackageUtils.bool(false, 20, sa)).setAutoRevokePermissions(ParsingPackageUtils.anInt(60, sa)).setAllowAudioPlaybackCapture(ParsingPackageUtils.bool(targetSdk >= 29, 55, sa)).setBaseHardwareAccelerated(ParsingPackageUtils.bool(targetSdk >= 14, 23, sa)).setRequestLegacyExternalStorage(ParsingPackageUtils.bool(targetSdk < 29, 56, sa)).setUsesCleartextTraffic(ParsingPackageUtils.bool(targetSdk < 28, 36, sa)).setUiOptions(ParsingPackageUtils.anInt(25, sa)).setCategory(ParsingPackageUtils.anInt(-1, 43, sa)).setMaxAspectRatio(ParsingPackageUtils.aFloat(44, sa)).setMinAspectRatio(ParsingPackageUtils.aFloat(51, sa)).setBanner(ParsingPackageUtils.resId(30, sa)).setDescriptionRes(ParsingPackageUtils.resId(13, sa)).setIconRes(ParsingPackageUtils.resId(2, sa)).setLogo(ParsingPackageUtils.resId(22, sa)).setNetworkSecurityConfigRes(ParsingPackageUtils.resId(41, sa)).setRoundIconRes(ParsingPackageUtils.resId(42, sa)).setTheme(ParsingPackageUtils.resId(0, sa)).setClassLoaderName(ParsingPackageUtils.string(46, sa)).setRequiredAccountType(ParsingPackageUtils.string(29, sa)).setRestrictedAccountType(ParsingPackageUtils.string(28, sa)).setZygotePreloadName(ParsingPackageUtils.string(52, sa)).setPermission(ParsingPackageUtils.nonConfigString(0, 6, sa));
    }

    private ParseResult parseBaseAppChildTag(ParseInput input, String tag, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws IOException, XmlPullParserException {
        switch (tag) {
            case "meta-data": {
                ParseResult<Bundle> metaDataResult = ParsingPackageUtils.parseMetaData(pkg, res, parser, pkg.getMetaData(), input);
                if (metaDataResult.isSuccess()) {
                    pkg.setMetaData(metaDataResult.getResult());
                }
                return metaDataResult;
            }
            case "static-library": {
                return ParsingPackageUtils.parseStaticLibrary(pkg, res, parser, input);
            }
            case "library": {
                return ParsingPackageUtils.parseLibrary(pkg, res, parser, input);
            }
            case "uses-static-library": {
                return ParsingPackageUtils.parseUsesStaticLibrary(input, pkg, res, parser);
            }
            case "uses-library": {
                return ParsingPackageUtils.parseUsesLibrary(input, pkg, res, parser);
            }
            case "processes": {
                return ParsingPackageUtils.parseProcesses(input, pkg, res, parser, this.mSeparateProcesses, flags);
            }
            case "uses-package": {
                return input.success(null);
            }
            case "profileable": {
                return ParsingPackageUtils.parseProfileable(input, pkg, res, parser);
            }
        }
        return ParsingUtils.unknownTag("<application>", pkg, parser, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseStaticLibrary(ParsingPackage pkg, Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestStaticLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            int version = sa.getInt(1, -1);
            int versionMajor = sa.getInt(2, 0);
            if (lname == null || version < 0) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad static-library declaration name: " + lname + " version: " + version);
                return parseResult;
            }
            if (pkg.getSharedUserId() != null) {
                ParseResult<ParsingPackage> parseResult = input.error(-107, "sharedUserId not allowed in static shared library");
                return parseResult;
            }
            if (pkg.getStaticSharedLibName() != null) {
                ParseResult<ParsingPackage> parseResult = input.error("Multiple static-shared libs for package " + pkg.getPackageName());
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setStaticSharedLibName(lname.intern()).setStaticSharedLibVersion(PackageInfo.composeLongVersionCode(versionMajor, version)).setStaticSharedLibrary(true));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseLibrary(ParsingPackage pkg, Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            if (lname != null) {
                lname = lname.intern();
                if (!ArrayUtils.contains(pkg.getLibraryNames(), lname)) {
                    pkg.addLibraryName(lname);
                }
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesStaticLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesStaticLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            int version = sa.getInt(1, -1);
            String certSha256Digest = sa.getNonResourceString(2);
            if (lname == null || version < 0 || certSha256Digest == null) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad uses-static-library declaration name: " + lname + " version: " + version + " certDigest" + certSha256Digest);
                return parseResult;
            }
            List<String> usesStaticLibraries = pkg.getUsesStaticLibraries();
            if (usesStaticLibraries.contains(lname)) {
                ParseResult<ParsingPackage> parseResult = input.error("Depending on multiple versions of static library " + lname);
                return parseResult;
            }
            lname = lname.intern();
            certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
            String[] additionalCertSha256Digests = EmptyArray.STRING;
            if (pkg.getTargetSdkVersion() >= 27) {
                ParseResult<String[]> certResult = ParsingPackageUtils.parseAdditionalCertificates(input, res, parser);
                if (certResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(certResult);
                    return parseResult;
                }
                additionalCertSha256Digests = certResult.getResult();
            }
            String[] certSha256Digests = new String[additionalCertSha256Digests.length + 1];
            certSha256Digests[0] = certSha256Digest;
            System.arraycopy(additionalCertSha256Digests, 0, certSha256Digests, 1, additionalCertSha256Digests.length);
            ParseResult<ParsingPackage> parseResult = input.success(pkg.addUsesStaticLibrary(lname).addUsesStaticLibraryVersion(version).addUsesStaticLibraryCertDigests(certSha256Digests));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            boolean req = sa.getBoolean(1, true);
            if (lname != null) {
                lname = lname.intern();
                if (req) {
                    pkg.addUsesLibrary(lname).removeUsesOptionalLibrary(lname);
                } else if (!ArrayUtils.contains(pkg.getUsesLibraries(), lname)) {
                    pkg.addUsesOptionalLibrary(lname);
                }
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseProcesses(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, String[] separateProcesses, int flags) throws IOException, XmlPullParserException {
        ParseResult<ArrayMap<String, ParsedProcess>> result = ParsedProcessUtils.parseProcesses(separateProcesses, pkg, res, parser, flags, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.setProcesses((Map<String, ParsedProcess>)result.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseProfileable(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProfileable);
        try {
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setProfileableByShell(pkg.isProfileableByShell() || ParsingPackageUtils.bool(false, 0, sa)));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<String[]> parseAdditionalCertificates(ParseInput input, Resources resources, XmlResourceParser parser) throws XmlPullParserException, IOException {
        int type;
        String[] certSha256Digests = EmptyArray.STRING;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            String nodeName;
            if (type != 2 || !(nodeName = parser.getName()).equals("additional-certificate")) continue;
            TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestAdditionalCertificate);
            try {
                String certSha256Digest = sa.getNonResourceString(0);
                if (TextUtils.isEmpty(certSha256Digest)) {
                    ParseResult<String[]> parseResult = input.error("Bad additional-certificate declaration with empty certDigest:" + certSha256Digest);
                    return parseResult;
                }
                certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
                certSha256Digests = ArrayUtils.appendElement(String.class, certSha256Digests, certSha256Digest);
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(certSha256Digests);
    }

    private static ParseResult<ParsedActivity> generateAppDetailsHiddenActivity(ParseInput input, ParsingPackage pkg) {
        String packageName = pkg.getPackageName();
        ParseResult<String> result = ComponentParseUtils.buildTaskAffinityName(packageName, packageName, ":app_details", input);
        if (result.isError()) {
            return input.error(result);
        }
        String taskAffinity = result.getResult();
        return input.success(ParsedActivity.makeAppDetailsActivity(packageName, pkg.getProcessName(), pkg.getUiOptions(), taskAffinity, pkg.isBaseHardwareAccelerated()));
    }

    private static boolean hasDomainURLs(ParsingPackage pkg) {
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            List<ParsedIntentInfo> filters = activity.getIntents();
            int filtersSize = filters.size();
            for (int filtersIndex = 0; filtersIndex < filtersSize; ++filtersIndex) {
                ParsedIntentInfo aii = filters.get(filtersIndex);
                if (!aii.hasAction("android.intent.action.VIEW") || !aii.hasAction("android.intent.action.VIEW") || !aii.hasDataScheme("http") && !aii.hasDataScheme("https")) continue;
                return true;
            }
        }
        return false;
    }

    private static void setMaxAspectRatio(ParsingPackage pkg) {
        float maxAspectRatio = pkg.getTargetSdkVersion() < 26 ? 1.86f : 0.0f;
        float packageMaxAspectRatio = pkg.getMaxAspectRatio();
        if (packageMaxAspectRatio != 0.0f) {
            maxAspectRatio = packageMaxAspectRatio;
        } else {
            Bundle appMetaData = pkg.getMetaData();
            if (appMetaData != null && appMetaData.containsKey("android.max_aspect")) {
                maxAspectRatio = appMetaData.getFloat("android.max_aspect", maxAspectRatio);
            }
        }
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (activity.getMaxAspectRatio() != null) continue;
            float activityAspectRatio = activity.getMetaData() != null ? activity.getMetaData().getFloat("android.max_aspect", maxAspectRatio) : maxAspectRatio;
            activity.setMaxAspectRatio(activity.getResizeMode(), activityAspectRatio);
        }
    }

    private void setMinAspectRatio(ParsingPackage pkg) {
        float packageMinAspectRatio = pkg.getMinAspectRatio();
        float minAspectRatio = packageMinAspectRatio != 0.0f ? packageMinAspectRatio : (pkg.getTargetSdkVersion() >= 29 ? 0.0f : (this.mCallback != null && this.mCallback.hasFeature("android.hardware.type.watch") ? 1.0f : 1.333f));
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (activity.getMinAspectRatio() != null) continue;
            activity.setMinAspectRatio(activity.getResizeMode(), minAspectRatio);
        }
    }

    private void setSupportsSizeChanges(ParsingPackage pkg) {
        Bundle appMetaData = pkg.getMetaData();
        boolean supportsSizeChanges = appMetaData != null && appMetaData.getBoolean("android.supports_size_changes", false);
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (!supportsSizeChanges && (activity.getMetaData() == null || !activity.getMetaData().getBoolean("android.supports_size_changes", false))) continue;
            activity.setSupportsSizeChanges(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseOverlay(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestResourceOverlay);
        try {
            String propValue;
            String target = sa.getString(1);
            int priority = ParsingPackageUtils.anInt(0, 0, sa);
            if (target == null) {
                ParseResult<ParsingPackage> parseResult = input.error("<overlay> does not specify a target package");
                return parseResult;
            }
            if (priority < 0 || priority > 9999) {
                ParseResult<ParsingPackage> parseResult = input.error("<overlay> priority must be between 0 and 9999");
                return parseResult;
            }
            String propName = sa.getString(5);
            if (!PackageParser.checkRequiredSystemProperties(propName, propValue = sa.getString(6))) {
                String message = "Skipping target and overlay pair " + target + " and " + pkg.getBaseCodePath() + ": overlay ignored due to required system property: " + propName + " with value: " + propValue;
                Slog.i(TAG, message);
                ParseResult<ParsingPackage> parseResult = input.skip(message);
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setOverlay(true).setOverlayTarget(target).setOverlayPriority(priority).setOverlayTargetName(sa.getString(3)).setOverlayCategory(sa.getString(2)).setOverlayIsStatic(ParsingPackageUtils.bool(false, 4, sa)));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseProtectedBroadcast(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProtectedBroadcast);
        try {
            String name = ParsingPackageUtils.nonResString(0, sa);
            if (name != null) {
                pkg.addProtectedBroadcast(name);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseSupportScreens(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSupportsScreens);
        try {
            int requiresSmallestWidthDp = ParsingPackageUtils.anInt(0, 6, sa);
            int compatibleWidthLimitDp = ParsingPackageUtils.anInt(0, 7, sa);
            int largestWidthLimitDp = ParsingPackageUtils.anInt(0, 8, sa);
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setSupportsSmallScreens(ParsingPackageUtils.anInt(1, 1, sa)).setSupportsNormalScreens(ParsingPackageUtils.anInt(1, 2, sa)).setSupportsLargeScreens(ParsingPackageUtils.anInt(1, 3, sa)).setSupportsExtraLargeScreens(ParsingPackageUtils.anInt(1, 5, sa)).setResizeable(ParsingPackageUtils.anInt(1, 4, sa)).setAnyDensity(ParsingPackageUtils.anInt(1, 0, sa)).setRequiresSmallestWidthDp(requiresSmallestWidthDp).setCompatibleWidthLimitDp(compatibleWidthLimitDp).setLargestWidthLimitDp(largestWidthLimitDp));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseInstrumentation(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedInstrumentation> result = ParsedInstrumentationUtils.parseInstrumentation(pkg, res, parser, PackageParser.sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addInstrumentation(result.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseOriginalPackage(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
        try {
            String orig = sa.getNonConfigurationString(0, 0);
            if (!pkg.getPackageName().equals(orig)) {
                if (pkg.getOriginalPackages().isEmpty()) {
                    pkg.setRealPackage(pkg.getPackageName());
                }
                pkg.addOriginalPackage(orig);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseAdoptPermissions(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
        try {
            String name = ParsingPackageUtils.nonConfigString(0, 0, sa);
            if (name != null) {
                pkg.addAdoptPermission(name);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static void convertNewPermissions(ParsingPackage pkg) {
        int NP = PackageParser.NEW_PERMISSIONS.length;
        StringBuilder newPermsMsg = null;
        for (int ip = 0; ip < NP; ++ip) {
            PackageParser.NewPermissionInfo npi = PackageParser.NEW_PERMISSIONS[ip];
            if (pkg.getTargetSdkVersion() >= npi.sdkVersion) break;
            if (pkg.getRequestedPermissions().contains(npi.name)) continue;
            if (newPermsMsg == null) {
                newPermsMsg = new StringBuilder(128);
                newPermsMsg.append(pkg.getPackageName());
                newPermsMsg.append(": compat added ");
            } else {
                newPermsMsg.append(' ');
            }
            newPermsMsg.append(npi.name);
            pkg.addRequestedPermission(npi.name).addImplicitPermission(npi.name);
        }
        if (newPermsMsg != null) {
            Slog.i(TAG, newPermsMsg.toString());
        }
    }

    private static void convertSplitPermissions(ParsingPackage pkg) {
        List<SplitPermissionInfoParcelable> splitPermissions;
        try {
            splitPermissions = ActivityThread.getPermissionManager().getSplitPermissions();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        int listSize = splitPermissions.size();
        for (int is = 0; is < listSize; ++is) {
            SplitPermissionInfoParcelable spi = splitPermissions.get(is);
            List<String> requestedPermissions = pkg.getRequestedPermissions();
            if (pkg.getTargetSdkVersion() >= spi.getTargetSdk() || !requestedPermissions.contains(spi.getSplitPermission())) continue;
            List<String> newPerms = spi.getNewPermissions();
            for (int in = 0; in < newPerms.size(); ++in) {
                String perm = newPerms.get(in);
                if (requestedPermissions.contains(perm)) continue;
                pkg.addRequestedPermission(perm).addImplicitPermission(perm);
            }
        }
    }

    private static void adjustPackageToBeUnresizeableAndUnpipable(ParsingPackage pkg) {
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            activity.setResizeMode(0).setFlags(activity.getFlags() & 0xFFBFFFFF);
        }
    }

    private static ParseResult validateName(ParseInput input, String name, boolean requireSeparator, boolean requireFilename) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return input.error("bad character '" + c + "'");
        }
        if (requireFilename && !FileUtils.isValidExtFilename(name)) {
            return input.error("Invalid filename");
        }
        return hasSep || !requireSeparator ? input.success(null) : input.error("must have at least one '.' separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<Bundle> parseMetaData(ParsingPackage pkg, Resources res, XmlResourceParser parser, Bundle data, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestMetaData);
        try {
            String name;
            if (data == null) {
                data = new Bundle();
            }
            if ((name = TextUtils.safeIntern(ParsingPackageUtils.nonConfigString(0, 0, sa))) == null) {
                ParseResult<Bundle> parseResult = input.error("<meta-data> requires an android:name attribute");
                return parseResult;
            }
            TypedValue v = sa.peekValue(2);
            if (v != null && v.resourceId != 0) {
                data.putInt(name, v.resourceId);
            } else {
                v = sa.peekValue(1);
                if (v != null) {
                    if (v.type == 3) {
                        CharSequence cs = v.coerceToString();
                        data.putString(name, cs != null ? cs.toString() : null);
                    } else if (v.type == 18) {
                        data.putBoolean(name, v.data != 0);
                    } else if (v.type >= 16 && v.type <= 31) {
                        data.putInt(name, v.data);
                    } else if (v.type == 4) {
                        data.putFloat(name, v.getFloat());
                    } else {
                        Slog.w(TAG, "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + pkg.getBaseCodePath() + " " + parser.getPositionDescription());
                    }
                } else {
                    ParseResult<Bundle> parseResult = input.error("<meta-data> requires an android:value or android:resource attribute");
                    return parseResult;
                }
            }
            ParseResult<Bundle> parseResult = input.success(data);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageParser.SigningDetails getSigningDetails(ParsingPackageRead pkg, boolean skipVerify) throws PackageParser.PackageParserException {
        PackageParser.SigningDetails signingDetails = PackageParser.SigningDetails.UNKNOWN;
        ParseInput input = ParseTypeImpl.forDefaultParsing().reset();
        Trace.traceBegin(262144L, "collectCertificates");
        try {
            ParseResult<PackageParser.SigningDetails> result = ParsingPackageUtils.getSigningDetails(input, pkg.getBaseCodePath(), skipVerify, pkg.isStaticSharedLibrary(), signingDetails, pkg.getTargetSdkVersion());
            if (result.isError()) {
                throw new PackageParser.PackageParserException(result.getErrorCode(), result.getErrorMessage(), result.getException());
            }
            signingDetails = result.getResult();
            String[] splitCodePaths = pkg.getSplitCodePaths();
            if (!ArrayUtils.isEmpty(splitCodePaths)) {
                for (int i = 0; i < splitCodePaths.length; ++i) {
                    result = ParsingPackageUtils.getSigningDetails(input, splitCodePaths[i], skipVerify, pkg.isStaticSharedLibrary(), signingDetails, pkg.getTargetSdkVersion());
                    if (result.isError()) {
                        throw new PackageParser.PackageParserException(result.getErrorCode(), result.getErrorMessage(), result.getException());
                    }
                    signingDetails = result.getResult();
                }
            }
            PackageParser.SigningDetails signingDetails2 = signingDetails;
            return signingDetails2;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    public static ParseResult<PackageParser.SigningDetails> getSigningDetails(ParseInput input, String baseCodePath, boolean skipVerify, boolean isStaticSharedLibrary, PackageParser.SigningDetails existingSigningDetails, int targetSdk) {
        PackageParser.SigningDetails verified;
        int minSignatureScheme = ApkSignatureVerifier.getMinimumSignatureSchemeVersionForTargetSdk(targetSdk);
        if (isStaticSharedLibrary) {
            minSignatureScheme = 2;
        }
        try {
            verified = skipVerify ? ApkSignatureVerifier.unsafeGetCertsWithoutVerification(baseCodePath, 1) : ApkSignatureVerifier.verify(baseCodePath, minSignatureScheme);
        }
        catch (PackageParser.PackageParserException e) {
            return input.error(-103, "Failed collecting certificates for " + baseCodePath, e);
        }
        if (existingSigningDetails == PackageParser.SigningDetails.UNKNOWN) {
            return input.success(verified);
        }
        if (!Signature.areExactMatch(existingSigningDetails.signatures, verified.signatures)) {
            return input.error(-104, baseCodePath + " has mismatched certificates");
        }
        return input.success(existingSigningDetails);
    }

    private static boolean bool(boolean defaultValue, int attribute, TypedArray sa) {
        return sa.getBoolean(attribute, defaultValue);
    }

    private static float aFloat(float defaultValue, int attribute, TypedArray sa) {
        return sa.getFloat(attribute, defaultValue);
    }

    private static float aFloat(int attribute, TypedArray sa) {
        return sa.getFloat(attribute, 0.0f);
    }

    private static int anInt(int defaultValue, int attribute, TypedArray sa) {
        return sa.getInt(attribute, defaultValue);
    }

    private static int anInteger(int defaultValue, int attribute, TypedArray sa) {
        return sa.getInteger(attribute, defaultValue);
    }

    private static int anInt(int attribute, TypedArray sa) {
        return sa.getInt(attribute, 0);
    }

    private static int resId(int attribute, TypedArray sa) {
        return sa.getResourceId(attribute, 0);
    }

    private static String string(int attribute, TypedArray sa) {
        return sa.getString(attribute);
    }

    private static String nonConfigString(int allowedChangingConfigs, int attribute, TypedArray sa) {
        return sa.getNonConfigurationString(attribute, allowedChangingConfigs);
    }

    private static String nonResString(int index, TypedArray sa) {
        return sa.getNonResourceString(index);
    }

    public static interface Callback {
        public boolean hasFeature(String var1);

        public ParsingPackage startParsingPackage(String var1, String var2, String var3, TypedArray var4, boolean var5);
    }
}

