/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.apex.ApexInfo;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.SELinuxUtil;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.content.pm.parsing.ParsingPackageRead;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedActivity;
import android.content.pm.parsing.component.ParsedComponent;
import android.content.pm.parsing.component.ParsedInstrumentation;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.content.pm.parsing.component.ParsedPermission;
import android.content.pm.parsing.component.ParsedPermissionGroup;
import android.content.pm.parsing.component.ParsedProvider;
import android.content.pm.parsing.component.ParsedService;
import android.os.Environment;
import android.os.UserHandle;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import libcore.util.EmptyArray;

public class PackageInfoWithoutStateUtils {
    public static PackageInfo generate(ParsingPackageRead pkg, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId) {
        return PackageInfoWithoutStateUtils.generateWithComponents(pkg, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, userId, null);
    }

    public static PackageInfo generate(ParsingPackageRead pkg, ApexInfo apexInfo, int flags) {
        return PackageInfoWithoutStateUtils.generateWithComponents(pkg, EmptyArray.INT, flags, 0L, 0L, Collections.emptySet(), new PackageUserState(), UserHandle.getCallingUserId(), apexInfo);
    }

    private static PackageInfo generateWithComponents(ParsingPackageRead pkg, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId, ApexInfo apexInfo) {
        int size;
        ParsedActivity a;
        int i;
        ComponentInfo[] res;
        int num;
        int N;
        ApplicationInfo applicationInfo = PackageInfoWithoutStateUtils.generateApplicationInfo(pkg, flags, state, userId);
        if (applicationInfo == null) {
            return null;
        }
        PackageInfo info = PackageInfoWithoutStateUtils.generateWithoutComponents(pkg, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, userId, apexInfo, applicationInfo);
        if (info == null) {
            return null;
        }
        if ((flags & 1) != 0 && (N = pkg.getActivities().size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i = 0; i < N; ++i) {
                a = pkg.getActivities().get(i);
                if (!ComponentParseUtils.isMatch(state, false, pkg.isEnabled(), a, flags) || PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(a.getName())) continue;
                res[num++] = PackageInfoWithoutStateUtils.generateActivityInfo(pkg, a, flags, state, applicationInfo, userId);
            }
            info.activities = ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 2) != 0 && (size = pkg.getReceivers().size()) > 0) {
            num = 0;
            res = new ActivityInfo[size];
            for (i = 0; i < size; ++i) {
                a = pkg.getReceivers().get(i);
                if (!ComponentParseUtils.isMatch(state, false, pkg.isEnabled(), a, flags)) continue;
                res[num++] = PackageInfoWithoutStateUtils.generateActivityInfo(pkg, a, flags, state, applicationInfo, userId);
            }
            info.receivers = (ActivityInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 4) != 0 && (size = pkg.getServices().size()) > 0) {
            num = 0;
            res = new ServiceInfo[size];
            for (i = 0; i < size; ++i) {
                ParsedService s = pkg.getServices().get(i);
                if (!ComponentParseUtils.isMatch(state, false, pkg.isEnabled(), s, flags)) continue;
                res[num++] = PackageInfoWithoutStateUtils.generateServiceInfo(pkg, s, flags, state, applicationInfo, userId);
            }
            info.services = (ServiceInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 8) != 0 && (size = pkg.getProviders().size()) > 0) {
            num = 0;
            res = new ProviderInfo[size];
            for (i = 0; i < size; ++i) {
                ParsedProvider pr = pkg.getProviders().get(i);
                if (!ComponentParseUtils.isMatch(state, false, pkg.isEnabled(), pr, flags)) continue;
                res[num++] = PackageInfoWithoutStateUtils.generateProviderInfo(pkg, pr, flags, state, applicationInfo, userId);
            }
            info.providers = (ProviderInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 0x10) != 0 && (N = pkg.getInstrumentations().size()) > 0) {
            info.instrumentation = new InstrumentationInfo[N];
            for (int i2 = 0; i2 < N; ++i2) {
                info.instrumentation[i2] = PackageInfoWithoutStateUtils.generateInstrumentationInfo(pkg.getInstrumentations().get(i2), pkg, flags, userId);
            }
        }
        return info;
    }

    public static PackageInfo generateWithoutComponents(ParsingPackageRead pkg, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId, ApexInfo apexInfo, ApplicationInfo applicationInfo) {
        if (!PackageInfoWithoutStateUtils.checkUseInstalled(pkg, state, flags)) {
            return null;
        }
        return PackageInfoWithoutStateUtils.generateWithoutComponentsUnchecked(pkg, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, userId, apexInfo, applicationInfo);
    }

    public static PackageInfo generateWithoutComponentsUnchecked(ParsingPackageRead pkg, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId, ApexInfo apexInfo, ApplicationInfo applicationInfo) {
        int size;
        PackageInfo pi = new PackageInfo();
        pi.packageName = pkg.getPackageName();
        pi.splitNames = pkg.getSplitNames();
        pi.versionCode = pkg.getVersionCode();
        pi.versionCodeMajor = pkg.getVersionCodeMajor();
        pi.baseRevisionCode = pkg.getBaseRevisionCode();
        pi.splitRevisionCodes = pkg.getSplitRevisionCodes();
        pi.versionName = pkg.getVersionName();
        pi.sharedUserId = pkg.getSharedUserId();
        pi.sharedUserLabel = pkg.getSharedUserLabel();
        pi.applicationInfo = applicationInfo;
        pi.installLocation = pkg.getInstallLocation();
        if ((pi.applicationInfo.flags & 1) != 0 || (pi.applicationInfo.flags & 0x80) != 0) {
            pi.requiredForAllUsers = pkg.isRequiredForAllUsers();
        }
        pi.restrictedAccountType = pkg.getRestrictedAccountType();
        pi.requiredAccountType = pkg.getRequiredAccountType();
        pi.overlayTarget = pkg.getOverlayTarget();
        pi.targetOverlayableName = pkg.getOverlayTargetName();
        pi.overlayCategory = pkg.getOverlayCategory();
        pi.overlayPriority = pkg.getOverlayPriority();
        pi.mOverlayIsStatic = pkg.isOverlayIsStatic();
        pi.compileSdkVersion = pkg.getCompileSdkVersion();
        pi.compileSdkVersionCodename = pkg.getCompileSdkVersionCodeName();
        pi.firstInstallTime = firstInstallTime;
        pi.lastUpdateTime = lastUpdateTime;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0) {
            size = pkg.getConfigPreferences().size();
            if (size > 0) {
                pi.configPreferences = new ConfigurationInfo[size];
                pkg.getConfigPreferences().toArray(pi.configPreferences);
            }
            if ((size = pkg.getReqFeatures().size()) > 0) {
                pi.reqFeatures = new FeatureInfo[size];
                pkg.getReqFeatures().toArray(pi.reqFeatures);
            }
            if ((size = pkg.getFeatureGroups().size()) > 0) {
                pi.featureGroups = new FeatureGroupInfo[size];
                pkg.getFeatureGroups().toArray(pi.featureGroups);
            }
        }
        if ((flags & 0x1000) != 0) {
            int i;
            size = ArrayUtils.size(pkg.getPermissions());
            if (size > 0) {
                pi.permissions = new PermissionInfo[size];
                for (i = 0; i < size; ++i) {
                    pi.permissions[i] = PackageInfoWithoutStateUtils.generatePermissionInfo(pkg.getPermissions().get(i), flags);
                }
            }
            if ((size = pkg.getRequestedPermissions().size()) > 0) {
                pi.requestedPermissions = new String[size];
                pi.requestedPermissionsFlags = new int[size];
                for (i = 0; i < size; ++i) {
                    String perm;
                    pi.requestedPermissions[i] = perm = pkg.getRequestedPermissions().get(i);
                    int n = i;
                    pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 1;
                    if (grantedPermissions == null || !grantedPermissions.contains(perm)) continue;
                    int n2 = i;
                    pi.requestedPermissionsFlags[n2] = pi.requestedPermissionsFlags[n2] | 2;
                }
            }
        }
        if (apexInfo != null) {
            File apexFile = new File(apexInfo.modulePath);
            pi.applicationInfo.sourceDir = apexFile.getPath();
            pi.applicationInfo.publicSourceDir = apexFile.getPath();
            pi.applicationInfo.flags = apexInfo.isFactory ? (pi.applicationInfo.flags |= 1) : (pi.applicationInfo.flags &= 0xFFFFFFFE);
            pi.applicationInfo.flags = apexInfo.isActive ? (pi.applicationInfo.flags |= 0x800000) : (pi.applicationInfo.flags &= 0xFF7FFFFF);
            pi.isApex = true;
        }
        PackageParser.SigningDetails signingDetails = pkg.getSigningDetails();
        if ((flags & 0x40) != 0) {
            if (signingDetails.hasPastSigningCertificates()) {
                pi.signatures = new Signature[1];
                pi.signatures[0] = signingDetails.pastSigningCertificates[0];
            } else if (signingDetails.hasSignatures()) {
                int numberOfSigs = signingDetails.signatures.length;
                pi.signatures = new Signature[numberOfSigs];
                System.arraycopy(signingDetails.signatures, 0, pi.signatures, 0, numberOfSigs);
            }
        }
        if ((flags & 0x8000000) != 0) {
            pi.signingInfo = signingDetails != PackageParser.SigningDetails.UNKNOWN ? new SigningInfo(signingDetails) : null;
        }
        return pi;
    }

    public static ApplicationInfo generateApplicationInfo(ParsingPackageRead pkg, int flags, PackageUserState state, int userId) {
        if (pkg == null) {
            return null;
        }
        if (!PackageInfoWithoutStateUtils.checkUseInstalled(pkg, state, flags)) {
            return null;
        }
        return PackageInfoWithoutStateUtils.generateApplicationInfoUnchecked(pkg, flags, state, userId);
    }

    public static ApplicationInfo generateApplicationInfoUnchecked(ParsingPackageRead pkg, int flags, PackageUserState state, int userId) {
        ApplicationInfo ai = pkg.toAppInfoWithoutState();
        ai.initForUser(userId);
        if ((flags & 0x80) == 0) {
            ai.metaData = null;
        }
        if ((flags & 0x400) == 0) {
            ai.sharedLibraryFiles = null;
            ai.sharedLibraryInfos = null;
        }
        if (!PackageParser.sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        ai.flags |= PackageInfoWithoutStateUtils.flag(state.stopped, 0x200000) | PackageInfoWithoutStateUtils.flag(state.installed, 0x800000) | PackageInfoWithoutStateUtils.flag(state.suspended, 0x40000000);
        ai.privateFlags |= PackageInfoWithoutStateUtils.flag(state.instantApp, 128) | PackageInfoWithoutStateUtils.flag(state.virtualPreload, 65536) | PackageInfoWithoutStateUtils.flag(state.hidden, 1);
        if (state.enabled == 1) {
            ai.enabled = true;
        } else if (state.enabled == 4) {
            ai.enabled = (flags & 0x8000) != 0;
        } else if (state.enabled == 2 || state.enabled == 3) {
            ai.enabled = false;
        }
        ai.enabledSetting = state.enabled;
        if (ai.category == -1) {
            ai.category = state.categoryHint;
        }
        if (ai.category == -1) {
            ai.category = FallbackCategoryProvider.getFallbackCategory(ai.packageName);
        }
        ai.seInfoUser = SELinuxUtil.assignSeinfoUser(state);
        ai.resourceDirs = state.getAllOverlayPaths();
        return ai;
    }

    public static ActivityInfo generateActivityInfo(ParsingPackageRead pkg, ParsedActivity a, int flags, PackageUserState state, ApplicationInfo applicationInfo, int userId) {
        if (a == null) {
            return null;
        }
        if (!PackageInfoWithoutStateUtils.checkUseInstalled(pkg, state, flags)) {
            return null;
        }
        if (applicationInfo == null) {
            applicationInfo = PackageInfoWithoutStateUtils.generateApplicationInfo(pkg, flags, state, userId);
        }
        if (applicationInfo == null) {
            return null;
        }
        return PackageInfoWithoutStateUtils.generateActivityInfoUnchecked(a, applicationInfo);
    }

    public static ActivityInfo generateActivityInfoUnchecked(ParsedActivity a, ApplicationInfo applicationInfo) {
        ActivityInfo ai = new ActivityInfo();
        PackageInfoWithoutStateUtils.assignSharedFieldsForComponentInfo(ai, a);
        ai.targetActivity = a.getTargetActivity();
        ai.processName = a.getProcessName();
        ai.exported = a.isExported();
        ai.theme = a.getTheme();
        ai.uiOptions = a.getUiOptions();
        ai.parentActivityName = a.getParentActivityName();
        ai.permission = a.getPermission();
        ai.taskAffinity = a.getTaskAffinity();
        ai.flags = a.getFlags();
        ai.privateFlags = a.getPrivateFlags();
        ai.launchMode = a.getLaunchMode();
        ai.documentLaunchMode = a.getDocumentLaunchMode();
        ai.maxRecents = a.getMaxRecents();
        ai.configChanges = a.getConfigChanges();
        ai.softInputMode = a.getSoftInputMode();
        ai.persistableMode = a.getPersistableMode();
        ai.lockTaskLaunchMode = a.getLockTaskLaunchMode();
        ai.screenOrientation = a.getScreenOrientation();
        ai.resizeMode = a.getResizeMode();
        Float maxAspectRatio = a.getMaxAspectRatio();
        ai.maxAspectRatio = maxAspectRatio != null ? maxAspectRatio.floatValue() : 0.0f;
        Float minAspectRatio = a.getMinAspectRatio();
        ai.minAspectRatio = minAspectRatio != null ? minAspectRatio.floatValue() : 0.0f;
        ai.supportsSizeChanges = a.getSupportsSizeChanges();
        ai.requestedVrComponent = a.getRequestedVrComponent();
        ai.rotationAnimation = a.getRotationAnimation();
        ai.colorMode = a.getColorMode();
        ai.windowLayout = a.getWindowLayout();
        ai.metaData = a.getMetaData();
        ai.applicationInfo = applicationInfo;
        return ai;
    }

    public static ActivityInfo generateActivityInfo(ParsingPackageRead pkg, ParsedActivity a, int flags, PackageUserState state, int userId) {
        return PackageInfoWithoutStateUtils.generateActivityInfo(pkg, a, flags, state, null, userId);
    }

    public static ServiceInfo generateServiceInfo(ParsingPackageRead pkg, ParsedService s, int flags, PackageUserState state, ApplicationInfo applicationInfo, int userId) {
        if (s == null) {
            return null;
        }
        if (!PackageInfoWithoutStateUtils.checkUseInstalled(pkg, state, flags)) {
            return null;
        }
        if (applicationInfo == null) {
            applicationInfo = PackageInfoWithoutStateUtils.generateApplicationInfo(pkg, flags, state, userId);
        }
        if (applicationInfo == null) {
            return null;
        }
        return PackageInfoWithoutStateUtils.generateServiceInfoUnchecked(s, applicationInfo);
    }

    public static ServiceInfo generateServiceInfoUnchecked(ParsedService s, ApplicationInfo applicationInfo) {
        ServiceInfo si = new ServiceInfo();
        PackageInfoWithoutStateUtils.assignSharedFieldsForComponentInfo(si, s);
        si.exported = s.isExported();
        si.flags = s.getFlags();
        si.metaData = s.getMetaData();
        si.permission = s.getPermission();
        si.processName = s.getProcessName();
        si.mForegroundServiceType = s.getForegroundServiceType();
        si.applicationInfo = applicationInfo;
        return si;
    }

    public static ServiceInfo generateServiceInfo(ParsingPackageRead pkg, ParsedService s, int flags, PackageUserState state, int userId) {
        return PackageInfoWithoutStateUtils.generateServiceInfo(pkg, s, flags, state, null, userId);
    }

    public static ProviderInfo generateProviderInfo(ParsingPackageRead pkg, ParsedProvider p, int flags, PackageUserState state, ApplicationInfo applicationInfo, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageInfoWithoutStateUtils.checkUseInstalled(pkg, state, flags)) {
            return null;
        }
        if (applicationInfo == null) {
            applicationInfo = PackageInfoWithoutStateUtils.generateApplicationInfo(pkg, flags, state, userId);
        }
        if (applicationInfo == null) {
            return null;
        }
        return PackageInfoWithoutStateUtils.generateProviderInfoUnchecked(p, flags, applicationInfo);
    }

    public static ProviderInfo generateProviderInfoUnchecked(ParsedProvider p, int flags, ApplicationInfo applicationInfo) {
        ProviderInfo pi = new ProviderInfo();
        PackageInfoWithoutStateUtils.assignSharedFieldsForComponentInfo(pi, p);
        pi.exported = p.isExported();
        pi.flags = p.getFlags();
        pi.processName = p.getProcessName();
        pi.authority = p.getAuthority();
        pi.isSyncable = p.isSyncable();
        pi.readPermission = p.getReadPermission();
        pi.writePermission = p.getWritePermission();
        pi.grantUriPermissions = p.isGrantUriPermissions();
        pi.forceUriPermissions = p.isForceUriPermissions();
        pi.multiprocess = p.isMultiProcess();
        pi.initOrder = p.getInitOrder();
        pi.uriPermissionPatterns = p.getUriPermissionPatterns();
        pi.pathPermissions = p.getPathPermissions();
        pi.metaData = p.getMetaData();
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = applicationInfo;
        return pi;
    }

    public static ProviderInfo generateProviderInfo(ParsingPackageRead pkg, ParsedProvider p, int flags, PackageUserState state, int userId) {
        return PackageInfoWithoutStateUtils.generateProviderInfo(pkg, p, flags, state, null, userId);
    }

    public static InstrumentationInfo generateInstrumentationInfo(ParsedInstrumentation i, ParsingPackageRead pkg, int flags, int userId) {
        if (i == null) {
            return null;
        }
        InstrumentationInfo ii = new InstrumentationInfo();
        PackageInfoWithoutStateUtils.assignSharedFieldsForPackageItemInfo(ii, i);
        ii.targetPackage = i.getTargetPackage();
        ii.targetProcesses = i.getTargetProcesses();
        ii.handleProfiling = i.isHandleProfiling();
        ii.functionalTest = i.isFunctionalTest();
        ii.sourceDir = pkg.getBaseCodePath();
        ii.publicSourceDir = pkg.getBaseCodePath();
        ii.splitNames = pkg.getSplitNames();
        ii.splitSourceDirs = pkg.getSplitCodePaths();
        ii.splitPublicSourceDirs = pkg.getSplitCodePaths();
        ii.splitDependencies = pkg.getSplitDependencies();
        ii.dataDir = PackageInfoWithoutStateUtils.getDataDir(pkg, userId).getAbsolutePath();
        ii.deviceProtectedDataDir = PackageInfoWithoutStateUtils.getDeviceProtectedDataDir(pkg, userId).getAbsolutePath();
        ii.credentialProtectedDataDir = PackageInfoWithoutStateUtils.getCredentialProtectedDataDir(pkg, userId).getAbsolutePath();
        if ((flags & 0x80) == 0) {
            return ii;
        }
        ii.metaData = i.getMetaData();
        return ii;
    }

    public static PermissionInfo generatePermissionInfo(ParsedPermission p, int flags) {
        if (p == null) {
            return null;
        }
        PermissionInfo pi = new PermissionInfo(p.getBackgroundPermission());
        PackageInfoWithoutStateUtils.assignSharedFieldsForPackageItemInfo(pi, p);
        pi.group = p.getGroup();
        pi.requestRes = p.getRequestRes();
        pi.protectionLevel = p.getProtectionLevel();
        pi.descriptionRes = p.getDescriptionRes();
        pi.flags = p.getFlags();
        if ((flags & 0x80) == 0) {
            return pi;
        }
        pi.metaData = p.getMetaData();
        return pi;
    }

    public static PermissionGroupInfo generatePermissionGroupInfo(ParsedPermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.getRequestDetailResourceId(), pg.getBackgroundRequestResourceId(), pg.getBackgroundRequestDetailResourceId());
        PackageInfoWithoutStateUtils.assignSharedFieldsForPackageItemInfo(pgi, pg);
        pgi.descriptionRes = pg.getDescriptionRes();
        pgi.priority = pg.getPriority();
        pgi.requestRes = pg.getRequestRes();
        pgi.flags = pg.getFlags();
        if ((flags & 0x80) == 0) {
            return pgi;
        }
        pgi.metaData = pg.getMetaData();
        return pgi;
    }

    private static void assignSharedFieldsForComponentInfo(ComponentInfo componentInfo, ParsedMainComponent mainComponent) {
        PackageInfoWithoutStateUtils.assignSharedFieldsForPackageItemInfo(componentInfo, mainComponent);
        componentInfo.descriptionRes = mainComponent.getDescriptionRes();
        componentInfo.directBootAware = mainComponent.isDirectBootAware();
        componentInfo.enabled = mainComponent.isEnabled();
        componentInfo.splitName = mainComponent.getSplitName();
    }

    private static void assignSharedFieldsForPackageItemInfo(PackageItemInfo packageItemInfo, ParsedComponent component) {
        packageItemInfo.nonLocalizedLabel = ComponentParseUtils.getNonLocalizedLabel(component);
        packageItemInfo.icon = ComponentParseUtils.getIcon(component);
        packageItemInfo.banner = component.getBanner();
        packageItemInfo.labelRes = component.getLabelRes();
        packageItemInfo.logo = component.getLogo();
        packageItemInfo.name = component.getName();
        packageItemInfo.packageName = component.getPackageName();
    }

    private static int flag(boolean hasFlag, int flag) {
        if (hasFlag) {
            return flag;
        }
        return 0;
    }

    public static int appInfoFlags(ParsingPackageRead pkg) {
        return PackageInfoWithoutStateUtils.flag(pkg.isExternalStorage(), 262144) | PackageInfoWithoutStateUtils.flag(pkg.isBaseHardwareAccelerated(), 0x20000000) | PackageInfoWithoutStateUtils.flag(pkg.isAllowBackup(), 32768) | PackageInfoWithoutStateUtils.flag(pkg.isKillAfterRestore(), 65536) | PackageInfoWithoutStateUtils.flag(pkg.isRestoreAnyVersion(), 131072) | PackageInfoWithoutStateUtils.flag(pkg.isFullBackupOnly(), 0x4000000) | PackageInfoWithoutStateUtils.flag(pkg.isPersistent(), 8) | PackageInfoWithoutStateUtils.flag(pkg.isDebuggable(), 2) | PackageInfoWithoutStateUtils.flag(pkg.isVmSafeMode(), 16384) | PackageInfoWithoutStateUtils.flag(pkg.isHasCode(), 4) | PackageInfoWithoutStateUtils.flag(pkg.isAllowTaskReparenting(), 32) | PackageInfoWithoutStateUtils.flag(pkg.isAllowClearUserData(), 64) | PackageInfoWithoutStateUtils.flag(pkg.isLargeHeap(), 0x100000) | PackageInfoWithoutStateUtils.flag(pkg.isUsesCleartextTraffic(), 0x8000000) | PackageInfoWithoutStateUtils.flag(pkg.isSupportsRtl(), 0x400000) | PackageInfoWithoutStateUtils.flag(pkg.isTestOnly(), 256) | PackageInfoWithoutStateUtils.flag(pkg.isMultiArch(), Integer.MIN_VALUE) | PackageInfoWithoutStateUtils.flag(pkg.isExtractNativeLibs(), 0x10000000) | PackageInfoWithoutStateUtils.flag(pkg.isGame(), 0x2000000) | PackageInfoWithoutStateUtils.flag(pkg.isSupportsSmallScreens(), 512) | PackageInfoWithoutStateUtils.flag(pkg.isSupportsNormalScreens(), 1024) | PackageInfoWithoutStateUtils.flag(pkg.isSupportsLargeScreens(), 2048) | PackageInfoWithoutStateUtils.flag(pkg.isSupportsExtraLargeScreens(), 524288) | PackageInfoWithoutStateUtils.flag(pkg.isResizeable(), 4096) | PackageInfoWithoutStateUtils.flag(pkg.isAnyDensity(), 8192);
    }

    public static int appInfoPrivateFlags(ParsingPackageRead pkg) {
        int privateFlags = PackageInfoWithoutStateUtils.flag(pkg.isStaticSharedLibrary(), 16384) | PackageInfoWithoutStateUtils.flag(pkg.isOverlay(), 0x10000000) | PackageInfoWithoutStateUtils.flag(pkg.isIsolatedSplitLoading(), 32768) | PackageInfoWithoutStateUtils.flag(pkg.isHasDomainUrls(), 16) | PackageInfoWithoutStateUtils.flag(pkg.isProfileableByShell(), 0x800000) | PackageInfoWithoutStateUtils.flag(pkg.isBackupInForeground(), 8192) | PackageInfoWithoutStateUtils.flag(pkg.isUseEmbeddedDex(), 0x2000000) | PackageInfoWithoutStateUtils.flag(pkg.isDefaultToDeviceProtectedStorage(), 32) | PackageInfoWithoutStateUtils.flag(pkg.isDirectBootAware(), 64) | PackageInfoWithoutStateUtils.flag(pkg.isPartiallyDirectBootAware(), 256) | PackageInfoWithoutStateUtils.flag(pkg.isAllowClearUserDataOnFailedRestore(), 0x4000000) | PackageInfoWithoutStateUtils.flag(pkg.isAllowAudioPlaybackCapture(), 0x8000000) | PackageInfoWithoutStateUtils.flag(pkg.isRequestLegacyExternalStorage(), 0x20000000) | PackageInfoWithoutStateUtils.flag(pkg.isUsesNonSdkApi(), 0x400000) | PackageInfoWithoutStateUtils.flag(pkg.isHasFragileUserData(), 0x1000000) | PackageInfoWithoutStateUtils.flag(pkg.isCantSaveState(), 2) | PackageInfoWithoutStateUtils.flag(pkg.isResizeableActivityViaSdkVersion(), 4096) | PackageInfoWithoutStateUtils.flag(pkg.isAllowNativeHeapPointerTagging(), Integer.MIN_VALUE);
        Boolean resizeableActivity = pkg.getResizeableActivity();
        if (resizeableActivity != null) {
            privateFlags = resizeableActivity.booleanValue() ? (privateFlags |= 0x400) : (privateFlags |= 0x800);
        }
        return privateFlags;
    }

    private static boolean checkUseInstalled(ParsingPackageRead pkg, PackageUserState state, int flags) {
        return state.isAvailable(flags);
    }

    public static File getDataDir(ParsingPackageRead pkg, int userId) {
        if ("android".equals(pkg.getPackageName())) {
            return Environment.getDataSystemDirectory();
        }
        if (pkg.isDefaultToDeviceProtectedStorage()) {
            return PackageInfoWithoutStateUtils.getDeviceProtectedDataDir(pkg, userId);
        }
        return PackageInfoWithoutStateUtils.getCredentialProtectedDataDir(pkg, userId);
    }

    public static File getDeviceProtectedDataDir(ParsingPackageRead pkg, int userId) {
        return Environment.getDataUserDePackageDirectory(pkg.getVolumeUuid(), userId, pkg.getPackageName());
    }

    public static File getCredentialProtectedDataDir(ParsingPackageRead pkg, int userId) {
        return Environment.getDataUserCePackageDirectory(pkg.getVolumeUuid(), userId, pkg.getPackageName());
    }
}

