/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ManualTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<ManualTimeSuggestion> CREATOR = new Parcelable.Creator<ManualTimeSuggestion>(){

        @Override
        public ManualTimeSuggestion createFromParcel(Parcel in) {
            return ManualTimeSuggestion.createFromParcel(in);
        }

        public ManualTimeSuggestion[] newArray(int size) {
            return new ManualTimeSuggestion[size];
        }
    };
    private final TimestampedValue<Long> mUtcTime;
    private ArrayList<String> mDebugInfo;

    public ManualTimeSuggestion(TimestampedValue<Long> utcTime) {
        this.mUtcTime = Objects.requireNonNull(utcTime);
        Objects.requireNonNull(utcTime.getValue());
    }

    private static ManualTimeSuggestion createFromParcel(Parcel in) {
        ArrayList debugInfo;
        TimestampedValue utcTime = (TimestampedValue)in.readParcelable(null);
        ManualTimeSuggestion suggestion = new ManualTimeSuggestion(utcTime);
        suggestion.mDebugInfo = debugInfo = in.readArrayList(null);
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUtcTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public TimestampedValue<Long> getUtcTime() {
        return this.mUtcTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualTimeSuggestion that = (ManualTimeSuggestion)o;
        return Objects.equals(this.mUtcTime, that.mUtcTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUtcTime);
    }

    public String toString() {
        return "ManualTimeSuggestion{mUtcTime=" + this.mUtcTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }
}

