/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"isTrustedOrigin", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "writeAboutJson", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeApplicationInfoJson", "out", "Ljava/io/OutputStream;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "intellij.platform.builtInServer.impl"})
public final class AboutHttpServiceKt {
    private static final boolean isTrustedOrigin(HttpRequest request) {
        String string = NettyKt.getOrigin((HttpRequest)request);
        if (string == null) {
            return false;
        }
        String origin = string;
        CharSequence charSequence = origin;
        String string2 = "https?://([a-z0-9-]+\\.)*hyperskill.org$";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        return string2.matches(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeApplicationInfoJson(@NotNull OutputStream out, @Nullable QueryStringDecoder urlDecoder) {
        JsonGenerator writer;
        JsonGenerator $this$obj$iv = writer = new JsonFactory().createGenerator(out).useDefaultPrettyPrinter();
        String fieldName$iv = null;
        boolean $i$f$obj = false;
        $this$obj$iv.writeStartObject();
        boolean bl = false;
        AboutHttpServiceKt.writeAboutJson(writer);
        if (urlDecoder != null && RestService.Companion.getBooleanParameter$default(RestService.Companion, "registeredFileTypes", urlDecoder, false, 4, null)) {
            void $this$array$iv;
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = "registeredFileTypes";
            boolean $i$f$array = false;
            String string = fieldName$iv2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it$iv = string;
            boolean bl4 = false;
            $this$array$iv.writeFieldName(it$iv);
            $this$array$iv.writeStartArray();
            boolean bl5 = false;
            for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                JsonGenerator $this$obj$iv2 = writer;
                String fieldName$iv3 = null;
                boolean $i$f$obj2 = false;
                $this$obj$iv2.writeStartObject();
                boolean bl6 = false;
                writer.writeStringField("name", fileType.getName());
                writer.writeStringField("description", fileType.getDescription());
                writer.writeBooleanField("isBinary", fileType.isBinary());
                $this$obj$iv2.writeEndObject();
            }
            $this$array$iv.writeEndArray();
        }
        if (urlDecoder != null && RestService.Companion.getBooleanParameter$default(RestService.Companion, "more", urlDecoder, false, 4, null)) {
            ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
            writer.writeStringField("vendor", appInfo.getCompanyName());
            writer.writeBooleanField("isEAP", appInfo.isEAP());
            writer.writeStringField("productCode", appInfo.getBuild().getProductCode());
            writer.writeNumberField("buildDate", appInfo.getBuildDate().getTime().getTime());
            writer.writeBooleanField("isSnapshot", appInfo.getBuild().isSnapshot());
            writer.writeStringField("configPath", PathManager.getConfigPath());
            writer.writeStringField("systemPath", PathManager.getSystemPath());
            writer.writeStringField("binPath", PathManager.getBinPath());
            writer.writeStringField("logPath", PathManager.getLogPath());
            writer.writeStringField("homePath", PathManager.getHomePath());
        }
        $this$obj$iv.writeEndObject();
        writer.close();
    }

    public static final void writeAboutJson(@NotNull JsonGenerator writer) {
        String appName = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate()) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            appName = StringsKt.removePrefix((String)StringsKt.replace$default((String)appName, (String)(productName + " (" + productName + ')'), (String)productName, (boolean)false, (int)4, null), (CharSequence)"JetBrains ");
        }
        writer.writeStringField("name", appName);
        writer.writeStringField("productName", ApplicationNamesInfo.getInstance().getProductName());
        BuildNumber build = ApplicationInfo.getInstance().getBuild();
        writer.writeNumberField("baselineVersion", build.getBaselineVersion());
        if (!build.isSnapshot()) {
            writer.writeStringField("buildNumber", build.asStringWithoutProductCode());
        }
    }

    public static final /* synthetic */ boolean access$isTrustedOrigin(HttpRequest request) {
        return AboutHttpServiceKt.isTrustedOrigin(request);
    }
}

