/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost", "intellij.platform.builtInServer.impl"})
final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Channel channel = context.channel();
        boolean isSignedRequest = BuiltInWebServerKt.isSignedRequest((HttpRequest)request);
        EmptyHttpHeaders extraHeaders = EmptyHttpHeaders.INSTANCE;
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        PathInfo pathInfo = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = pathToFileManager.doFindByRelativePath$intellij_platform_builtInServer_impl(path, WebServerPathToFileManagerKt.getDefaultPathQuery());
            if (pathInfo == null) {
                Responses.send$default((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)((HttpHeaders)extraHeaders), (int)4, null);
                return true;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        boolean indexUsed = false;
        if (pathInfo.isDirectory()) {
            VirtualFile indexVirtualFile = null;
            Path indexFile = null;
            if (pathInfo.getFile() == null) {
                Path path2 = pathInfo.getIoFile();
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                indexFile = BuiltInWebServerKt.findIndexFile(path2);
            } else {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile == null && indexVirtualFile == null) {
                Responses.send$default((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)((HttpHeaders)extraHeaders), (int)4, null);
                return true;
            }
            if (!FileUtilKt.endsWithSlash((String)decodedRawPath)) {
                WebServerPathHandlerKt.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path, (HttpHeaders)extraHeaders);
                return true;
            }
            indexUsed = true;
            pathInfo = new PathInfo(indexFile, indexVirtualFile, pathInfo.getRoot(), pathInfo.getModuleName(), pathInfo.isLibrary(), false, 32, null);
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        if (!indexUsed && !FileUtilKt.endsWithName((String)path, (String)pathInfo.getName())) {
            if (FileUtilKt.endsWithSlash((String)decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath((String)pathInfo.getPath());
                if (parentPath != null && FileUtilKt.endsWithName((String)path, (String)PathUtilRt.getFileName((String)parentPath))) {
                    WebServerPathHandlerKt.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path, (HttpHeaders)extraHeaders);
                    return true;
                }
            }
        }
        if (!DefaultWebServerPathHandlerKt.access$checkAccess(pathInfo, channel, (HttpRequest)request)) {
            return true;
        }
        String canonicalPath = indexUsed ? path + '/' + pathInfo.getName() : path;
        for (WebServerFileHandler fileHandler : WebServerFileHandler.Companion.getEP_NAME$intellij_platform_builtInServer_impl().getExtensionList()) {
            Logger $this$runAndLogException$iv = BuiltInWebServerKt.getLOG();
            boolean $i$f$runAndLogException = false;
            try {
                boolean bl = false;
                if (!fileHandler.process(pathInfo, canonicalPath, project, request, channel, isCustomHost ? null : projectName, (HttpHeaders)extraHeaders)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (CancellationException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (Throwable e$iv) {
                $this$runAndLogException$iv.error(e$iv);
            }
        }
        Responses.send$default((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)((HttpHeaders)extraHeaders), (int)4, null);
        return true;
    }
}

