/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.impl.YAMLAliasImpl;
import org.jetbrains.yaml.resolve.YAMLLocalResolveUtil;

public class YAMLAliasReference
extends PsiReferenceBase<YAMLAliasImpl> {
    public YAMLAliasReference(YAMLAliasImpl alias) {
        super((PsiElement)alias);
    }

    @Nullable
    public YAMLAnchor resolve() {
        return YAMLLocalResolveUtil.getResolveAliasMap(((YAMLAliasImpl)this.myElement).getContainingFile()).get(this.myElement);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        this.getIdentifier().replaceWithText(newElementName);
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return TextRange.from((int)this.getIdentifier().getStartOffsetInParent(), (int)this.getIdentifier().getTextLength());
    }

    @Contract(pure=true)
    @NotNull
    private LeafPsiElement getIdentifier() {
        return Objects.requireNonNull(((YAMLAliasImpl)this.myElement).getIdentifierPsi(), "Reference should not be created for aliases without name");
    }

    public Object @NotNull [] getVariants() {
        Collection<YAMLAnchor> defs = YAMLLocalResolveUtil.getFirstAnchorDefs(((YAMLAliasImpl)this.myElement).getContainingFile().getOriginalFile());
        return defs.toArray();
    }
}

