/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLBlockScalar;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public abstract class YAMLBlockScalarImpl
extends YAMLScalarImpl
implements YAMLBlockScalar {
    protected static final int DEFAULT_CONTENT_INDENT = 2;
    private static final int IMPLICIT_INDENT = -1;

    public YAMLBlockScalarImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    protected abstract IElementType getContentType();

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    @NotNull
    public String getTextValue() {
        String value = super.getTextValue();
        if (!value.isEmpty() && this.getChompingIndicator() != ChompingIndicator.STRIP) {
            value = value + "\n";
        }
        return value;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ChompingIndicator chomping;
        ASTNode firstContentChild = this.getFirstContentNode();
        if (firstContentChild == null) {
            return Collections.emptyList();
        }
        int myStart = this.getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int indent = this.locateIndent();
        ASTNode firstEol = TreeUtil.findSibling((ASTNode)firstContentChild, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);
        if (firstEol == null) {
            return Collections.emptyList();
        }
        int thisLineStart = firstEol.getStartOffset() + 1;
        for (ASTNode child = firstEol.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            TextRange childRange = child.getTextRange();
            if (childType == YAMLTokenTypes.INDENT && YAMLBlockScalarImpl.isEol(child.getTreePrev())) {
                thisLineStart = child.getStartOffset() + Math.min(indent, child.getTextLength());
                continue;
            }
            if (childType == YAMLTokenTypes.SCALAR_EOL) {
                if (thisLineStart != -1) {
                    result.add(TextRange.create((int)thisLineStart, (int)child.getStartOffset()).shiftRight(-myStart));
                }
                thisLineStart = child.getStartOffset() + 1;
                continue;
            }
            if (!YAMLBlockScalarImpl.isEol(child.getTreeNext())) continue;
            if (thisLineStart == -1) {
                Logger.getInstance(YAMLBlockScalarImpl.class).warn("thisLineStart == -1: '" + this.getText() + "'", new Throwable());
                continue;
            }
            result.add(TextRange.create((int)thisLineStart, (int)childRange.getEndOffset()).shiftRight(-myStart));
            thisLineStart = -1;
        }
        if (thisLineStart != -1) {
            result.add(TextRange.create((int)thisLineStart, (int)this.getTextRange().getEndOffset()).shiftRight(-myStart));
        }
        if ((chomping = this.getChompingIndicator()) == ChompingIndicator.KEEP) {
            return result;
        }
        int lastNonEmpty = ContainerUtil.lastIndexOf(result, range -> range.getLength() != 0);
        return lastNonEmpty == -1 ? Collections.emptyList() : result.subList(0, lastNonEmpty + 1);
    }

    @Override
    public boolean hasExplicitIndent() {
        return this.getExplicitIndent() != -1;
    }

    @Nullable
    public ASTNode getNthContentTypeChild(int nth) {
        int number = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != this.getContentType()) continue;
            if (number == nth) {
                return child;
            }
            ++number;
        }
        return null;
    }

    protected final int locateIndent() {
        int indent = this.getExplicitIndent();
        if (indent != -1) {
            return indent;
        }
        ASTNode firstLine = this.getNthContentTypeChild(1);
        if (firstLine != null) {
            return YAMLUtil.getIndentInThisLine(firstLine.getPsi());
        }
        return 0;
    }

    @NotNull
    protected final ChompingIndicator getChompingIndicator() {
        Boolean forceKeepChomping = (Boolean)this.getContainingFile().getOriginalFile().getUserData(FORCE_KEEP_CHOMPING);
        if (forceKeepChomping != null && forceKeepChomping.booleanValue()) {
            return ChompingIndicator.KEEP;
        }
        ASTNode headerNode = this.getNthContentTypeChild(0);
        assert (headerNode != null);
        String header = headerNode.getText();
        if (header.contains("+")) {
            return ChompingIndicator.KEEP;
        }
        if (header.contains("-")) {
            return ChompingIndicator.STRIP;
        }
        return ChompingIndicator.CLIP;
    }

    private int getExplicitIndent() {
        ASTNode headerNode = this.getNthContentTypeChild(0);
        assert (headerNode != null);
        String header = headerNode.getText();
        for (int i = 0; i < header.length(); ++i) {
            if (!Character.isDigit(header.charAt(i))) continue;
            int k = i + 1;
            if (k < header.length() && Character.isDigit(header.charAt(k))) {
                return -1;
            }
            int res = Integer.parseInt(header.substring(i, k));
            if (res == 0) {
                return -1;
            }
            return res;
        }
        return -1;
    }

    @Contract(value="null -> false")
    private static boolean isEol(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        return YAMLElementTypes.EOL_ELEMENTS.contains(node.getElementType());
    }

    protected static enum ChompingIndicator {
        CLIP,
        STRIP,
        KEEP;

    }
}

