/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YAMLKeysIndex;

public class YAMLKeysSearchEverywhereContributor
implements SearchEverywhereContributor<YAMLKeyNavigationItem> {
    private final Project myProject;

    public YAMLKeysSearchEverywhereContributor(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        return this.getClass().getSimpleName();
    }

    @NotNull
    public String getGroupName() {
        return YAMLBundle.message("YAMLKeysSearchEverywhereContributor.group.name", new Object[0]);
    }

    public int getSortWeight() {
        return 1000;
    }

    public boolean showInFindResults() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super YAMLKeyNavigationItem> consumer) {
        if (this.myProject == null || pattern.isEmpty()) {
            return;
        }
        Runnable task = () -> this.findKeys(consumer, pattern, progressIndicator);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.runReadAction(task);
        } else {
            if (application.isDispatchThread()) {
                throw new IllegalStateException("This method must not be called from EDT");
            }
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)task, (ProgressIndicator)progressIndicator);
        }
    }

    public boolean processSelectedItem(@NotNull YAMLKeyNavigationItem selected, int modifiers, @NotNull String searchText) {
        selected.navigate(true);
        return true;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public Object getDataForItem(@NotNull YAMLKeyNavigationItem element, @NotNull String dataId) {
        return null;
    }

    private void findKeys(@NotNull Processor<? super YAMLKeyNavigationItem> consumer, @NotNull String pattern, ProgressIndicator progressIndicator) {
        if (ActionUtil.isDumbMode((Project)this.myProject)) {
            return;
        }
        assert (this.myProject != null);
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(YAMLKeysIndex.KEY, this.myProject);
        List<String> sorted = YAMLKeysSearchEverywhereContributor.applyPattern(allKeys, pattern, progressIndicator);
        boolean everywhere = SearchEverywhereManager.getInstance((Project)this.myProject).isEverywhere();
        for (String name : sorted) {
            progressIndicator.checkCanceled();
            CommonProcessors.CollectProcessor files = new CommonProcessors.CollectProcessor();
            GlobalSearchScope filter = everywhere ? ProjectScope.getAllScope((Project)this.myProject) : ProjectScope.getProjectScope((Project)this.myProject);
            FileBasedIndex.getInstance().getFilesWithKey(YAMLKeysIndex.KEY, Collections.singleton(name), (Processor)files, filter);
            for (VirtualFile file : files.getResults()) {
                Navigatable navigatable;
                Integer position;
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile == null || (position = (Integer)FileBasedIndex.getInstance().getFileData(YAMLKeysIndex.KEY, file, this.myProject).get(name)) == null || consumer.process((Object)new YAMLKeyNavigationItem(navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, position.intValue()), name, file))) continue;
                return;
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    private static List<String> applyPattern(@NotNull Collection<String> keys, @NotNull String pattern, ProgressIndicator progressIndicator) {
        Int2ObjectOpenHashMap priority = new Int2ObjectOpenHashMap();
        for (String key : keys) {
            progressIndicator.checkCanceled();
            int start = key.indexOf(pattern);
            if (start == -1 || start > 0 && key.charAt(start - 1) != '.' || start + pattern.length() < key.length() && key.indexOf(".", start + pattern.length()) != -1) continue;
            int dots = YAMLKeysSearchEverywhereContributor.countDots(key, start);
            ((List)priority.computeIfAbsent(dots, __ -> new SmartList())).add(key);
        }
        progressIndicator.checkCanceled();
        IntArrayList listToSort = new IntArrayList((IntCollection)priority.keySet());
        listToSort.sort(null);
        ArrayList<String> result = new ArrayList<String>();
        IntListIterator iterator = listToSort.iterator();
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            List found = (List)priority.get(index);
            ArrayList toSort = new ArrayList(found);
            toSort.sort(null);
            result.addAll(toSort);
        }
        return result;
    }

    @Contract(pure=true)
    private static int countDots(@NotNull String path, int end) {
        int count = 0;
        for (int i = 0; i < end; ++i) {
            if (path.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<YAMLKeyNavigationItem> {
        @NotNull
        public SearchEverywhereContributor<YAMLKeyNavigationItem> createContributor(@NotNull AnActionEvent initEvent) {
            return new YAMLKeysSearchEverywhereContributor(initEvent.getProject());
        }
    }
}

